/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.EthereumTransactionData;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class EthereumTransactionDataLegacy
extends EthereumTransactionData {
    public byte[] chainId = new byte[0];
    public byte[] nonce;
    public byte[] gasPrice;
    public byte[] gasLimit;
    public byte[] to;
    public byte[] value;
    public byte[] v;
    public int recoveryId;
    public byte[] r;
    public byte[] s;

    EthereumTransactionDataLegacy(byte[] nonce, byte[] gasPrice, byte[] gasLimit, byte[] to, byte[] value, byte[] callData, byte[] v, byte[] r, byte[] s) {
        super(callData);
        this.nonce = nonce;
        this.gasPrice = gasPrice;
        this.gasLimit = gasLimit;
        this.to = to;
        this.value = value;
        this.v = v;
        this.r = r;
        this.s = s;
        BigInteger vBI = new BigInteger(1, this.v);
        int n = this.recoveryId = vBI.testBit(0) ? 0 : 1;
        if (vBI.compareTo(BigInteger.valueOf(34L)) > 0) {
            this.chainId = vBI.subtract(BigInteger.valueOf(35L)).shiftRight(1).toByteArray();
        }
    }

    public static EthereumTransactionDataLegacy fromBytes(byte[] bytes) {
        Iterator decoder = RLPDecoder.RLP_STRICT.sequenceIterator(bytes);
        RLPItem rlpItem = (RLPItem)decoder.next();
        List rlpList = rlpItem.asRLPList().elements();
        if (rlpList.size() != 9) {
            throw new IllegalArgumentException("expected 9 RLP encoded elements, found " + rlpList.size());
        }
        return new EthereumTransactionDataLegacy(((RLPItem)rlpList.get(0)).data(), ((RLPItem)rlpList.get(1)).asBytes(), ((RLPItem)rlpList.get(2)).data(), ((RLPItem)rlpList.get(3)).data(), ((RLPItem)rlpList.get(4)).data(), ((RLPItem)rlpList.get(5)).data(), ((RLPItem)rlpList.get(6)).asBytes(), ((RLPItem)rlpList.get(7)).data(), ((RLPItem)rlpList.get(8)).data());
    }

    @Override
    public byte[] toBytes() {
        return RLPEncoder.encodeAsList((Object[])new Object[]{this.nonce, this.gasPrice, this.gasLimit, this.to, this.value, this.callData, this.v, this.r, this.s});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("chainId", (Object)Hex.toHexString((byte[])this.chainId)).add("nonce", (Object)Hex.toHexString((byte[])this.nonce)).add("gasPrice", (Object)Hex.toHexString((byte[])this.gasPrice)).add("gasLimit", (Object)Hex.toHexString((byte[])this.gasLimit)).add("to", (Object)Hex.toHexString((byte[])this.to)).add("value", (Object)Hex.toHexString((byte[])this.value)).add("recoveryId", this.recoveryId).add("v", (Object)Hex.toHexString((byte[])this.v)).add("r", (Object)Hex.toHexString((byte[])this.r)).add("s", (Object)Hex.toHexString((byte[])this.s)).toString();
    }
}

