/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.proto.CryptoAllowance;
import com.hedera.hashgraph.sdk.proto.GrantedCryptoAllowance;
import java.util.Objects;
import javax.annotation.Nullable;

public class HbarAllowance {
    @Nullable
    public final AccountId ownerAccountId;
    @Nullable
    public final AccountId spenderAccountId;
    @Nullable
    public final Hbar amount;

    HbarAllowance(@Nullable AccountId ownerAccountId, @Nullable AccountId spenderAccountId, @Nullable Hbar amount) {
        this.ownerAccountId = ownerAccountId;
        this.spenderAccountId = spenderAccountId;
        this.amount = amount;
    }

    static HbarAllowance fromProtobuf(CryptoAllowance allowanceProto) {
        return new HbarAllowance(allowanceProto.hasOwner() ? AccountId.fromProtobuf(allowanceProto.getOwner()) : null, allowanceProto.hasSpender() ? AccountId.fromProtobuf(allowanceProto.getSpender()) : null, Hbar.fromTinybars(allowanceProto.getAmount()));
    }

    static HbarAllowance fromProtobuf(GrantedCryptoAllowance allowanceProto) {
        return new HbarAllowance(null, allowanceProto.hasSpender() ? AccountId.fromProtobuf(allowanceProto.getSpender()) : null, Hbar.fromTinybars(allowanceProto.getAmount()));
    }

    public static HbarAllowance fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return HbarAllowance.fromProtobuf(CryptoAllowance.parseFrom(Objects.requireNonNull(bytes)));
    }

    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.ownerAccountId != null) {
            this.ownerAccountId.validateChecksum(client);
        }
        if (this.spenderAccountId != null) {
            this.spenderAccountId.validateChecksum(client);
        }
    }

    CryptoAllowance toProtobuf() {
        CryptoAllowance.Builder builder = CryptoAllowance.newBuilder().setAmount(this.amount.toTinybars());
        if (this.ownerAccountId != null) {
            builder.setOwner(this.ownerAccountId.toProtobuf());
        }
        if (this.spenderAccountId != null) {
            builder.setSpender(this.spenderAccountId.toProtobuf());
        }
        return (CryptoAllowance)builder.build();
    }

    GrantedCryptoAllowance toGrantedProtobuf() {
        GrantedCryptoAllowance.Builder builder = GrantedCryptoAllowance.newBuilder().setAmount(this.amount.toTinybars());
        if (this.spenderAccountId != null) {
            builder.setSpender(this.spenderAccountId.toProtobuf());
        }
        return (GrantedCryptoAllowance)builder.build();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("ownerAccountId", (Object)this.ownerAccountId).add("spenderAccountId", (Object)this.spenderAccountId).add("amount", (Object)this.amount).toString();
    }
}

