/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SystemDeleteTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;

public final class SystemDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<SystemDeleteTransaction> {
    @Nullable
    private FileId fileId = null;
    @Nullable
    private ContractId contractId = null;
    @Nullable
    private Instant expirationTime = null;

    public SystemDeleteTransaction() {
    }

    SystemDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    SystemDeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public final FileId getFileId() {
        return this.fileId;
    }

    public SystemDeleteTransaction setFileId(FileId fileId) {
        Objects.requireNonNull(fileId);
        this.requireNotFrozen();
        this.fileId = fileId;
        return this;
    }

    @Nullable
    public final ContractId getContractId() {
        return this.contractId;
    }

    public SystemDeleteTransaction setContractId(ContractId contractId) {
        Objects.requireNonNull(contractId);
        this.requireNotFrozen();
        this.contractId = contractId;
        return this;
    }

    @Nullable
    public final Instant getExpirationTime() {
        return this.expirationTime;
    }

    public SystemDeleteTransaction setExpirationTime(Instant expirationTime) {
        Objects.requireNonNull(expirationTime);
        this.requireNotFrozen();
        this.expirationTime = expirationTime;
        return this;
    }

    SystemDeleteTransactionBody.Builder build() {
        SystemDeleteTransactionBody.Builder builder = SystemDeleteTransactionBody.newBuilder();
        if (this.fileId != null) {
            builder.setFileID(this.fileId.toProtobuf());
        }
        if (this.contractId != null) {
            builder.setContractID(this.contractId.toProtobuf());
        }
        if (this.expirationTime != null) {
            builder.setExpirationTime(InstantConverter.toSecondsProtobuf(this.expirationTime));
        }
        return builder;
    }

    void initFromTransactionBody() {
        SystemDeleteTransactionBody body = this.sourceTransactionBody.getSystemDelete();
        if (body.hasFileID()) {
            this.fileId = FileId.fromProtobuf(body.getFileID());
        }
        if (body.hasContractID()) {
            this.contractId = ContractId.fromProtobuf(body.getContractID());
        }
        if (body.hasExpirationTime()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpirationTime());
        }
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.fileId != null) {
            this.fileId.validateChecksum(client);
        }
        if (this.contractId != null) {
            this.contractId.validateChecksum(client);
        }
    }

    @Override
    CompletableFuture<Void> onExecuteAsync(Client client) {
        int modesEnabled = (this.fileId != null ? 1 : 0) + (this.contractId != null ? 1 : 0);
        if (modesEnabled != 1) {
            throw new IllegalStateException("SystemDeleteTransaction must have exactly 1 of the following fields set: contractId, fileId");
        }
        return super.onExecuteAsync(client);
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        if (this.fileId != null) {
            return FileServiceGrpc.getSystemDeleteMethod();
        }
        return SmartContractServiceGrpc.getSystemDeleteMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setSystemDelete(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setSystemDelete(this.build());
    }
}

