/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.NftTransfer;
import com.hedera.hashgraph.sdk.proto.TokenID;
import com.hedera.hashgraph.sdk.proto.TokenTransferList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenNftTransfer
implements Comparable<TokenNftTransfer> {
    public final TokenId tokenId;
    public final AccountId sender;
    public final AccountId receiver;
    public final long serial;
    public boolean isApproved;

    TokenNftTransfer(TokenId tokenId, AccountId sender, AccountId receiver, long serial, boolean isApproved) {
        this.tokenId = tokenId;
        this.sender = sender;
        this.receiver = receiver;
        this.serial = serial;
        this.isApproved = isApproved;
    }

    static ArrayList<TokenNftTransfer> fromProtobuf(List<TokenTransferList> tokenTransferList) {
        ArrayList<TokenNftTransfer> transfers = new ArrayList<TokenNftTransfer>();
        for (TokenTransferList tokenTransfer : tokenTransferList) {
            TokenId tokenId = TokenId.fromProtobuf(tokenTransfer.getToken());
            for (NftTransfer transfer : tokenTransfer.getNftTransfersList()) {
                transfers.add(new TokenNftTransfer(tokenId, AccountId.fromProtobuf(transfer.getSenderAccountID()), AccountId.fromProtobuf(transfer.getReceiverAccountID()), transfer.getSerialNumber(), transfer.getIsApproval()));
            }
        }
        return transfers;
    }

    @Deprecated
    public static TokenNftTransfer fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TokenNftTransfer.fromProtobuf(List.of((TokenTransferList)TokenTransferList.newBuilder().setToken((TokenID)TokenID.newBuilder().build()).addNftTransfers(NftTransfer.parseFrom(bytes)).build())).get(0);
    }

    NftTransfer toProtobuf() {
        return (NftTransfer)NftTransfer.newBuilder().setSenderAccountID(this.sender.toProtobuf()).setReceiverAccountID(this.receiver.toProtobuf()).setSerialNumber(this.serial).setIsApproval(this.isApproved).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tokenId", (Object)this.tokenId).add("sender", (Object)this.sender).add("receiver", (Object)this.receiver).add("serial", this.serial).add("isApproved", this.isApproved).toString();
    }

    @Deprecated
    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    @Override
    public int compareTo(TokenNftTransfer o) {
        int senderComparison = this.sender.compareTo(o.sender);
        if (senderComparison != 0) {
            return senderComparison;
        }
        int receiverComparison = this.receiver.compareTo(o.receiver);
        if (receiverComparison != 0) {
            return receiverComparison;
        }
        return Long.compare(this.serial, o.serial);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TokenNftTransfer)) {
            return false;
        }
        TokenNftTransfer otherTransfer = (TokenNftTransfer)o;
        return this.sender.equals(otherTransfer.sender) && this.receiver.equals(otherTransfer.receiver) && this.serial == otherTransfer.serial;
    }

    public int hashCode() {
        return Objects.hash(this.sender.hashCode(), this.receiver.hashCode(), this.serial);
    }
}

