/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountAllowanceApproveTransaction;
import com.hedera.hashgraph.sdk.AccountAllowanceDeleteTransaction;
import com.hedera.hashgraph.sdk.AccountCreateTransaction;
import com.hedera.hashgraph.sdk.AccountDeleteTransaction;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.AccountUpdateTransaction;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractCreateTransaction;
import com.hedera.hashgraph.sdk.ContractDeleteTransaction;
import com.hedera.hashgraph.sdk.ContractExecuteTransaction;
import com.hedera.hashgraph.sdk.ContractUpdateTransaction;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.EthereumTransaction;
import com.hedera.hashgraph.sdk.Executable;
import com.hedera.hashgraph.sdk.ExecutionState;
import com.hedera.hashgraph.sdk.FileAppendTransaction;
import com.hedera.hashgraph.sdk.FileCreateTransaction;
import com.hedera.hashgraph.sdk.FileDeleteTransaction;
import com.hedera.hashgraph.sdk.FileUpdateTransaction;
import com.hedera.hashgraph.sdk.FreezeTransaction;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.LiveHashAddTransaction;
import com.hedera.hashgraph.sdk.LiveHashDeleteTransaction;
import com.hedera.hashgraph.sdk.LockableList;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.ScheduleCreateTransaction;
import com.hedera.hashgraph.sdk.ScheduleDeleteTransaction;
import com.hedera.hashgraph.sdk.ScheduleSignTransaction;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.SystemDeleteTransaction;
import com.hedera.hashgraph.sdk.SystemUndeleteTransaction;
import com.hedera.hashgraph.sdk.TokenAssociateTransaction;
import com.hedera.hashgraph.sdk.TokenBurnTransaction;
import com.hedera.hashgraph.sdk.TokenCreateTransaction;
import com.hedera.hashgraph.sdk.TokenDeleteTransaction;
import com.hedera.hashgraph.sdk.TokenDissociateTransaction;
import com.hedera.hashgraph.sdk.TokenFeeScheduleUpdateTransaction;
import com.hedera.hashgraph.sdk.TokenFreezeTransaction;
import com.hedera.hashgraph.sdk.TokenGrantKycTransaction;
import com.hedera.hashgraph.sdk.TokenMintTransaction;
import com.hedera.hashgraph.sdk.TokenPauseTransaction;
import com.hedera.hashgraph.sdk.TokenRevokeKycTransaction;
import com.hedera.hashgraph.sdk.TokenUnfreezeTransaction;
import com.hedera.hashgraph.sdk.TokenUnpauseTransaction;
import com.hedera.hashgraph.sdk.TokenUpdateTransaction;
import com.hedera.hashgraph.sdk.TokenWipeTransaction;
import com.hedera.hashgraph.sdk.TopicCreateTransaction;
import com.hedera.hashgraph.sdk.TopicDeleteTransaction;
import com.hedera.hashgraph.sdk.TopicMessageSubmitTransaction;
import com.hedera.hashgraph.sdk.TopicUpdateTransaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransferTransaction;
import com.hedera.hashgraph.sdk.proto.Duration;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SignatureMap;
import com.hedera.hashgraph.sdk.proto.SignaturePair;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import com.hedera.hashgraph.sdk.proto.Timestamp;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import com.hedera.hashgraph.sdk.proto.TransactionList;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.bouncycastle.crypto.digests.SHA384Digest;

public abstract class Transaction<T extends Transaction<T>>
extends Executable<T, com.hedera.hashgraph.sdk.proto.Transaction, TransactionResponse, com.hedera.hashgraph.sdk.TransactionResponse> {
    static final Duration DEFAULT_AUTO_RENEW_PERIOD = Duration.ofDays(90L);
    private static final Duration DEFAULT_TRANSACTION_VALID_DURATION = Duration.ofSeconds(120L);
    protected final TransactionBody sourceTransactionBody;
    @Nullable
    protected TransactionBody.Builder frozenBodyBuilder = null;
    protected List<com.hedera.hashgraph.sdk.proto.Transaction> outerTransactions = Collections.emptyList();
    protected List<SignedTransaction.Builder> innerSignedTransactions = Collections.emptyList();
    protected List<SignatureMap.Builder> sigPairLists = Collections.emptyList();
    protected LockableList<TransactionId> transactionIds = new LockableList();
    protected List<PublicKey> publicKeys = new ArrayList<PublicKey>();
    protected List<Function<byte[], byte[]>> signers = new ArrayList<Function<byte[], byte[]>>();
    protected Hbar defaultMaxTransactionFee = new Hbar(2L);
    private Duration transactionValidDuration;
    @Nullable
    private Hbar maxTransactionFee = null;
    private String memo = "";
    protected Boolean regenerateTransactionId = null;

    Transaction() {
        this.setTransactionValidDuration(DEFAULT_TRANSACTION_VALID_DURATION);
        this.sourceTransactionBody = TransactionBody.getDefaultInstance();
    }

    Transaction(TransactionBody txBody) {
        this.setTransactionValidDuration(DEFAULT_TRANSACTION_VALID_DURATION);
        this.setMaxTransactionFee(Hbar.fromTinybars(txBody.getTransactionFee()));
        this.setTransactionMemo(txBody.getMemo());
        this.sourceTransactionBody = txBody;
    }

    Transaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>> txs) throws InvalidProtocolBufferException {
        int txCount = txs.keySet().size();
        int nodeCount = txs.values().iterator().next().size();
        this.nodeAccountIds.ensureCapacity(nodeCount);
        this.sigPairLists = new ArrayList<SignatureMap.Builder>(nodeCount * txCount);
        this.outerTransactions = new ArrayList<com.hedera.hashgraph.sdk.proto.Transaction>(nodeCount * txCount);
        this.innerSignedTransactions = new ArrayList<SignedTransaction.Builder>(nodeCount * txCount);
        this.transactionIds.ensureCapacity(txCount);
        for (Map.Entry<TransactionId, LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>> transactionEntry : txs.entrySet()) {
            this.transactionIds.add((TransactionId[])new TransactionId[]{transactionEntry.getKey()});
            for (Map.Entry<AccountId, com.hedera.hashgraph.sdk.proto.Transaction> nodeEntry : transactionEntry.getValue().entrySet()) {
                if (this.nodeAccountIds.size() != nodeCount) {
                    this.nodeAccountIds.add(nodeEntry.getKey());
                }
                SignedTransaction transaction = SignedTransaction.parseFrom(nodeEntry.getValue().getSignedTransactionBytes());
                this.outerTransactions.add(nodeEntry.getValue());
                this.sigPairLists.add((SignatureMap.Builder)transaction.getSigMap().toBuilder());
                this.innerSignedTransactions.add((SignedTransaction.Builder)transaction.toBuilder());
                if (!this.publicKeys.isEmpty()) continue;
                for (SignaturePair sigPair : transaction.getSigMap().getSigPairList()) {
                    this.publicKeys.add(PublicKey.fromBytes(sigPair.getPubKeyPrefix().toByteArray()));
                    this.signers.add(null);
                }
            }
        }
        this.nodeAccountIds.remove(new AccountId(0L)).setLocked(true);
        this.transactionIds.setLocked(true);
        for (int i = 0; i < txCount; ++i) {
            TransactionBody firstTxBody = null;
            for (int j = 0; j < nodeCount; ++j) {
                int k = i * nodeCount + j;
                TransactionBody txBody = TransactionBody.parseFrom(this.innerSignedTransactions.get(k).getBodyBytes());
                if (firstTxBody == null) {
                    firstTxBody = txBody;
                    continue;
                }
                Transaction.requireProtoMatches(firstTxBody, txBody, new HashSet<String>(Arrays.asList("NodeAccountID")), "TransactionBody");
            }
        }
        this.sourceTransactionBody = TransactionBody.parseFrom(this.innerSignedTransactions.get(0).getBodyBytes());
        this.setTransactionValidDuration(DurationConverter.fromProtobuf(this.sourceTransactionBody.getTransactionValidDuration()));
        this.setMaxTransactionFee(Hbar.fromTinybars(this.sourceTransactionBody.getTransactionFee()));
        this.setTransactionMemo(this.sourceTransactionBody.getMemo());
        this.frozenBodyBuilder = (TransactionBody.Builder)this.sourceTransactionBody.toBuilder();
    }

    public static Transaction<?> fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        LinkedHashMap<TransactionId, LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>> txs = new LinkedHashMap<TransactionId, LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>>();
        TransactionBody.DataCase dataCase = TransactionBody.DataCase.DATA_NOT_SET;
        TransactionList list = TransactionList.parseFrom(bytes);
        if (list.getTransactionListList().isEmpty()) {
            TransactionBody txBody;
            Transaction.Builder transaction = (Transaction.Builder)com.hedera.hashgraph.sdk.proto.Transaction.parseFrom(bytes).toBuilder();
            if (transaction.getSignedTransactionBytes().isEmpty()) {
                txBody = TransactionBody.parseFrom(transaction.getBodyBytes());
                transaction.setSignedTransactionBytes(((SignedTransaction)SignedTransaction.newBuilder().setBodyBytes(transaction.getBodyBytes()).setSigMap(transaction.getSigMap()).build()).toByteString()).clearBodyBytes().clearSigMap();
            } else {
                SignedTransaction signedTransaction = SignedTransaction.parseFrom(transaction.getSignedTransactionBytes());
                txBody = TransactionBody.parseFrom(signedTransaction.getBodyBytes());
            }
            dataCase = txBody.getDataCase();
            AccountId account = AccountId.fromProtobuf(txBody.getNodeAccountID());
            TransactionId transactionId = TransactionId.fromProtobuf(txBody.getTransactionID());
            LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction> linked = new LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>();
            linked.put(account, (com.hedera.hashgraph.sdk.proto.Transaction)transaction.build());
            txs.put(transactionId, linked);
        } else {
            for (com.hedera.hashgraph.sdk.proto.Transaction transaction : list.getTransactionListList()) {
                SignedTransaction signedTransaction = SignedTransaction.parseFrom(transaction.getSignedTransactionBytes());
                TransactionBody txBody = TransactionBody.parseFrom(signedTransaction.getBodyBytes());
                if (dataCase.getNumber() == TransactionBody.DataCase.DATA_NOT_SET.getNumber()) {
                    dataCase = txBody.getDataCase();
                }
                AccountId account = AccountId.fromProtobuf(txBody.getNodeAccountID());
                TransactionId transactionId = TransactionId.fromProtobuf(txBody.getTransactionID());
                LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction> linked = txs.containsKey(transactionId) ? Objects.requireNonNull(txs.get(transactionId)) : new LinkedHashMap<AccountId, com.hedera.hashgraph.sdk.proto.Transaction>();
                linked.put(account, transaction);
                txs.put(transactionId, linked);
            }
        }
        switch (dataCase) {
            case CONTRACTCALL: {
                return new ContractExecuteTransaction(txs);
            }
            case CONTRACTCREATEINSTANCE: {
                return new ContractCreateTransaction(txs);
            }
            case CONTRACTUPDATEINSTANCE: {
                return new ContractUpdateTransaction(txs);
            }
            case CONTRACTDELETEINSTANCE: {
                return new ContractDeleteTransaction(txs);
            }
            case ETHEREUMTRANSACTION: {
                return new EthereumTransaction(txs);
            }
            case CRYPTOADDLIVEHASH: {
                return new LiveHashAddTransaction(txs);
            }
            case CRYPTOCREATEACCOUNT: {
                return new AccountCreateTransaction(txs);
            }
            case CRYPTODELETE: {
                return new AccountDeleteTransaction(txs);
            }
            case CRYPTODELETELIVEHASH: {
                return new LiveHashDeleteTransaction(txs);
            }
            case CRYPTOTRANSFER: {
                return new TransferTransaction(txs);
            }
            case CRYPTOUPDATEACCOUNT: {
                return new AccountUpdateTransaction(txs);
            }
            case FILEAPPEND: {
                return new FileAppendTransaction(txs);
            }
            case FILECREATE: {
                return new FileCreateTransaction(txs);
            }
            case FILEDELETE: {
                return new FileDeleteTransaction(txs);
            }
            case FILEUPDATE: {
                return new FileUpdateTransaction(txs);
            }
            case SYSTEMDELETE: {
                return new SystemDeleteTransaction(txs);
            }
            case SYSTEMUNDELETE: {
                return new SystemUndeleteTransaction(txs);
            }
            case FREEZE: {
                return new FreezeTransaction(txs);
            }
            case CONSENSUSCREATETOPIC: {
                return new TopicCreateTransaction(txs);
            }
            case CONSENSUSUPDATETOPIC: {
                return new TopicUpdateTransaction(txs);
            }
            case CONSENSUSDELETETOPIC: {
                return new TopicDeleteTransaction(txs);
            }
            case CONSENSUSSUBMITMESSAGE: {
                return new TopicMessageSubmitTransaction(txs);
            }
            case TOKENASSOCIATE: {
                return new TokenAssociateTransaction(txs);
            }
            case TOKENBURN: {
                return new TokenBurnTransaction(txs);
            }
            case TOKENCREATION: {
                return new TokenCreateTransaction(txs);
            }
            case TOKENDELETION: {
                return new TokenDeleteTransaction(txs);
            }
            case TOKENDISSOCIATE: {
                return new TokenDissociateTransaction(txs);
            }
            case TOKENFREEZE: {
                return new TokenFreezeTransaction(txs);
            }
            case TOKENGRANTKYC: {
                return new TokenGrantKycTransaction(txs);
            }
            case TOKENMINT: {
                return new TokenMintTransaction(txs);
            }
            case TOKENREVOKEKYC: {
                return new TokenRevokeKycTransaction(txs);
            }
            case TOKENUNFREEZE: {
                return new TokenUnfreezeTransaction(txs);
            }
            case TOKENUPDATE: {
                return new TokenUpdateTransaction(txs);
            }
            case TOKENWIPE: {
                return new TokenWipeTransaction(txs);
            }
            case TOKEN_FEE_SCHEDULE_UPDATE: {
                return new TokenFeeScheduleUpdateTransaction(txs);
            }
            case SCHEDULECREATE: {
                return new ScheduleCreateTransaction(txs);
            }
            case SCHEDULEDELETE: {
                return new ScheduleDeleteTransaction(txs);
            }
            case SCHEDULESIGN: {
                return new ScheduleSignTransaction(txs);
            }
            case TOKEN_PAUSE: {
                return new TokenPauseTransaction(txs);
            }
            case TOKEN_UNPAUSE: {
                return new TokenUnpauseTransaction(txs);
            }
            case CRYPTOAPPROVEALLOWANCE: {
                return new AccountAllowanceApproveTransaction(txs);
            }
            case CRYPTODELETEALLOWANCE: {
                return new AccountAllowanceDeleteTransaction(txs);
            }
        }
        throw new IllegalArgumentException("parsed transaction body has no data");
    }

    public static Transaction<?> fromScheduledTransaction(SchedulableTransactionBody scheduled) {
        TransactionBody.Builder body = TransactionBody.newBuilder().setMemo(scheduled.getMemo()).setTransactionFee(scheduled.getTransactionFee());
        switch (scheduled.getDataCase()) {
            case CONTRACTCALL: {
                return new ContractExecuteTransaction((TransactionBody)body.setContractCall(scheduled.getContractCall()).build());
            }
            case CONTRACTCREATEINSTANCE: {
                return new ContractCreateTransaction((TransactionBody)body.setContractCreateInstance(scheduled.getContractCreateInstance()).build());
            }
            case CONTRACTUPDATEINSTANCE: {
                return new ContractUpdateTransaction((TransactionBody)body.setContractUpdateInstance(scheduled.getContractUpdateInstance()).build());
            }
            case CONTRACTDELETEINSTANCE: {
                return new ContractDeleteTransaction((TransactionBody)body.setContractDeleteInstance(scheduled.getContractDeleteInstance()).build());
            }
            case CRYPTOAPPROVEALLOWANCE: {
                return new AccountAllowanceApproveTransaction((TransactionBody)body.setCryptoApproveAllowance(scheduled.getCryptoApproveAllowance()).build());
            }
            case CRYPTODELETEALLOWANCE: {
                return new AccountAllowanceDeleteTransaction((TransactionBody)body.setCryptoDeleteAllowance(scheduled.getCryptoDeleteAllowance()).build());
            }
            case CRYPTOCREATEACCOUNT: {
                return new AccountCreateTransaction((TransactionBody)body.setCryptoCreateAccount(scheduled.getCryptoCreateAccount()).build());
            }
            case CRYPTODELETE: {
                return new AccountDeleteTransaction((TransactionBody)body.setCryptoDelete(scheduled.getCryptoDelete()).build());
            }
            case CRYPTOTRANSFER: {
                return new TransferTransaction((TransactionBody)body.setCryptoTransfer(scheduled.getCryptoTransfer()).build());
            }
            case CRYPTOUPDATEACCOUNT: {
                return new AccountUpdateTransaction((TransactionBody)body.setCryptoUpdateAccount(scheduled.getCryptoUpdateAccount()).build());
            }
            case FILEAPPEND: {
                return new FileAppendTransaction((TransactionBody)body.setFileAppend(scheduled.getFileAppend()).build());
            }
            case FILECREATE: {
                return new FileCreateTransaction((TransactionBody)body.setFileCreate(scheduled.getFileCreate()).build());
            }
            case FILEDELETE: {
                return new FileDeleteTransaction((TransactionBody)body.setFileDelete(scheduled.getFileDelete()).build());
            }
            case FILEUPDATE: {
                return new FileUpdateTransaction((TransactionBody)body.setFileUpdate(scheduled.getFileUpdate()).build());
            }
            case SYSTEMDELETE: {
                return new SystemUndeleteTransaction((TransactionBody)body.setSystemDelete(scheduled.getSystemDelete()).build());
            }
            case SYSTEMUNDELETE: {
                return new SystemDeleteTransaction((TransactionBody)body.setSystemUndelete(scheduled.getSystemUndelete()).build());
            }
            case FREEZE: {
                return new FreezeTransaction((TransactionBody)body.setFreeze(scheduled.getFreeze()).build());
            }
            case CONSENSUSCREATETOPIC: {
                return new TopicCreateTransaction((TransactionBody)body.setConsensusCreateTopic(scheduled.getConsensusCreateTopic()).build());
            }
            case CONSENSUSUPDATETOPIC: {
                return new TopicUpdateTransaction((TransactionBody)body.setConsensusUpdateTopic(scheduled.getConsensusUpdateTopic()).build());
            }
            case CONSENSUSDELETETOPIC: {
                return new TopicDeleteTransaction((TransactionBody)body.setConsensusDeleteTopic(scheduled.getConsensusDeleteTopic()).build());
            }
            case CONSENSUSSUBMITMESSAGE: {
                return new TopicMessageSubmitTransaction((TransactionBody)body.setConsensusSubmitMessage(scheduled.getConsensusSubmitMessage()).build());
            }
            case TOKENCREATION: {
                return new TokenCreateTransaction((TransactionBody)body.setTokenCreation(scheduled.getTokenCreation()).build());
            }
            case TOKENFREEZE: {
                return new TokenFreezeTransaction((TransactionBody)body.setTokenFreeze(scheduled.getTokenFreeze()).build());
            }
            case TOKENUNFREEZE: {
                return new TokenUnfreezeTransaction((TransactionBody)body.setTokenUnfreeze(scheduled.getTokenUnfreeze()).build());
            }
            case TOKENGRANTKYC: {
                return new TokenGrantKycTransaction((TransactionBody)body.setTokenGrantKyc(scheduled.getTokenGrantKyc()).build());
            }
            case TOKENREVOKEKYC: {
                return new TokenRevokeKycTransaction((TransactionBody)body.setTokenRevokeKyc(scheduled.getTokenRevokeKyc()).build());
            }
            case TOKENDELETION: {
                return new TokenDeleteTransaction((TransactionBody)body.setTokenDeletion(scheduled.getTokenDeletion()).build());
            }
            case TOKENUPDATE: {
                return new TokenUpdateTransaction((TransactionBody)body.setTokenUpdate(scheduled.getTokenUpdate()).build());
            }
            case TOKENMINT: {
                return new TokenMintTransaction((TransactionBody)body.setTokenMint(scheduled.getTokenMint()).build());
            }
            case TOKENBURN: {
                return new TokenBurnTransaction((TransactionBody)body.setTokenBurn(scheduled.getTokenBurn()).build());
            }
            case TOKENWIPE: {
                return new TokenWipeTransaction((TransactionBody)body.setTokenWipe(scheduled.getTokenWipe()).build());
            }
            case TOKENASSOCIATE: {
                return new TokenAssociateTransaction((TransactionBody)body.setTokenAssociate(scheduled.getTokenAssociate()).build());
            }
            case TOKENDISSOCIATE: {
                return new TokenDissociateTransaction((TransactionBody)body.setTokenDissociate(scheduled.getTokenDissociate()).build());
            }
            case TOKEN_FEE_SCHEDULE_UPDATE: {
                return new TokenFeeScheduleUpdateTransaction((TransactionBody)body.setTokenFeeScheduleUpdate(scheduled.getTokenFeeScheduleUpdate()).build());
            }
            case TOKEN_PAUSE: {
                return new TokenPauseTransaction((TransactionBody)body.setTokenPause(scheduled.getTokenPause()).build());
            }
            case TOKEN_UNPAUSE: {
                return new TokenUnpauseTransaction((TransactionBody)body.setTokenUnpause(scheduled.getTokenUnpause()).build());
            }
            case SCHEDULEDELETE: {
                return new ScheduleDeleteTransaction((TransactionBody)body.setScheduleDelete(scheduled.getScheduleDelete()).build());
            }
        }
        throw new IllegalStateException("schedulable transaction did not have a transaction set");
    }

    private static void throwProtoMatchException(String fieldName, String aWas, String bWas) {
        throw new IllegalArgumentException("fromBytes() failed because " + fieldName + " fields in TransactionBody protobuf messages in the TransactionList did not match: A was " + aWas + ", B was " + bWas);
    }

    private static void requireProtoMatches(Object protoA, Object protoB, Set<String> ignoreSet, String thisFieldName) {
        Class<?> protoBClass;
        boolean bIsNull;
        boolean aIsNull = protoA == null;
        boolean bl = bIsNull = protoB == null;
        if (aIsNull != bIsNull) {
            Transaction.throwProtoMatchException(thisFieldName, aIsNull ? "null" : "not null", bIsNull ? "null" : "not null");
        }
        if (aIsNull) {
            return;
        }
        Class<?> protoAClass = protoA.getClass();
        if (!protoAClass.equals(protoBClass = protoB.getClass())) {
            Transaction.throwProtoMatchException(thisFieldName, "of class " + protoAClass, "of class " + protoBClass);
        }
        if ((protoA instanceof Boolean || protoA instanceof Integer || protoA instanceof Long || protoA instanceof Float || protoA instanceof Double || protoA instanceof String || protoA instanceof ByteString) && !protoA.equals(protoB)) {
            Transaction.throwProtoMatchException(thisFieldName, protoA.toString(), protoB.toString());
        }
        for (Method method : protoAClass.getDeclaredMethods()) {
            String methodName;
            int methodModifiers;
            if (method.getParameterCount() != 0 || !Modifier.isPublic(methodModifiers = method.getModifiers()) || Modifier.isStatic(methodModifiers) || !(methodName = method.getName()).startsWith("get")) continue;
            boolean isList = methodName.endsWith("List") && List.class.isAssignableFrom(method.getReturnType());
            String methodFieldName = methodName.substring(3, methodName.length() - (isList ? 4 : 0));
            if (ignoreSet.contains(methodFieldName) || methodFieldName.equals("DefaultInstance")) continue;
            if (!isList) {
                try {
                    Method hasMethod = protoAClass.getMethod("has" + methodFieldName, new Class[0]);
                    Boolean hasA = (Boolean)hasMethod.invoke(protoA, new Object[0]);
                    Boolean hasB = (Boolean)hasMethod.invoke(protoB, new Object[0]);
                    if (!hasA.equals(hasB)) {
                        Transaction.throwProtoMatchException(methodFieldName, hasA != false ? "present" : "not present", hasB != false ? "present" : "not present");
                    }
                    if (!hasA.booleanValue()) {
                        continue;
                    }
                }
                catch (NoSuchMethodException hasMethod) {
                }
                catch (IllegalArgumentException error) {
                    throw error;
                }
                catch (Throwable error) {
                    throw new IllegalArgumentException("fromBytes() failed due to error", error);
                }
            }
            try {
                Object retvalA = method.invoke(protoA, new Object[0]);
                Object retvalB = method.invoke(protoB, new Object[0]);
                if (isList) {
                    List listA = (List)retvalA;
                    List listB = (List)retvalB;
                    if (listA.size() != listB.size()) {
                        Transaction.throwProtoMatchException(methodFieldName, "of size " + listA.size(), "of size " + listB.size());
                    }
                    for (int i = 0; i < listA.size(); ++i) {
                        Transaction.requireProtoMatches(listA.get(i), listB.get(i), ignoreSet, methodFieldName + "[" + i + "]");
                    }
                    continue;
                }
                Transaction.requireProtoMatches(retvalA, retvalB, ignoreSet, methodFieldName);
            }
            catch (IllegalArgumentException error) {
                throw error;
            }
            catch (Throwable error) {
                throw new IllegalArgumentException("fromBytes() failed due to error", error);
            }
        }
    }

    static byte[] hash(byte[] bytes) {
        SHA384Digest digest = new SHA384Digest();
        byte[] hash = new byte[digest.getDigestSize()];
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(hash, 0);
        return hash;
    }

    protected ScheduleCreateTransaction doSchedule(TransactionBody.Builder bodyBuilder) {
        SchedulableTransactionBody.Builder schedulable = SchedulableTransactionBody.newBuilder().setTransactionFee(bodyBuilder.getTransactionFee()).setMemo(bodyBuilder.getMemo());
        this.onScheduled(schedulable);
        ScheduleCreateTransaction scheduled = new ScheduleCreateTransaction().setScheduledTransactionBody((SchedulableTransactionBody)schedulable.build());
        if (!this.transactionIds.isEmpty()) {
            scheduled.setTransactionId(this.transactionIds.get(0));
        }
        return scheduled;
    }

    public ScheduleCreateTransaction schedule() {
        this.requireNotFrozen();
        if (!this.nodeAccountIds.isEmpty()) {
            throw new IllegalStateException("The underlying transaction for a scheduled transaction cannot have node account IDs set");
        }
        TransactionBody.Builder bodyBuilder = this.spawnBodyBuilder(null);
        this.onFreeze(bodyBuilder);
        return this.doSchedule(bodyBuilder);
    }

    @Override
    public final T setNodeAccountIds(List<AccountId> nodeAccountIds) {
        this.requireNotFrozen();
        Objects.requireNonNull(nodeAccountIds);
        return (T)((Transaction)super.setNodeAccountIds(nodeAccountIds));
    }

    @Nullable
    public final Duration getTransactionValidDuration() {
        return this.transactionValidDuration;
    }

    public final T setTransactionValidDuration(Duration validDuration) {
        this.requireNotFrozen();
        Objects.requireNonNull(validDuration);
        this.transactionValidDuration = validDuration;
        return (T)this;
    }

    @Nullable
    public final Hbar getMaxTransactionFee() {
        return this.maxTransactionFee;
    }

    public final T setMaxTransactionFee(Hbar maxTransactionFee) {
        this.requireNotFrozen();
        Objects.requireNonNull(maxTransactionFee);
        this.maxTransactionFee = maxTransactionFee;
        return (T)this;
    }

    public final Hbar getDefaultMaxTransactionFee() {
        return this.defaultMaxTransactionFee;
    }

    public final String getTransactionMemo() {
        return this.memo;
    }

    public final T setTransactionMemo(String memo) {
        this.requireNotFrozen();
        Objects.requireNonNull(memo);
        this.memo = memo;
        return (T)this;
    }

    public byte[] toBytes() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before conversion to bytes will be stable, try calling `freeze`");
        }
        this.buildAllTransactions();
        TransactionList.Builder list = TransactionList.newBuilder();
        for (com.hedera.hashgraph.sdk.proto.Transaction transaction : this.outerTransactions) {
            list.addTransactionList(transaction);
        }
        return ((TransactionList)list.build()).toByteArray();
    }

    public byte[] getTransactionHash() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before calculating the hash will be stable, try calling `freeze`");
        }
        this.transactionIds.setLocked(true);
        this.nodeAccountIds.setLocked(true);
        int index = this.transactionIds.getIndex() * this.nodeAccountIds.size() + this.nodeAccountIds.getIndex();
        this.buildTransaction(index);
        return Transaction.hash(this.outerTransactions.get(index).getSignedTransactionBytes().toByteArray());
    }

    public Map<AccountId, byte[]> getTransactionHashPerNode() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before calculating the hash will be stable, try calling `freeze`");
        }
        this.buildAllTransactions();
        HashMap<AccountId, byte[]> hashes = new HashMap<AccountId, byte[]>();
        for (int i = 0; i < this.outerTransactions.size(); ++i) {
            hashes.put((AccountId)this.nodeAccountIds.get(i), Transaction.hash(this.outerTransactions.get(i).getSignedTransactionBytes().toByteArray()));
        }
        return hashes;
    }

    @Override
    final TransactionId getTransactionIdInternal() {
        return this.transactionIds.getCurrent();
    }

    public final TransactionId getTransactionId() {
        if (this.transactionIds.isEmpty() || !this.isFrozen()) {
            throw new IllegalStateException("transaction must have been frozen before getting the transaction ID, try calling `freeze`");
        }
        return this.transactionIds.setLocked(true).getCurrent();
    }

    public final T setTransactionId(TransactionId transactionId) {
        this.requireNotFrozen();
        this.transactionIds.setList(Collections.singletonList(transactionId)).setLocked(true);
        return (T)this;
    }

    public final Boolean getRegenerateTransactionId() {
        return this.regenerateTransactionId;
    }

    public final T setRegenerateTransactionId(boolean regenerateTransactionId) {
        this.regenerateTransactionId = regenerateTransactionId;
        return (T)this;
    }

    public final T sign(PrivateKey privateKey) {
        return this.signWith(privateKey.getPublicKey(), privateKey::sign);
    }

    public T signWith(PublicKey publicKey, Function<byte[], byte[]> transactionSigner) {
        if (!this.isFrozen()) {
            throw new IllegalStateException("Signing requires transaction to be frozen");
        }
        if (this.keyAlreadySigned(publicKey)) {
            return (T)this;
        }
        for (int i = 0; i < this.outerTransactions.size(); ++i) {
            this.outerTransactions.set(i, null);
        }
        this.publicKeys.add(publicKey);
        this.signers.add(transactionSigner);
        return (T)this;
    }

    public T signWithOperator(Client client) {
        Client.Operator operator = client.getOperator();
        if (operator == null) {
            throw new IllegalStateException("`client` must have an `operator` to sign with the operator");
        }
        if (!this.isFrozen()) {
            this.freezeWith(client);
        }
        return this.signWith(operator.publicKey, operator.transactionSigner);
    }

    protected boolean keyAlreadySigned(PublicKey key) {
        return this.publicKeys.contains(key);
    }

    public T addSignature(PublicKey publicKey, byte[] signature) {
        this.requireOneNodeAccountId();
        if (!this.isFrozen()) {
            throw new IllegalStateException("Adding signature requires transaction to be frozen");
        }
        if (this.keyAlreadySigned(publicKey)) {
            return (T)this;
        }
        this.transactionIds.setLocked(true);
        this.nodeAccountIds.setLocked(true);
        for (int i = 0; i < this.outerTransactions.size(); ++i) {
            this.outerTransactions.set(i, null);
        }
        this.publicKeys.add(publicKey);
        this.signers.add(null);
        this.sigPairLists.get(0).addSigPair(publicKey.toSignaturePairProtobuf(signature));
        return (T)this;
    }

    protected Map<AccountId, Map<PublicKey, byte[]>> getSignaturesAtOffset(int offset) {
        HashMap<AccountId, Map<PublicKey, byte[]>> map = new HashMap<AccountId, Map<PublicKey, byte[]>>(this.nodeAccountIds.size());
        for (int i = 0; i < this.nodeAccountIds.size(); ++i) {
            SignatureMap.Builder sigMap = this.sigPairLists.get(i + offset);
            AccountId nodeAccountId = (AccountId)this.nodeAccountIds.get(i);
            Map<Object, Object> keyMap = map.containsKey(nodeAccountId) ? Objects.requireNonNull(map.get(nodeAccountId)) : new HashMap(sigMap.getSigPairCount());
            map.put(nodeAccountId, keyMap);
            for (SignaturePair sigPair : sigMap.getSigPairList()) {
                keyMap.put(PublicKey.fromBytes(sigPair.getPubKeyPrefix().toByteArray()), sigPair.getEd25519().toByteArray());
            }
        }
        return map;
    }

    public Map<AccountId, Map<PublicKey, byte[]>> getSignatures() {
        if (this.publicKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        this.buildAllTransactions();
        return this.getSignaturesAtOffset(0);
    }

    protected boolean isFrozen() {
        return this.frozenBodyBuilder != null;
    }

    protected void requireNotFrozen() {
        if (this.isFrozen()) {
            throw new IllegalStateException("transaction is immutable; it has at least one signature or has been explicitly frozen");
        }
    }

    protected void requireOneNodeAccountId() {
        if (this.nodeAccountIds.size() != 1) {
            throw new IllegalStateException("transaction did not have exactly one node ID set");
        }
    }

    protected TransactionBody.Builder spawnBodyBuilder(@Nullable Client client) {
        Hbar clientDefaultFee = client != null ? client.getDefaultMaxTransactionFee() : null;
        Hbar defaultFee = clientDefaultFee != null ? clientDefaultFee : this.defaultMaxTransactionFee;
        Hbar feeHbars = this.maxTransactionFee != null ? this.maxTransactionFee : defaultFee;
        return TransactionBody.newBuilder().setTransactionFee(feeHbars.toTinybars()).setTransactionValidDuration((Duration.Builder)DurationConverter.toProtobuf(this.transactionValidDuration).toBuilder()).setMemo(this.memo);
    }

    public T freeze() {
        return this.freezeWith(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T freezeWith(@Nullable Client client) {
        if (this.isFrozen()) {
            return (T)this;
        }
        if (this.transactionIds.isEmpty()) {
            if (client == null) throw new IllegalStateException("Transaction ID must be set, or operator must be provided via freezeWith()");
            Client.Operator operator = client.getOperator();
            if (operator == null) throw new IllegalStateException("`client` must have an `operator` or `transactionId` must be set");
            this.transactionIds.setList(Collections.singletonList(TransactionId.generate(operator.accountId)));
        }
        if (this.nodeAccountIds.isEmpty()) {
            if (client == null) {
                throw new IllegalStateException("`client` must be provided or both `nodeId` and `transactionId` must be set");
            }
            try {
                this.nodeAccountIds.setList(client.network.getNodeAccountIdsForExecute());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        this.frozenBodyBuilder = this.spawnBodyBuilder(client).setTransactionID(this.transactionIds.get(0).toProtobuf());
        this.onFreeze(this.frozenBodyBuilder);
        int requiredChunks = this.getRequiredChunks();
        this.generateTransactionIds(this.transactionIds.get(0), requiredChunks);
        this.wipeTransactionLists(requiredChunks);
        Boolean clientDefaultRegenerateTransactionId = client != null ? Boolean.valueOf(client.getDefaultRegenerateTransactionId()) : null;
        this.regenerateTransactionId = this.regenerateTransactionId != null ? this.regenerateTransactionId : clientDefaultRegenerateTransactionId;
        return (T)this;
    }

    int getRequiredChunks() {
        return 1;
    }

    void generateTransactionIds(TransactionId initialTransactionId, int count) {
        boolean locked = this.transactionIds.isLocked();
        this.transactionIds.setLocked(false);
        if (count == 1) {
            this.transactionIds.setList(Collections.singletonList(initialTransactionId));
            return;
        }
        TransactionID.Builder nextTransactionId = (TransactionID.Builder)initialTransactionId.toProtobuf().toBuilder();
        this.transactionIds.ensureCapacity(count);
        this.transactionIds.clear();
        for (int i = 0; i < count; ++i) {
            this.transactionIds.add((TransactionId[])new TransactionId[]{TransactionId.fromProtobuf((TransactionID)nextTransactionId.build())});
            Timestamp.Builder nextValidStart = (Timestamp.Builder)nextTransactionId.getTransactionValidStart().toBuilder();
            nextValidStart.setNanos(nextValidStart.getNanos() + 1);
            nextTransactionId.setTransactionValidStart(nextValidStart);
        }
        this.transactionIds.setLocked(locked);
    }

    void wipeTransactionLists(int requiredChunks) {
        Objects.requireNonNull(this.frozenBodyBuilder).setTransactionID(this.getTransactionIdInternal().toProtobuf());
        this.outerTransactions = new ArrayList<com.hedera.hashgraph.sdk.proto.Transaction>(this.nodeAccountIds.size());
        this.sigPairLists = new ArrayList<SignatureMap.Builder>(this.nodeAccountIds.size());
        this.innerSignedTransactions = new ArrayList<SignedTransaction.Builder>(this.nodeAccountIds.size());
        for (AccountId nodeId : this.nodeAccountIds) {
            this.sigPairLists.add(SignatureMap.newBuilder());
            this.innerSignedTransactions.add(SignedTransaction.newBuilder().setBodyBytes(((TransactionBody)Objects.requireNonNull(this.frozenBodyBuilder).setNodeAccountID(nodeId.toProtobuf()).build()).toByteString()));
            this.outerTransactions.add(null);
        }
    }

    void buildAllTransactions() {
        this.transactionIds.setLocked(true);
        this.nodeAccountIds.setLocked(true);
        for (int i = 0; i < this.innerSignedTransactions.size(); ++i) {
            this.buildTransaction(i);
        }
    }

    void buildTransaction(int index) {
        if (this.outerTransactions.get(index) != null && !this.outerTransactions.get(index).getSignedTransactionBytes().isEmpty()) {
            return;
        }
        this.signTransaction(index);
        this.outerTransactions.set(index, (com.hedera.hashgraph.sdk.proto.Transaction)com.hedera.hashgraph.sdk.proto.Transaction.newBuilder().setSignedTransactionBytes(((SignedTransaction)this.innerSignedTransactions.get(index).setSigMap(this.sigPairLists.get(index)).build()).toByteString()).build());
    }

    private static boolean publicKeyIsInSigPairList(ByteString publicKeyBytes, List<SignaturePair> sigPairList) {
        for (SignaturePair pair : sigPairList) {
            if (!pair.getPubKeyPrefix().equals((Object)publicKeyBytes)) continue;
            return true;
        }
        return false;
    }

    void signTransaction(int index) {
        byte[] bodyBytes = this.innerSignedTransactions.get(index).getBodyBytes().toByteArray();
        List<SignaturePair> thisSigPairList = this.sigPairLists.get(index).getSigPairList();
        for (int i = 0; i < this.publicKeys.size(); ++i) {
            if (this.signers.get(i) == null || Transaction.publicKeyIsInSigPairList(ByteString.copyFrom((byte[])this.publicKeys.get(i).toBytesRaw()), thisSigPairList)) continue;
            byte[] signatureBytes = this.signers.get(i).apply(bodyBytes);
            this.sigPairLists.get(index).addSigPair(this.publicKeys.get(i).toSignaturePairProtobuf(signatureBytes));
        }
    }

    abstract void onFreeze(TransactionBody.Builder var1);

    abstract void onScheduled(SchedulableTransactionBody.Builder var1);

    @Override
    final com.hedera.hashgraph.sdk.proto.Transaction makeRequest() {
        int index = this.nodeAccountIds.getIndex() + this.transactionIds.getIndex() * this.nodeAccountIds.size();
        this.buildTransaction(index);
        return this.outerTransactions.get(index);
    }

    @Override
    com.hedera.hashgraph.sdk.TransactionResponse mapResponse(TransactionResponse transactionResponse, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Transaction request) {
        TransactionId transactionId = Objects.requireNonNull(this.getTransactionIdInternal());
        byte[] hash = Transaction.hash(request.getSignedTransactionBytes().toByteArray());
        this.transactionIds.advance();
        return new com.hedera.hashgraph.sdk.TransactionResponse(nodeId, transactionId, hash, null);
    }

    @Override
    final Status mapResponseStatus(TransactionResponse transactionResponse) {
        return Status.valueOf(transactionResponse.getNodeTransactionPrecheckCode());
    }

    abstract void validateChecksums(Client var1) throws BadEntityIdException;

    @Override
    void onExecute(Client client) {
        AccountId operatorId;
        if (!this.isFrozen()) {
            this.freezeWith(client);
        }
        AccountId accountId = Objects.requireNonNull(Objects.requireNonNull(this.transactionIds.get((int)0)).accountId);
        if (client.isAutoValidateChecksumsEnabled()) {
            try {
                accountId.validateChecksum(client);
                this.validateChecksums(client);
            }
            catch (BadEntityIdException exc) {
                throw new IllegalArgumentException(exc.getMessage());
            }
        }
        if ((operatorId = client.getOperatorAccountId()) != null && operatorId.equals(accountId)) {
            this.signWithOperator(client);
        }
    }

    @Override
    CompletableFuture<Void> onExecuteAsync(Client client) {
        this.onExecute(client);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    ExecutionState shouldRetry(Status status, TransactionResponse response) {
        switch (status) {
            case TRANSACTION_EXPIRED: {
                if (this.regenerateTransactionId != null && !this.regenerateTransactionId.booleanValue() || this.transactionIds.isLocked()) {
                    return ExecutionState.RequestError;
                }
                TransactionId firstTransactionId = Objects.requireNonNull(this.transactionIds.get(0));
                AccountId accountId = Objects.requireNonNull(firstTransactionId.accountId);
                this.generateTransactionIds(TransactionId.generate(accountId), this.transactionIds.size());
                this.wipeTransactionLists(this.transactionIds.size());
                return ExecutionState.Retry;
            }
        }
        return super.shouldRetry(status, response);
    }

    public String toString() {
        TransactionBody.Builder body = this.spawnBodyBuilder(null);
        if (!this.transactionIds.isEmpty()) {
            body.setTransactionID(this.transactionIds.get(0).toProtobuf());
        }
        if (!this.nodeAccountIds.isEmpty()) {
            body.setNodeAccountID(((AccountId)this.nodeAccountIds.get(0)).toProtobuf());
        }
        this.onFreeze(body);
        return ((TransactionBody)body.buildPartial()).toString().replaceAll("@[A-Za-z0-9]+", "");
    }
}

