/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.proto.ContractID;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public class ContractId
extends Key
implements Comparable<ContractId> {
    static final Pattern EVM_ADDRESS_REGEX = Pattern.compile("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.([a-fA-F0-9]{40}$)");
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;
    @Nullable
    private final String checksum;
    @Nullable
    public final byte[] evmAddress;

    public ContractId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public ContractId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this(shard, realm, num, null);
    }

    ContractId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
        this.evmAddress = null;
    }

    ContractId(@Nonnegative long shard, @Nonnegative long realm, byte[] evmAddress) {
        this.shard = shard;
        this.realm = realm;
        this.evmAddress = evmAddress;
        this.num = 0L;
        this.checksum = null;
    }

    public static ContractId fromString(String id) {
        Matcher match = EVM_ADDRESS_REGEX.matcher(id);
        if (match.find()) {
            return new ContractId(Long.parseLong(match.group(1)), Long.parseLong(match.group(2)), Hex.decode((String)match.group(3)));
        }
        return EntityIdHelper.fromString(id, ContractId::new);
    }

    public static ContractId fromSolidityAddress(String address) {
        return EntityIdHelper.fromSolidityAddress(address, ContractId::new);
    }

    public static ContractId fromEvmAddress(@Nonnegative long shard, @Nonnegative long realm, String evmAddress) {
        return new ContractId(shard, realm, Hex.decode((String)(evmAddress.startsWith("0x") ? evmAddress.substring(2) : evmAddress)));
    }

    static ContractId fromProtobuf(ContractID contractId) {
        Objects.requireNonNull(contractId);
        if (contractId.hasEvmAddress()) {
            return new ContractId(contractId.getShardNum(), contractId.getRealmNum(), contractId.getEvmAddress().toByteArray());
        }
        return new ContractId(contractId.getShardNum(), contractId.getRealmNum(), contractId.getContractNum());
    }

    public static ContractId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ContractId.fromProtobuf((ContractID)((ContractID.Builder)ContractID.parseFrom(bytes).toBuilder()).build());
    }

    public String toSolidityAddress() {
        if (this.evmAddress != null) {
            return Hex.toHexString((byte[])this.evmAddress);
        }
        return EntityIdHelper.toSolidityAddress(this.shard, this.realm, this.num);
    }

    ContractID toProtobuf() {
        ContractID.Builder builder = ContractID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm);
        if (this.evmAddress != null) {
            builder.setEvmAddress(ByteString.copyFrom((byte[])this.evmAddress));
        } else {
            builder.setContractNum(this.num);
        }
        return (ContractID)builder.build();
    }

    @Deprecated
    public void validate(Client client) throws BadEntityIdException {
        this.validateChecksum(client);
    }

    public void validateChecksum(Client client) throws BadEntityIdException {
        EntityIdHelper.validate(this.shard, this.realm, this.num, client, this.checksum);
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    @Override
    com.hedera.hashgraph.sdk.proto.Key toProtobufKey() {
        return (com.hedera.hashgraph.sdk.proto.Key)com.hedera.hashgraph.sdk.proto.Key.newBuilder().setContractID(this.toProtobuf()).build();
    }

    @Override
    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        if (this.evmAddress != null) {
            return this.shard + "." + this.realm + "." + Hex.toHexString((byte[])this.evmAddress);
        }
        return EntityIdHelper.toString(this.shard, this.realm, this.num);
    }

    public String toStringWithChecksum(Client client) {
        if (this.evmAddress != null) {
            throw new IllegalStateException("toStringWithChecksum cannot be applied to ContractId with evmAddress");
        }
        return EntityIdHelper.toStringWithChecksum(this.shard, this.realm, this.num, client, this.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num, Arrays.hashCode(this.evmAddress));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContractId)) {
            return false;
        }
        ContractId otherId = (ContractId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num && this.evmAddressMatches(otherId);
    }

    private boolean evmAddressMatches(ContractId otherId) {
        if (this.evmAddress == null != (otherId.evmAddress == null)) {
            return false;
        }
        if (this.evmAddress != null) {
            return Arrays.equals(this.evmAddress, otherId.evmAddress);
        }
        return true;
    }

    @Override
    public int compareTo(ContractId o) {
        Objects.requireNonNull(o);
        int shardComparison = Long.compare(this.shard, o.shard);
        if (shardComparison != 0) {
            return shardComparison;
        }
        int realmComparison = Long.compare(this.realm, o.realm);
        if (realmComparison != 0) {
            return realmComparison;
        }
        int numComparison = Long.compare(this.num, o.num);
        if (numComparison != 0) {
            return numComparison;
        }
        return this.evmAddressCompare(o);
    }

    private int evmAddressCompare(ContractId o) {
        int nullCompare = (this.evmAddress == null ? 0 : 1) - (o.evmAddress == null ? 0 : 1);
        if (nullCompare != 0) {
            return nullCompare;
        }
        if (this.evmAddress != null) {
            return Hex.toHexString((byte[])this.evmAddress).compareTo(Hex.toHexString((byte[])o.evmAddress));
        }
        return 0;
    }
}

