/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.CustomFixedFee;
import com.hedera.hashgraph.sdk.CustomFractionalFee;
import com.hedera.hashgraph.sdk.CustomRoyaltyFee;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public abstract class CustomFee {
    @Nullable
    protected AccountId feeCollectorAccountId = null;
    protected boolean allCollectorsAreExempt = false;

    CustomFee() {
    }

    static CustomFee fromProtobufInner(com.hedera.hashgraph.sdk.proto.CustomFee customFee) {
        switch (customFee.getFeeCase()) {
            case FIXED_FEE: {
                return CustomFixedFee.fromProtobuf(customFee.getFixedFee());
            }
            case FRACTIONAL_FEE: {
                return CustomFractionalFee.fromProtobuf(customFee.getFractionalFee());
            }
            case ROYALTY_FEE: {
                return CustomRoyaltyFee.fromProtobuf(customFee.getRoyaltyFee());
            }
        }
        throw new IllegalStateException("CustomFee#fromProtobuf: unhandled fee case: " + customFee.getFeeCase());
    }

    static CustomFee fromProtobuf(com.hedera.hashgraph.sdk.proto.CustomFee customFee) {
        CustomFee outFee = CustomFee.fromProtobufInner(customFee);
        if (customFee.hasFeeCollectorAccountId()) {
            outFee.feeCollectorAccountId = AccountId.fromProtobuf(customFee.getFeeCollectorAccountId());
        }
        return outFee;
    }

    public static CustomFee fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return CustomFee.fromProtobuf((com.hedera.hashgraph.sdk.proto.CustomFee)((CustomFee.Builder)com.hedera.hashgraph.sdk.proto.CustomFee.parseFrom(bytes).toBuilder()).build());
    }

    public static List<CustomFee> deepCloneList(List<CustomFee> customFees) {
        ArrayList<CustomFee> returnCustomFees = new ArrayList<CustomFee>(customFees.size());
        for (CustomFee fee : customFees) {
            returnCustomFees.add(fee.deepClone());
        }
        return returnCustomFees;
    }

    @Nullable
    public AccountId getFeeCollectorAccountId() {
        return this.feeCollectorAccountId;
    }

    private boolean getAllCollectorsAreExempt() {
        return this.allCollectorsAreExempt;
    }

    abstract CustomFee deepClone();

    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.feeCollectorAccountId != null) {
            this.feeCollectorAccountId.validateChecksum(client);
        }
    }

    protected com.hedera.hashgraph.sdk.proto.CustomFee finishToProtobuf(CustomFee.Builder customFeeBuilder) {
        if (this.feeCollectorAccountId != null) {
            customFeeBuilder.setFeeCollectorAccountId(this.feeCollectorAccountId.toProtobuf());
        }
        return (com.hedera.hashgraph.sdk.proto.CustomFee)customFeeBuilder.build();
    }

    abstract com.hedera.hashgraph.sdk.proto.CustomFee toProtobuf();

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    protected MoreObjects.ToStringHelper toStringHelper() {
        return MoreObjects.toStringHelper((Object)this).add("feeCollectorAccountId", (Object)this.feeCollectorAccountId);
    }
}

