/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ConsumerHelper;
import com.hedera.hashgraph.sdk.EthereumTransaction;
import com.hedera.hashgraph.sdk.EthereumTransactionData;
import com.hedera.hashgraph.sdk.FileAppendTransaction;
import com.hedera.hashgraph.sdk.FileCreateTransaction;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.TransactionResponse;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class EthereumFlow {
    static int MAX_ETHEREUM_DATA_SIZE = 5120;
    @Nullable
    private EthereumTransactionData ethereumData;
    @Nullable
    private FileId callDataFileId;
    @Nullable
    private Hbar maxGasAllowance;

    @Nullable
    public EthereumTransactionData getEthereumData() {
        return this.ethereumData;
    }

    public EthereumFlow setEthereumData(byte[] ethereumData) {
        this.ethereumData = EthereumTransactionData.fromBytes(ethereumData);
        return this;
    }

    @Nullable
    public Hbar getMaxGasAllowance() {
        return this.maxGasAllowance;
    }

    public EthereumFlow setMaxGasAllowance(Hbar maxGasAllowance) {
        this.maxGasAllowance = maxGasAllowance;
        return this;
    }

    private static FileId createFile(byte[] callData, Client client, Duration timeoutPerTransaction) throws PrecheckStatusException, TimeoutException {
        try {
            TransactionResponse transaction = (TransactionResponse)new FileCreateTransaction().setContents(Arrays.copyOfRange(callData, 0, Math.min(FileAppendTransaction.DEFAULT_CHUNK_SIZE, callData.length))).execute(client, timeoutPerTransaction);
            FileId fileId = transaction.getReceipt((Client)client, (Duration)timeoutPerTransaction).fileId;
            if (callData.length > FileAppendTransaction.DEFAULT_CHUNK_SIZE) {
                new FileAppendTransaction().setFileId(fileId).setContents(Arrays.copyOfRange(callData, FileAppendTransaction.DEFAULT_CHUNK_SIZE, callData.length)).execute(client, timeoutPerTransaction);
            }
            return fileId;
        }
        catch (ReceiptStatusException e) {
            throw new RuntimeException(e);
        }
    }

    private static CompletableFuture<FileId> createFileAsync(byte[] callData, Client client, Duration timeoutPerTransaction) {
        return ((CompletableFuture)new FileCreateTransaction().setContents(Arrays.copyOfRange(callData, 0, Math.min(FileAppendTransaction.DEFAULT_CHUNK_SIZE, callData.length))).executeAsync(client, timeoutPerTransaction).thenCompose(response -> response.getReceiptAsync(client, timeoutPerTransaction))).thenCompose(receipt -> {
            if (callData.length > FileAppendTransaction.DEFAULT_CHUNK_SIZE) {
                return new FileAppendTransaction().setFileId(receipt.fileId).setContents(Arrays.copyOfRange(callData, FileAppendTransaction.DEFAULT_CHUNK_SIZE, callData.length)).executeAsync(client, timeoutPerTransaction).thenApply(r -> receipt.fileId);
            }
            return CompletableFuture.completedFuture(receipt.fileId);
        });
    }

    public TransactionResponse execute(Client client) throws PrecheckStatusException, TimeoutException {
        return this.execute(client, client.getRequestTimeout());
    }

    public TransactionResponse execute(Client client, Duration timeoutPerTransaction) throws PrecheckStatusException, TimeoutException {
        if (this.ethereumData == null) {
            throw new IllegalStateException("Cannot execute a ethereum flow when ethereum data was not provided");
        }
        EthereumTransaction ethereumTransaction = new EthereumTransaction();
        byte[] ethereumDataBytes = this.ethereumData.toBytes();
        if (this.maxGasAllowance != null) {
            ethereumTransaction.setMaxGasAllowanceHbar(this.maxGasAllowance);
        }
        if (ethereumDataBytes.length <= MAX_ETHEREUM_DATA_SIZE) {
            ethereumTransaction.setEthereumData(ethereumDataBytes);
        } else {
            FileId callDataFileId = EthereumFlow.createFile(this.ethereumData.callData, client, timeoutPerTransaction);
            this.ethereumData.callData = new byte[0];
            ethereumTransaction.setEthereumData(this.ethereumData.toBytes()).setCallDataFileId(callDataFileId);
        }
        return (TransactionResponse)ethereumTransaction.execute(client, timeoutPerTransaction);
    }

    public CompletableFuture<TransactionResponse> executeAsync(Client client) {
        return this.executeAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<TransactionResponse> executeAsync(Client client, Duration timeoutPerTransaction) {
        if (this.ethereumData == null) {
            return CompletableFuture.failedFuture(new IllegalStateException("Cannot execute a ethereum flow when ethereum data was not provided"));
        }
        EthereumTransaction ethereumTransaction = new EthereumTransaction();
        byte[] ethereumDataBytes = this.ethereumData.toBytes();
        if (this.maxGasAllowance != null) {
            ethereumTransaction.setMaxGasAllowanceHbar(this.maxGasAllowance);
        }
        if (ethereumDataBytes.length <= MAX_ETHEREUM_DATA_SIZE) {
            return ethereumTransaction.setEthereumData(ethereumDataBytes).executeAsync(client);
        }
        return EthereumFlow.createFileAsync(this.ethereumData.callData, client, timeoutPerTransaction).thenCompose(callDataFileId -> {
            this.ethereumData.callData = new byte[0];
            return ethereumTransaction.setEthereumData(this.ethereumData.toBytes()).setCallDataFileId((FileId)callDataFileId).executeAsync(client, timeoutPerTransaction);
        });
    }

    public void executeAsync(Client client, BiConsumer<TransactionResponse, Throwable> callback) {
        ConsumerHelper.biConsumer(this.executeAsync(client), callback);
    }

    public void executeAsync(Client client, Duration timeoutPerTransaction, BiConsumer<TransactionResponse, Throwable> callback) {
        ConsumerHelper.biConsumer(this.executeAsync(client, timeoutPerTransaction), callback);
    }

    public void executeAsync(Client client, Consumer<TransactionResponse> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.executeAsync(client), onSuccess, onFailure);
    }

    public void executeAsync(Client client, Duration timeoutPerTransaction, Consumer<TransactionResponse> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.executeAsync(client, timeoutPerTransaction), onSuccess, onFailure);
    }
}

