/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.Joiner;
import com.hedera.hashgraph.sdk.BadMnemonicException;
import com.hedera.hashgraph.sdk.BadMnemonicReason;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.ThreadLocalSecureRandom;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;

public final class Mnemonic {
    @Nullable
    private static SoftReference<List<String>> bip39WordList = null;
    @Nullable
    private static SoftReference<List<String>> legacyWordList = null;
    public final List<CharSequence> words;
    public boolean isLegacy = false;
    @Nullable
    private String asString;

    private Mnemonic(List<? extends CharSequence> words) {
        if (words.size() == 22) {
            this.isLegacy = true;
        }
        this.words = Collections.unmodifiableList(words);
    }

    public static Mnemonic fromWords(List<? extends CharSequence> words) throws BadMnemonicException {
        Mnemonic mnemonic = new Mnemonic(words);
        if (words.size() != 22) {
            mnemonic.validate();
        }
        return mnemonic;
    }

    public static Mnemonic fromString(String mnemonicString) throws BadMnemonicException {
        String toLowerCase = mnemonicString.toLowerCase();
        return Mnemonic.fromWords(Arrays.asList(toLowerCase.split(" ")));
    }

    public static Mnemonic generate24() {
        byte[] entropy = new byte[32];
        ThreadLocalSecureRandom.current().nextBytes(entropy);
        return new Mnemonic(Mnemonic.entropyToWords(entropy));
    }

    public static Mnemonic generate12() {
        byte[] entropy = new byte[16];
        ThreadLocalSecureRandom.current().nextBytes(entropy);
        return new Mnemonic(Mnemonic.entropyToWords(entropy));
    }

    private static List<String> entropyToWords(byte[] entropy) {
        ArrayList<String> words;
        byte[] bytes;
        List<String> wordList;
        if (entropy.length != 16 && entropy.length != 32) {
            throw new IllegalArgumentException("invalid entropy byte length: " + entropy.length);
        }
        if (entropy.length == 16) {
            wordList = Mnemonic.getWordList(false);
            bytes = Arrays.copyOf(entropy, 17);
            bytes[16] = (byte)(Mnemonic.checksum(entropy) & 0xF0);
            words = new ArrayList(12);
        } else {
            wordList = Mnemonic.getWordList(false);
            bytes = Arrays.copyOf(entropy, 33);
            bytes[32] = Mnemonic.checksum(entropy);
            words = new ArrayList<String>(24);
        }
        int scratch = 0;
        int offset = 0;
        for (byte b : bytes) {
            scratch <<= 8;
            scratch |= b & 0xFF;
            if ((offset += 8) < 11) continue;
            int index = scratch >> offset - 11 & 0x7FF;
            offset -= 11;
            words.add(wordList.get(index));
        }
        return words;
    }

    private static byte checksum(byte[] entropy) {
        SHA256Digest digest = new SHA256Digest();
        if (entropy.length == 17 || entropy.length == 16) {
            digest.update(entropy, 0, 16);
        } else {
            digest.update(entropy, 0, 32);
        }
        byte[] checksum = new byte[digest.getDigestSize()];
        digest.doFinal(checksum, 0);
        return checksum[0];
    }

    private static int getWordIndex(CharSequence word, boolean isLegacy) {
        List<String> wordList = Mnemonic.getWordList(isLegacy);
        int found = -1;
        for (int i = 0; i < wordList.size(); ++i) {
            if (!word.toString().equals(wordList.get(i))) continue;
            found = i;
        }
        return found;
    }

    private static List<String> getWordList(boolean isLegacy) {
        if (isLegacy) {
            return Mnemonic.getSpecificWordList(() -> legacyWordList, () -> Mnemonic.readWordList(true), newWordList -> {
                legacyWordList = newWordList;
            });
        }
        return Mnemonic.getSpecificWordList(() -> bip39WordList, () -> Mnemonic.readWordList(false), newWordList -> {
            bip39WordList = newWordList;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> getSpecificWordList(Supplier<SoftReference<List<String>>> getCurrentWordList, Supplier<List<String>> getNewWordList, Consumer<SoftReference<List<String>>> setCurrentWordList) {
        SoftReference<List<String>> localWordList = getCurrentWordList.get();
        if (localWordList != null && localWordList.get() != null) return localWordList.get();
        Class<Mnemonic> clazz = Mnemonic.class;
        synchronized (Mnemonic.class) {
            localWordList = getCurrentWordList.get();
            if (localWordList != null && localWordList.get() != null) return localWordList.get();
            List<String> words = getNewWordList.get();
            setCurrentWordList.accept(new SoftReference<List<String>>(words));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return words;
        }
    }

    private static List<String> readWordList(boolean isLegacy) {
        List<String> list;
        if (isLegacy) {
            Object word2;
            InputStream wordStream = Mnemonic.class.getClassLoader().getResourceAsStream("legacy-english.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(wordStream), StandardCharsets.UTF_8));
            try {
                ArrayList<String> words = new ArrayList<String>(4096);
                word2 = reader.readLine();
                while (word2 != null) {
                    words.add((String)word2);
                    word2 = reader.readLine();
                }
                word2 = Collections.unmodifiableList(words);
            }
            catch (Throwable words) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable word2) {
                        words.addSuppressed(word2);
                    }
                    throw words;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return word2;
        }
        InputStream wordStream = Mnemonic.class.getClassLoader().getResourceAsStream("bip39-english.txt");
        BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(wordStream), StandardCharsets.UTF_8));
        try {
            ArrayList<String> words = new ArrayList<String>(2048);
            String word = reader.readLine();
            while (word != null) {
                words.add(word);
                word = reader.readLine();
            }
            list = Collections.unmodifiableList(words);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        reader.close();
        return list;
    }

    private static int[] convertRadix(int[] nums, int fromRadix, int toRadix, int toLength) {
        BigInteger num = BigInteger.valueOf(0L);
        for (int element : nums) {
            num = num.multiply(BigInteger.valueOf(fromRadix));
            num = num.add(BigInteger.valueOf(element));
        }
        int[] result = new int[toLength];
        for (int i = toLength - 1; i >= 0; --i) {
            BigInteger tem = num.divide(BigInteger.valueOf(toRadix));
            BigInteger rem = num.mod(BigInteger.valueOf(toRadix));
            num = tem;
            result[i] = rem.intValue();
        }
        return result;
    }

    private static int crc8(int[] data) {
        int crc = 255;
        for (int i = 0; i < data.length - 1; ++i) {
            crc ^= data[i];
            for (int j = 0; j < 8; ++j) {
                crc = crc >>> 1 ^ ((crc & 1) == 0 ? 0 : 178);
            }
        }
        return crc ^ 0xFF;
    }

    private static boolean[] bytesToBits(byte[] dat) {
        boolean[] bits = new boolean[dat.length * 8];
        Arrays.fill(bits, Boolean.FALSE);
        for (int i = 0; i < dat.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                bits[i * 8 + j] = (dat[i] & 1 << 7 - j) != 0;
            }
        }
        return bits;
    }

    public PrivateKey toPrivateKey(String passphrase) throws BadMnemonicException {
        if (this.isLegacy) {
            if (passphrase.compareTo("") != 0) {
                throw new Error("Legacy mnemonic doesn't support passphrases");
            }
            return this.toLegacyPrivateKey();
        }
        return PrivateKey.fromMnemonic(this, passphrase);
    }

    public PrivateKey toLegacyPrivateKey() throws BadMnemonicException {
        if (this.words.size() == 22) {
            return PrivateKey.fromBytes(this.wordsToLegacyEntropy());
        }
        return PrivateKey.fromBytes(this.wordsToLegacyEntropy2());
    }

    public PrivateKey toPrivateKey() throws BadMnemonicException {
        return this.toPrivateKey("");
    }

    private void validate() throws BadMnemonicException {
        if (this.words.size() != 24 && this.words.size() != 12) {
            throw new BadMnemonicException(this, BadMnemonicReason.BadLength);
        }
        ArrayList<Integer> unknownIndices = new ArrayList<Integer>();
        for (int i = 0; i < this.words.size(); ++i) {
            if (Mnemonic.getWordIndex(this.words.get(i), false) >= 0) continue;
            unknownIndices.add(i);
        }
        if (!unknownIndices.isEmpty()) {
            throw new BadMnemonicException(this, BadMnemonicReason.UnknownWords, unknownIndices);
        }
        if (this.words.size() != 22) {
            byte givenChecksum;
            byte expectedChecksum;
            byte[] entropyAndChecksum = this.wordsToEntropyAndChecksum();
            if (this.words.size() == 12) {
                expectedChecksum = (byte)(Mnemonic.checksum(entropyAndChecksum) & 0xF0);
                givenChecksum = entropyAndChecksum[16];
            } else {
                expectedChecksum = Mnemonic.checksum(entropyAndChecksum);
                givenChecksum = entropyAndChecksum[32];
            }
            if (givenChecksum != expectedChecksum) {
                throw new BadMnemonicException(this, BadMnemonicReason.ChecksumMismatch);
            }
        }
    }

    public String toString() {
        if (this.asString == null) {
            this.asString = Joiner.on((char)' ').join(this.words);
        }
        return this.asString;
    }

    byte[] toSeed(String passphrase) {
        String salt = "mnemonic" + passphrase;
        PKCS5S2ParametersGenerator pbkdf2 = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
        pbkdf2.init(this.toString().getBytes(StandardCharsets.UTF_8), salt.getBytes(StandardCharsets.UTF_8), 2048);
        KeyParameter key = (KeyParameter)pbkdf2.generateDerivedParameters(512);
        return key.getKey();
    }

    private byte[] wordsToEntropyAndChecksum() {
        if (this.words.size() != 24 && this.words.size() != 12) {
            throw new IllegalStateException("(BUG) expected 24-word mnemonic, got " + this.words.size() + " words");
        }
        ByteBuffer buffer = this.words.size() == 12 ? ByteBuffer.allocate(17) : ByteBuffer.allocate(33);
        int scratch = 0;
        int offset = 0;
        for (CharSequence word : this.words) {
            int index = Mnemonic.getWordIndex(word, this.isLegacy);
            if (index < 0) {
                throw new IllegalStateException("(BUG) word not in word list: " + word);
            }
            if (index > 2047) {
                throw new IndexOutOfBoundsException("(BUG) index out of bounds: " + index);
            }
            scratch <<= 11;
            scratch |= index;
            offset += 11;
            while (offset >= 8) {
                buffer.put((byte)(scratch >> offset - 8));
                offset -= 8;
            }
        }
        if (offset != 0) {
            buffer.put((byte)(scratch << offset));
        }
        return buffer.array();
    }

    private byte[] wordsToLegacyEntropy() throws BadMnemonicException {
        if (!this.isLegacy) {
            throw new BadMnemonicException(this, BadMnemonicReason.NotLegacy);
        }
        int[] indices = new int[this.words.size()];
        for (int i = 0; i < this.words.size(); ++i) {
            indices[i] = Mnemonic.getWordIndex(this.words.get(i), true);
        }
        int[] data = Mnemonic.convertRadix(indices, 4096, 256, 33);
        int crc = data[data.length - 1];
        int[] result = new int[data.length - 1];
        for (int i = 0; i < data.length - 1; ++i) {
            result[i] = data[i] ^ crc;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(result.length * 4);
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        intBuffer.put(result);
        int crc2 = Mnemonic.crc8(result);
        if (crc != crc2) {
            throw new BadMnemonicException(this, BadMnemonicReason.ChecksumMismatch);
        }
        byte[] array = byteBuffer.array();
        int i = 0;
        byte[] array2 = new byte[data.length - 1];
        for (int j = 3; j < array.length; j += 4) {
            array2[i] = array[j];
            ++i;
        }
        return array2;
    }

    private byte[] wordsToLegacyEntropy2() throws BadMnemonicException {
        int concatBitsLen = this.words.size() * 11;
        boolean[] concatBits = new boolean[concatBitsLen];
        Arrays.fill(concatBits, Boolean.FALSE);
        for (int index = 0; index < this.words.size(); ++index) {
            int nds = Collections.binarySearch(Mnemonic.getWordList(false), this.words.get(index), null);
            for (int i = 0; i < 11; ++i) {
                concatBits[index * 11 + i] = (nds & 1 << 10 - i) != 0;
            }
        }
        int checksumBitsLen = concatBitsLen / 33;
        int entropyBitsLen = concatBitsLen - checksumBitsLen;
        byte[] entropy = new byte[entropyBitsLen / 8];
        for (int i = 0; i < entropy.length; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!concatBits[i * 8 + j]) continue;
                int n = i;
                entropy[n] = (byte)(entropy[n] | (byte)(1 << 7 - j));
            }
        }
        SHA256Digest digest = new SHA256Digest();
        byte[] hash = new byte[entropy.length];
        digest.update(entropy, 0, entropy.length);
        digest.doFinal(hash, 0);
        boolean[] hashBits = Mnemonic.bytesToBits(hash);
        for (int i = 0; i < checksumBitsLen; ++i) {
            if (concatBits[entropyBitsLen + i] == hashBits[i]) continue;
            throw new BadMnemonicException(this, BadMnemonicReason.ChecksumMismatch);
        }
        return entropy;
    }
}

