/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.proto.Key;
import com.hedera.hashgraph.sdk.proto.SignaturePair;
import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.math.ec.rfc8032.Ed25519;

class PublicKeyED25519
extends PublicKey {
    private final byte[] keyData;

    PublicKeyED25519(byte[] keyData) {
        this.keyData = keyData;
    }

    static PublicKeyED25519 fromBytesInternal(byte[] publicKey) {
        if (publicKey.length == 32) {
            return new PublicKeyED25519(publicKey);
        }
        return PublicKeyED25519.fromSubjectKeyInfoInternal(SubjectPublicKeyInfo.getInstance((Object)publicKey));
    }

    static PublicKeyED25519 fromSubjectKeyInfoInternal(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        return new PublicKeyED25519(subjectPublicKeyInfo.getPublicKeyData().getBytes());
    }

    @Override
    ByteString extractSignatureFromProtobuf(SignaturePair pair) {
        return pair.getEd25519();
    }

    @Override
    public boolean verify(byte[] message, byte[] signature) {
        return Ed25519.verify((byte[])signature, (int)0, (byte[])this.keyData, (int)0, (byte[])message, (int)0, (int)message.length);
    }

    @Override
    Key toProtobufKey() {
        return (Key)Key.newBuilder().setEd25519(ByteString.copyFrom((byte[])this.keyData)).build();
    }

    @Override
    SignaturePair toSignaturePairProtobuf(byte[] signature) {
        return (SignaturePair)SignaturePair.newBuilder().setPubKeyPrefix(ByteString.copyFrom((byte[])this.keyData)).setEd25519(ByteString.copyFrom((byte[])signature)).build();
    }

    @Override
    public byte[] toBytesDER() {
        try {
            return new SubjectPublicKeyInfo(new AlgorithmIdentifier(ID_ED25519), this.keyData).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] toBytes() {
        return this.toBytesRaw();
    }

    @Override
    public byte[] toBytesRaw() {
        return this.keyData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PublicKeyED25519 publicKey = (PublicKeyED25519)o;
        return Arrays.equals(this.keyData, publicKey.keyData);
    }

    public int hashCode() {
        return Arrays.hashCode(this.keyData);
    }

    @Override
    public boolean isED25519() {
        return true;
    }

    @Override
    public boolean isECDSA() {
        return false;
    }
}

