/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ConsumerHelper;
import com.hedera.hashgraph.sdk.ContractCreateTransaction;
import com.hedera.hashgraph.sdk.ContractFunctionParameters;
import com.hedera.hashgraph.sdk.FileAppendTransaction;
import com.hedera.hashgraph.sdk.FileCreateTransaction;
import com.hedera.hashgraph.sdk.FileDeleteTransaction;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public class ContractCreateFlow {
    static final int FILE_CREATE_MAX_BYTES = 2048;
    private String bytecode = "";
    @Nullable
    private Integer maxChunks = null;
    @Nullable
    private Key adminKey = null;
    private long gas = 0L;
    private Hbar initialBalance = Hbar.ZERO;
    @Nullable
    private AccountId proxyAccountId = null;
    private int maxAutomaticTokenAssociations = 0;
    @Nullable
    private Duration autoRenewPeriod = null;
    @Nullable
    private AccountId autoRenewAccountId = null;
    private byte[] constructorParameters = new byte[0];
    @Nullable
    private String contractMemo = null;
    @Nullable
    private List<AccountId> nodeAccountIds = null;
    private String createBytecode = "";
    private String appendBytecode = "";
    @Nullable
    private AccountId stakedAccountId = null;
    @Nullable
    private Long stakedNodeId = null;
    private boolean declineStakingReward = false;
    @Nullable
    private Client freezeWithClient = null;
    @Nullable
    private PrivateKey signPrivateKey = null;
    @Nullable
    private PublicKey signPublicKey = null;
    @Nullable
    private Function<byte[], byte[]> transactionSigner = null;

    public String getBytecode() {
        return this.bytecode;
    }

    public ContractCreateFlow setBytecode(String bytecode) {
        Objects.requireNonNull(bytecode);
        this.bytecode = bytecode;
        return this;
    }

    public ContractCreateFlow setBytecode(byte[] bytecode) {
        Objects.requireNonNull(bytecode);
        this.bytecode = Hex.toHexString((byte[])bytecode);
        return this;
    }

    public ContractCreateFlow setBytecode(ByteString bytecode) {
        Objects.requireNonNull(bytecode);
        return this.setBytecode(bytecode.toByteArray());
    }

    @Nullable
    public Integer getMaxChunks() {
        return this.maxChunks;
    }

    public ContractCreateFlow setMaxChunks(int maxChunks) {
        this.maxChunks = maxChunks;
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public ContractCreateFlow setAdminKey(Key adminKey) {
        Objects.requireNonNull(adminKey);
        this.adminKey = adminKey;
        return this;
    }

    public long getGas() {
        return this.gas;
    }

    public ContractCreateFlow setGas(long gas) {
        this.gas = gas;
        return this;
    }

    public Hbar getInitialBalance() {
        return this.initialBalance;
    }

    public ContractCreateFlow setInitialBalance(Hbar initialBalance) {
        Objects.requireNonNull(initialBalance);
        this.initialBalance = initialBalance;
        return this;
    }

    @Nullable
    @Deprecated
    public AccountId getProxyAccountId() {
        return this.proxyAccountId;
    }

    @Deprecated
    public ContractCreateFlow setProxyAccountId(AccountId proxyAccountId) {
        Objects.requireNonNull(proxyAccountId);
        this.proxyAccountId = proxyAccountId;
        return this;
    }

    public int getMaxAutomaticTokenAssociations() {
        return this.maxAutomaticTokenAssociations;
    }

    public ContractCreateFlow setMaxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
        this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="A Duration can't actually be mutated")
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="A Duration can't actually be mutated")
    public ContractCreateFlow setAutoRenewPeriod(Duration autoRenewPeriod) {
        Objects.requireNonNull(autoRenewPeriod);
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public ContractCreateFlow setAutoRenewAccountId(AccountId autoRenewAccountId) {
        Objects.requireNonNull(autoRenewAccountId);
        this.autoRenewAccountId = autoRenewAccountId;
        return this;
    }

    public ByteString getConstructorParameters() {
        return ByteString.copyFrom((byte[])this.constructorParameters);
    }

    public ContractCreateFlow setConstructorParameters(byte[] constructorParameters) {
        this.constructorParameters = Arrays.copyOf(constructorParameters, constructorParameters.length);
        return this;
    }

    public ContractCreateFlow setConstructorParameters(ContractFunctionParameters constructorParameters) {
        Objects.requireNonNull(constructorParameters);
        return this.setConstructorParameters(constructorParameters.toBytes(null).toByteArray());
    }

    public String getContractMemo() {
        return this.contractMemo;
    }

    public ContractCreateFlow setContractMemo(String memo) {
        Objects.requireNonNull(memo);
        this.contractMemo = memo;
        return this;
    }

    @Nullable
    public AccountId getStakedAccountId() {
        return this.stakedAccountId;
    }

    public ContractCreateFlow setStakedAccountId(@Nullable AccountId stakedAccountId) {
        this.stakedAccountId = stakedAccountId;
        this.stakedNodeId = null;
        return this;
    }

    @Nullable
    public Long getStakedNodeId() {
        return this.stakedNodeId;
    }

    public ContractCreateFlow setStakedNodeId(@Nullable Long stakedNodeId) {
        this.stakedNodeId = stakedNodeId;
        this.stakedAccountId = null;
        return this;
    }

    public boolean getDeclineStakingReward() {
        return this.declineStakingReward;
    }

    public ContractCreateFlow setDeclineStakingReward(boolean declineStakingReward) {
        this.declineStakingReward = declineStakingReward;
        return this;
    }

    @Nullable
    public List<AccountId> getNodeAccountIds() {
        return this.nodeAccountIds != null ? Collections.unmodifiableList(this.nodeAccountIds) : null;
    }

    public ContractCreateFlow setNodeAccountIds(List<AccountId> nodeAccountIds) {
        Objects.requireNonNull(nodeAccountIds);
        this.nodeAccountIds = new ArrayList<AccountId>(nodeAccountIds);
        return this;
    }

    public ContractCreateFlow freezeWith(Client client) {
        this.freezeWithClient = client;
        return this;
    }

    public ContractCreateFlow sign(PrivateKey privateKey) {
        this.signPrivateKey = privateKey;
        this.signPublicKey = null;
        this.transactionSigner = null;
        return this;
    }

    public ContractCreateFlow signWith(PublicKey publicKey, Function<byte[], byte[]> transactionSigner) {
        this.signPublicKey = publicKey;
        this.transactionSigner = transactionSigner;
        this.signPrivateKey = null;
        return this;
    }

    public ContractCreateFlow signWithOperator(Client client) {
        Client.Operator operator = Objects.requireNonNull(client.getOperator());
        this.signPublicKey = operator.publicKey;
        this.transactionSigner = operator.transactionSigner;
        this.signPrivateKey = null;
        return this;
    }

    private void splitBytecode() {
        if (this.bytecode.length() > 2048) {
            this.createBytecode = this.bytecode.substring(0, 2048);
            this.appendBytecode = this.bytecode.substring(2048);
        } else {
            this.createBytecode = this.bytecode;
            this.appendBytecode = "";
        }
    }

    private FileCreateTransaction createFileCreateTransaction(Client client) {
        FileCreateTransaction fileCreateTx = new FileCreateTransaction().setKeys(Objects.requireNonNull(client.getOperatorPublicKey())).setContents(this.createBytecode);
        if (this.nodeAccountIds != null) {
            fileCreateTx.setNodeAccountIds((List)this.nodeAccountIds);
        }
        return fileCreateTx;
    }

    private FileAppendTransaction createFileAppendTransaction(FileId fileId) {
        FileAppendTransaction fileAppendTx = new FileAppendTransaction().setFileId(fileId).setContents(this.appendBytecode);
        if (this.maxChunks != null) {
            fileAppendTx.setMaxChunks(this.maxChunks);
        }
        if (this.nodeAccountIds != null) {
            fileAppendTx.setNodeAccountIds((List)this.nodeAccountIds);
        }
        return fileAppendTx;
    }

    private ContractCreateTransaction createContractCreateTransaction(FileId fileId) {
        ContractCreateTransaction contractCreateTx = new ContractCreateTransaction().setBytecodeFileId(fileId).setConstructorParameters(this.constructorParameters).setGas(this.gas).setInitialBalance(this.initialBalance).setMaxAutomaticTokenAssociations(this.maxAutomaticTokenAssociations).setDeclineStakingReward(this.declineStakingReward);
        if (this.adminKey != null) {
            contractCreateTx.setAdminKey(this.adminKey);
        }
        if (this.proxyAccountId != null) {
            contractCreateTx.setProxyAccountId(this.proxyAccountId);
        }
        if (this.autoRenewPeriod != null) {
            contractCreateTx.setAutoRenewPeriod(this.autoRenewPeriod);
        }
        if (this.autoRenewAccountId != null) {
            contractCreateTx.setAutoRenewAccountId(this.autoRenewAccountId);
        }
        if (this.contractMemo != null) {
            contractCreateTx.setContractMemo(this.contractMemo);
        }
        if (this.nodeAccountIds != null) {
            contractCreateTx.setNodeAccountIds((List)this.nodeAccountIds);
        }
        if (this.stakedAccountId != null) {
            contractCreateTx.setStakedAccountId(this.stakedAccountId);
        } else if (this.stakedNodeId != null) {
            contractCreateTx.setStakedNodeId(this.stakedNodeId);
        }
        if (this.freezeWithClient != null) {
            contractCreateTx.freezeWith(this.freezeWithClient);
        }
        if (this.signPrivateKey != null) {
            contractCreateTx.sign(this.signPrivateKey);
        } else if (this.signPublicKey != null && this.transactionSigner != null) {
            contractCreateTx.signWith(this.signPublicKey, this.transactionSigner);
        }
        return contractCreateTx;
    }

    TransactionReceiptQuery createTransactionReceiptQuery(TransactionResponse response) {
        return ((TransactionReceiptQuery)new TransactionReceiptQuery().setNodeAccountIds((List)Collections.singletonList(response.nodeId))).setTransactionId(response.transactionId);
    }

    public TransactionResponse execute(Client client) throws PrecheckStatusException, TimeoutException {
        return this.execute(client, client.getRequestTimeout());
    }

    public TransactionResponse execute(Client client, Duration timeoutPerTransaction) throws PrecheckStatusException, TimeoutException {
        try {
            this.splitBytecode();
            FileId fileId = ((TransactionResponse)this.createFileCreateTransaction((Client)client).execute((Client)client, (Duration)timeoutPerTransaction)).getReceipt((Client)client, (Duration)timeoutPerTransaction).fileId;
            Objects.requireNonNull(fileId);
            if (!this.appendBytecode.isEmpty()) {
                this.createFileAppendTransaction(fileId).execute(client, timeoutPerTransaction);
            }
            TransactionResponse response = (TransactionResponse)this.createContractCreateTransaction(fileId).execute(client, timeoutPerTransaction);
            response.getReceipt(client, timeoutPerTransaction);
            new FileDeleteTransaction().setFileId(fileId).execute(client, timeoutPerTransaction);
            return response;
        }
        catch (ReceiptStatusException e) {
            throw new RuntimeException(e);
        }
    }

    public CompletableFuture<TransactionResponse> executeAsync(Client client) {
        return this.executeAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<TransactionResponse> executeAsync(Client client, Duration timeoutPerTransaction) {
        this.splitBytecode();
        return ((CompletableFuture)this.createFileCreateTransaction(client).executeAsync(client, timeoutPerTransaction).thenCompose(fileCreateResponse -> this.createTransactionReceiptQuery((TransactionResponse)fileCreateResponse).executeAsync(client, timeoutPerTransaction).thenApply(receipt -> receipt.fileId))).thenCompose(fileId -> {
            CompletableFuture<Object> appendFuture = this.appendBytecode.isEmpty() ? CompletableFuture.completedFuture(null) : this.createFileAppendTransaction((FileId)fileId).executeAsync(client, timeoutPerTransaction).thenApply(ignored -> null);
            return appendFuture.thenCompose(ignored -> this.createContractCreateTransaction((FileId)fileId).executeAsync(client, timeoutPerTransaction).thenApply(contractCreateResponse -> {
                this.createTransactionReceiptQuery((TransactionResponse)contractCreateResponse).executeAsync(client, timeoutPerTransaction).thenRun(() -> new FileDeleteTransaction().setFileId((FileId)fileId).executeAsync(client, timeoutPerTransaction));
                return contractCreateResponse;
            }));
        });
    }

    public void executeAsync(Client client, BiConsumer<TransactionResponse, Throwable> callback) {
        ConsumerHelper.biConsumer(this.executeAsync(client), callback);
    }

    public void executeAsync(Client client, Duration timeoutPerTransaction, BiConsumer<TransactionResponse, Throwable> callback) {
        ConsumerHelper.biConsumer(this.executeAsync(client, timeoutPerTransaction), callback);
    }

    public void executeAsync(Client client, Consumer<TransactionResponse> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.executeAsync(client), onSuccess, onFailure);
    }

    public void executeAsync(Client client, Duration timeoutPerTransaction, Consumer<TransactionResponse> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.executeAsync(client, timeoutPerTransaction), onSuccess, onFailure);
    }
}

