/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.ContractID;
import com.hedera.hashgraph.sdk.proto.Key;
import java.util.Objects;
import javax.annotation.Nullable;

public final class DelegateContractId
extends ContractId {
    public DelegateContractId(long num) {
        super(num);
    }

    public DelegateContractId(long shard, long realm, long num) {
        super(shard, realm, num);
    }

    DelegateContractId(long shard, long realm, long num, @Nullable String checksum) {
        super(shard, realm, num, checksum);
    }

    public static DelegateContractId fromString(String id) {
        return EntityIdHelper.fromString(id, DelegateContractId::new);
    }

    public static DelegateContractId fromSolidityAddress(String address) {
        return EntityIdHelper.fromSolidityAddress(address, DelegateContractId::new);
    }

    static DelegateContractId fromProtobuf(ContractID contractId) {
        Objects.requireNonNull(contractId);
        return new DelegateContractId(contractId.getShardNum(), contractId.getRealmNum(), contractId.getContractNum());
    }

    public static DelegateContractId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return DelegateContractId.fromProtobuf((ContractID)((ContractID.Builder)ContractID.parseFrom(bytes).toBuilder()).build());
    }

    @Override
    Key toProtobufKey() {
        return (Key)Key.newBuilder().setDelegatableContractId(this.toProtobuf()).build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DelegateContractId) {
            DelegateContractId otherId = (DelegateContractId)o;
            return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
        }
        if (o instanceof ContractId) {
            ContractId otherId = (ContractId)o;
            return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
        }
        return false;
    }
}

