/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.SubType;

public enum FeeDataType {
    DEFAULT(SubType.DEFAULT),
    TOKEN_FUNGIBLE_COMMON(SubType.TOKEN_FUNGIBLE_COMMON),
    TOKEN_NON_FUNGIBLE_UNIQUE(SubType.TOKEN_NON_FUNGIBLE_UNIQUE),
    TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES(SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES),
    TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES(SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES),
    SCHEDULE_CREATE_CONTRACT_CALL(SubType.SCHEDULE_CREATE_CONTRACT_CALL);

    final SubType code;

    private FeeDataType(SubType code) {
        this.code = code;
    }

    static FeeDataType valueOf(SubType code) {
        FeeDataType feeDataType;
        switch (code) {
            case DEFAULT: {
                feeDataType = DEFAULT;
                break;
            }
            case TOKEN_FUNGIBLE_COMMON: {
                feeDataType = TOKEN_FUNGIBLE_COMMON;
                break;
            }
            case TOKEN_NON_FUNGIBLE_UNIQUE: {
                feeDataType = TOKEN_NON_FUNGIBLE_UNIQUE;
                break;
            }
            case TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES: {
                feeDataType = TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES;
                break;
            }
            case TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES: {
                feeDataType = TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES;
                break;
            }
            case SCHEDULE_CREATE_CONTRACT_CALL: {
                feeDataType = SCHEDULE_CREATE_CONTRACT_CALL;
                break;
            }
            default: {
                throw new IllegalStateException("(BUG) unhandled SubType (FeeDataType)");
            }
        }
        return feeDataType;
    }

    public String toString() {
        String string;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DEFAULT: {
                string = "DEFAULT";
                break;
            }
            case TOKEN_FUNGIBLE_COMMON: {
                string = "TOKEN_FUNGIBLE_COMMON";
                break;
            }
            case TOKEN_NON_FUNGIBLE_UNIQUE: {
                string = "TOKEN_NON_FUNGIBLE_UNIQUE";
                break;
            }
            case TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES: {
                string = "TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES";
                break;
            }
            case TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES: {
                string = "TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES";
                break;
            }
            case SCHEDULE_CREATE_CONTRACT_CALL: {
                string = "SCHEDULE_CREATE_CONTRACT_CALL";
            }
        }
        return string;
    }
}

