/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.BaseNetwork;
import com.hedera.hashgraph.sdk.BaseNodeAddress;
import com.hedera.hashgraph.sdk.MirrorNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeoutException;

class MirrorNetwork
extends BaseNetwork<MirrorNetwork, BaseNodeAddress, MirrorNode> {
    private MirrorNetwork(ExecutorService executor, List<String> addresses) {
        super(executor);
        try {
            this.setNetwork(addresses);
        }
        catch (InterruptedException | TimeoutException exception) {
            // empty catch block
        }
    }

    static MirrorNetwork forNetwork(ExecutorService executor, List<String> addresses) {
        return new MirrorNetwork(executor, addresses);
    }

    static MirrorNetwork forMainnet(ExecutorService executor) {
        try {
            return (MirrorNetwork)new MirrorNetwork(executor, List.of("mainnet-public.mirrornode.hedera.com:443")).setTransportSecurity(true);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static MirrorNetwork forTestnet(ExecutorService executor) {
        return new MirrorNetwork(executor, List.of("testnet.mirrornode.hedera.com:443"));
    }

    static MirrorNetwork forPreviewnet(ExecutorService executor) {
        return new MirrorNetwork(executor, List.of("previewnet.mirrornode.hedera.com:443"));
    }

    synchronized MirrorNetwork setNetwork(List<String> network) throws TimeoutException, InterruptedException {
        HashMap<String, BaseNodeAddress> map = new HashMap<String, BaseNodeAddress>(network.size());
        for (String address : network) {
            map.put(address, BaseNodeAddress.fromString(address));
        }
        return (MirrorNetwork)super.setNetwork(map);
    }

    synchronized List<String> getNetwork() {
        ArrayList<String> retval = new ArrayList<String>(this.network.size());
        for (BaseNodeAddress address : this.network.keySet()) {
            retval.add(address.toString());
        }
        return retval;
    }

    @Override
    protected MirrorNode createNodeFromNetworkEntry(Map.Entry<String, BaseNodeAddress> entry) {
        return new MirrorNode(entry.getKey(), this.executor);
    }

    synchronized MirrorNode getNextMirrorNode() throws InterruptedException {
        return (MirrorNode)this.getNumberOfMostHealthyNodes(1).get(0);
    }
}

