/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.BadKeyException;
import com.hedera.hashgraph.sdk.Crypto;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.Provider;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

final class Pem {
    private static final String TYPE_PRIVATE_KEY = "PRIVATE KEY";
    private static final String TYPE_ENCRYPTED_PRIVATE_KEY = "ENCRYPTED PRIVATE KEY";

    private Pem() {
    }

    static void writeEncryptedPrivateKey(PrivateKeyInfo pkInfo, Writer out, String passphrase) throws IOException {
        byte[] salt = Crypto.randomBytes(32);
        KeyParameter derivedKey = Crypto.deriveKeySha256(passphrase, salt, 262144, 16);
        byte[] iv = Crypto.randomBytes(16);
        Cipher cipher = Crypto.initAesCbc128Encrypt(derivedKey, iv);
        byte[] encryptedKey = Crypto.runCipher(cipher, pkInfo.getEncoded());
        PBES2Parameters parameters = new PBES2Parameters(new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, (ASN1Encodable)new PBKDF2Params(salt, 262144, 16, new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA256))), new EncryptionScheme(NISTObjectIdentifiers.id_aes128_CBC, (ASN1Encodable)ASN1Primitive.fromByteArray((byte[])cipher.getParameters().getEncoded())));
        EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)parameters), encryptedKey);
        PemWriter writer = new PemWriter(out);
        writer.writeObject((PemObjectGenerator)new PemObject(TYPE_ENCRYPTED_PRIVATE_KEY, encryptedPrivateKeyInfo.getEncoded()));
        writer.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static PrivateKeyInfo readPrivateKey(Reader input, @Nullable String passphrase) throws IOException {
        try {
            InputDecryptorProvider decryptProvider = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider((Provider)new BouncyCastleProvider()).build(passphrase != null ? passphrase.toCharArray() : "".toCharArray());
            try (PEMParser parser = new PEMParser(input);){
                Object parsedObject = parser.readObject();
                if (parsedObject == null) {
                    throw new BadKeyException("PEM file did not contain a private key");
                }
                if (parsedObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                    PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)parsedObject;
                    PrivateKeyInfo privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(decryptProvider);
                    return privateKeyInfo;
                }
                if (!(parsedObject instanceof PrivateKeyInfo)) throw new BadKeyException("PEM file contained something the SDK didn't know what to do with: " + parsedObject.getClass().getName());
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)parsedObject;
                return privateKeyInfo;
            }
        }
        catch (PKCSException e) {
            if (!e.getMessage().contains("password empty")) throw new RuntimeException(e);
            throw new BadKeyException("PEM file contained an encrypted private key but no passphrase was given");
        }
        catch (OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }
}

