/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.KeyList;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.ScheduleId;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.ScheduleInfo;
import java.time.Instant;
import javax.annotation.Nullable;

public final class ScheduleInfo {
    public final ScheduleId scheduleId;
    public final AccountId creatorAccountId;
    public final AccountId payerAccountId;
    public final KeyList signatories;
    @Nullable
    public final Key adminKey;
    @Nullable
    public final TransactionId scheduledTransactionId;
    public final String memo;
    @Nullable
    public final Instant expirationTime;
    @Nullable
    public final Instant executedAt;
    @Nullable
    public final Instant deletedAt;
    final SchedulableTransactionBody transactionBody;
    @Nullable
    public final LedgerId ledgerId;
    public final boolean waitForExpiry;

    ScheduleInfo(ScheduleId scheduleId, AccountId creatorAccountId, AccountId payerAccountId, SchedulableTransactionBody transactionBody, KeyList signers, @Nullable Key adminKey, @Nullable TransactionId scheduledTransactionId, String memo, @Nullable Instant expirationTime, @Nullable Instant executed, @Nullable Instant deleted, LedgerId ledgerId, boolean waitForExpiry) {
        this.scheduleId = scheduleId;
        this.creatorAccountId = creatorAccountId;
        this.payerAccountId = payerAccountId;
        this.signatories = signers;
        this.adminKey = adminKey;
        this.transactionBody = transactionBody;
        this.scheduledTransactionId = scheduledTransactionId;
        this.memo = memo;
        this.expirationTime = expirationTime;
        this.executedAt = executed;
        this.deletedAt = deleted;
        this.ledgerId = ledgerId;
        this.waitForExpiry = waitForExpiry;
    }

    static ScheduleInfo fromProtobuf(com.hedera.hashgraph.sdk.proto.ScheduleInfo info) {
        ScheduleId scheduleId = ScheduleId.fromProtobuf(info.getScheduleID());
        AccountId creatorAccountId = AccountId.fromProtobuf(info.getCreatorAccountID());
        AccountId payerAccountId = AccountId.fromProtobuf(info.getPayerAccountID());
        Key adminKey = info.hasAdminKey() ? Key.fromProtobufKey(info.getAdminKey()) : null;
        TransactionId scheduledTransactionId = info.hasScheduledTransactionID() ? TransactionId.fromProtobuf(info.getScheduledTransactionID()) : null;
        return new ScheduleInfo(scheduleId, creatorAccountId, payerAccountId, info.getScheduledTransactionBody(), KeyList.fromProtobuf(info.getSigners(), null), adminKey, scheduledTransactionId, info.getMemo(), info.hasExpirationTime() ? InstantConverter.fromProtobuf(info.getExpirationTime()) : null, info.hasExecutionTime() ? InstantConverter.fromProtobuf(info.getExecutionTime()) : null, info.hasDeletionTime() ? InstantConverter.fromProtobuf(info.getDeletionTime()) : null, LedgerId.fromByteString(info.getLedgerId()), info.getWaitForExpiry());
    }

    public static ScheduleInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ScheduleInfo.fromProtobuf((com.hedera.hashgraph.sdk.proto.ScheduleInfo)((ScheduleInfo.Builder)com.hedera.hashgraph.sdk.proto.ScheduleInfo.parseFrom(bytes).toBuilder()).build());
    }

    com.hedera.hashgraph.sdk.proto.ScheduleInfo toProtobuf() {
        ScheduleInfo.Builder info = com.hedera.hashgraph.sdk.proto.ScheduleInfo.newBuilder();
        if (this.adminKey != null) {
            info.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.scheduledTransactionId != null) {
            info.setScheduledTransactionID(this.scheduledTransactionId.toProtobuf());
        }
        if (this.expirationTime != null) {
            info.setExpirationTime(InstantConverter.toProtobuf(this.expirationTime));
        }
        if (this.executedAt != null) {
            info.setExecutionTime(InstantConverter.toProtobuf(this.executedAt));
        }
        if (this.deletedAt != null) {
            info.setDeletionTime(InstantConverter.toProtobuf(this.deletedAt));
        }
        return (com.hedera.hashgraph.sdk.proto.ScheduleInfo)info.setScheduleID(this.scheduleId.toProtobuf()).setCreatorAccountID(this.creatorAccountId.toProtobuf()).setScheduledTransactionBody(this.transactionBody).setPayerAccountID(this.payerAccountId.toProtobuf()).setSigners(this.signatories.toProtobuf()).setMemo(this.memo).setLedgerId(this.ledgerId.toByteString()).setWaitForExpiry(this.waitForExpiry).build();
    }

    public Transaction<?> getScheduledTransaction() {
        return Transaction.fromScheduledTransaction(this.transactionBody);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scheduleId", (Object)this.scheduleId).add("scheduledTransactionId", (Object)this.scheduledTransactionId).add("creatorAccountId", (Object)this.creatorAccountId).add("payerAccountId", (Object)this.payerAccountId).add("signatories", (Object)this.signatories).add("adminKey", (Object)this.adminKey).add("expirationTime", (Object)this.expirationTime).add("memo", (Object)this.memo).add("executedAt", (Object)this.executedAt).add("deletedAt", (Object)this.deletedAt).add("ledgerId", (Object)this.ledgerId).add("waitForExpiry", this.waitForExpiry).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

