/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.ResponseCodeEnum;
import java.util.Objects;

public enum Status {
    OK(ResponseCodeEnum.OK),
    INVALID_TRANSACTION(ResponseCodeEnum.INVALID_TRANSACTION),
    PAYER_ACCOUNT_NOT_FOUND(ResponseCodeEnum.PAYER_ACCOUNT_NOT_FOUND),
    INVALID_NODE_ACCOUNT(ResponseCodeEnum.INVALID_NODE_ACCOUNT),
    TRANSACTION_EXPIRED(ResponseCodeEnum.TRANSACTION_EXPIRED),
    INVALID_TRANSACTION_START(ResponseCodeEnum.INVALID_TRANSACTION_START),
    INVALID_TRANSACTION_DURATION(ResponseCodeEnum.INVALID_TRANSACTION_DURATION),
    INVALID_SIGNATURE(ResponseCodeEnum.INVALID_SIGNATURE),
    MEMO_TOO_LONG(ResponseCodeEnum.MEMO_TOO_LONG),
    INSUFFICIENT_TX_FEE(ResponseCodeEnum.INSUFFICIENT_TX_FEE),
    INSUFFICIENT_PAYER_BALANCE(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE),
    DUPLICATE_TRANSACTION(ResponseCodeEnum.DUPLICATE_TRANSACTION),
    BUSY(ResponseCodeEnum.BUSY),
    NOT_SUPPORTED(ResponseCodeEnum.NOT_SUPPORTED),
    INVALID_FILE_ID(ResponseCodeEnum.INVALID_FILE_ID),
    INVALID_ACCOUNT_ID(ResponseCodeEnum.INVALID_ACCOUNT_ID),
    INVALID_CONTRACT_ID(ResponseCodeEnum.INVALID_CONTRACT_ID),
    INVALID_TRANSACTION_ID(ResponseCodeEnum.INVALID_TRANSACTION_ID),
    RECEIPT_NOT_FOUND(ResponseCodeEnum.RECEIPT_NOT_FOUND),
    RECORD_NOT_FOUND(ResponseCodeEnum.RECORD_NOT_FOUND),
    INVALID_SOLIDITY_ID(ResponseCodeEnum.INVALID_SOLIDITY_ID),
    UNKNOWN(ResponseCodeEnum.UNKNOWN),
    SUCCESS(ResponseCodeEnum.SUCCESS),
    FAIL_INVALID(ResponseCodeEnum.FAIL_INVALID),
    FAIL_FEE(ResponseCodeEnum.FAIL_FEE),
    FAIL_BALANCE(ResponseCodeEnum.FAIL_BALANCE),
    KEY_REQUIRED(ResponseCodeEnum.KEY_REQUIRED),
    BAD_ENCODING(ResponseCodeEnum.BAD_ENCODING),
    INSUFFICIENT_ACCOUNT_BALANCE(ResponseCodeEnum.INSUFFICIENT_ACCOUNT_BALANCE),
    INVALID_SOLIDITY_ADDRESS(ResponseCodeEnum.INVALID_SOLIDITY_ADDRESS),
    INSUFFICIENT_GAS(ResponseCodeEnum.INSUFFICIENT_GAS),
    CONTRACT_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.CONTRACT_SIZE_LIMIT_EXCEEDED),
    LOCAL_CALL_MODIFICATION_EXCEPTION(ResponseCodeEnum.LOCAL_CALL_MODIFICATION_EXCEPTION),
    CONTRACT_REVERT_EXECUTED(ResponseCodeEnum.CONTRACT_REVERT_EXECUTED),
    CONTRACT_EXECUTION_EXCEPTION(ResponseCodeEnum.CONTRACT_EXECUTION_EXCEPTION),
    INVALID_RECEIVING_NODE_ACCOUNT(ResponseCodeEnum.INVALID_RECEIVING_NODE_ACCOUNT),
    MISSING_QUERY_HEADER(ResponseCodeEnum.MISSING_QUERY_HEADER),
    ACCOUNT_UPDATE_FAILED(ResponseCodeEnum.ACCOUNT_UPDATE_FAILED),
    INVALID_KEY_ENCODING(ResponseCodeEnum.INVALID_KEY_ENCODING),
    NULL_SOLIDITY_ADDRESS(ResponseCodeEnum.NULL_SOLIDITY_ADDRESS),
    CONTRACT_UPDATE_FAILED(ResponseCodeEnum.CONTRACT_UPDATE_FAILED),
    INVALID_QUERY_HEADER(ResponseCodeEnum.INVALID_QUERY_HEADER),
    INVALID_FEE_SUBMITTED(ResponseCodeEnum.INVALID_FEE_SUBMITTED),
    INVALID_PAYER_SIGNATURE(ResponseCodeEnum.INVALID_PAYER_SIGNATURE),
    KEY_NOT_PROVIDED(ResponseCodeEnum.KEY_NOT_PROVIDED),
    INVALID_EXPIRATION_TIME(ResponseCodeEnum.INVALID_EXPIRATION_TIME),
    NO_WACL_KEY(ResponseCodeEnum.NO_WACL_KEY),
    FILE_CONTENT_EMPTY(ResponseCodeEnum.FILE_CONTENT_EMPTY),
    INVALID_ACCOUNT_AMOUNTS(ResponseCodeEnum.INVALID_ACCOUNT_AMOUNTS),
    EMPTY_TRANSACTION_BODY(ResponseCodeEnum.EMPTY_TRANSACTION_BODY),
    INVALID_TRANSACTION_BODY(ResponseCodeEnum.INVALID_TRANSACTION_BODY),
    INVALID_SIGNATURE_TYPE_MISMATCHING_KEY(ResponseCodeEnum.INVALID_SIGNATURE_TYPE_MISMATCHING_KEY),
    INVALID_SIGNATURE_COUNT_MISMATCHING_KEY(ResponseCodeEnum.INVALID_SIGNATURE_COUNT_MISMATCHING_KEY),
    EMPTY_LIVE_HASH_BODY(ResponseCodeEnum.EMPTY_LIVE_HASH_BODY),
    EMPTY_LIVE_HASH(ResponseCodeEnum.EMPTY_LIVE_HASH),
    EMPTY_LIVE_HASH_KEYS(ResponseCodeEnum.EMPTY_LIVE_HASH_KEYS),
    INVALID_LIVE_HASH_SIZE(ResponseCodeEnum.INVALID_LIVE_HASH_SIZE),
    EMPTY_QUERY_BODY(ResponseCodeEnum.EMPTY_QUERY_BODY),
    EMPTY_LIVE_HASH_QUERY(ResponseCodeEnum.EMPTY_LIVE_HASH_QUERY),
    LIVE_HASH_NOT_FOUND(ResponseCodeEnum.LIVE_HASH_NOT_FOUND),
    ACCOUNT_ID_DOES_NOT_EXIST(ResponseCodeEnum.ACCOUNT_ID_DOES_NOT_EXIST),
    LIVE_HASH_ALREADY_EXISTS(ResponseCodeEnum.LIVE_HASH_ALREADY_EXISTS),
    INVALID_FILE_WACL(ResponseCodeEnum.INVALID_FILE_WACL),
    SERIALIZATION_FAILED(ResponseCodeEnum.SERIALIZATION_FAILED),
    TRANSACTION_OVERSIZE(ResponseCodeEnum.TRANSACTION_OVERSIZE),
    TRANSACTION_TOO_MANY_LAYERS(ResponseCodeEnum.TRANSACTION_TOO_MANY_LAYERS),
    CONTRACT_DELETED(ResponseCodeEnum.CONTRACT_DELETED),
    PLATFORM_NOT_ACTIVE(ResponseCodeEnum.PLATFORM_NOT_ACTIVE),
    KEY_PREFIX_MISMATCH(ResponseCodeEnum.KEY_PREFIX_MISMATCH),
    PLATFORM_TRANSACTION_NOT_CREATED(ResponseCodeEnum.PLATFORM_TRANSACTION_NOT_CREATED),
    INVALID_RENEWAL_PERIOD(ResponseCodeEnum.INVALID_RENEWAL_PERIOD),
    INVALID_PAYER_ACCOUNT_ID(ResponseCodeEnum.INVALID_PAYER_ACCOUNT_ID),
    ACCOUNT_DELETED(ResponseCodeEnum.ACCOUNT_DELETED),
    FILE_DELETED(ResponseCodeEnum.FILE_DELETED),
    ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS(ResponseCodeEnum.ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS),
    SETTING_NEGATIVE_ACCOUNT_BALANCE(ResponseCodeEnum.SETTING_NEGATIVE_ACCOUNT_BALANCE),
    OBTAINER_REQUIRED(ResponseCodeEnum.OBTAINER_REQUIRED),
    OBTAINER_SAME_CONTRACT_ID(ResponseCodeEnum.OBTAINER_SAME_CONTRACT_ID),
    OBTAINER_DOES_NOT_EXIST(ResponseCodeEnum.OBTAINER_DOES_NOT_EXIST),
    MODIFYING_IMMUTABLE_CONTRACT(ResponseCodeEnum.MODIFYING_IMMUTABLE_CONTRACT),
    FILE_SYSTEM_EXCEPTION(ResponseCodeEnum.FILE_SYSTEM_EXCEPTION),
    AUTORENEW_DURATION_NOT_IN_RANGE(ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE),
    ERROR_DECODING_BYTESTRING(ResponseCodeEnum.ERROR_DECODING_BYTESTRING),
    CONTRACT_FILE_EMPTY(ResponseCodeEnum.CONTRACT_FILE_EMPTY),
    CONTRACT_BYTECODE_EMPTY(ResponseCodeEnum.CONTRACT_BYTECODE_EMPTY),
    INVALID_INITIAL_BALANCE(ResponseCodeEnum.INVALID_INITIAL_BALANCE),
    INVALID_RECEIVE_RECORD_THRESHOLD(ResponseCodeEnum.INVALID_RECEIVE_RECORD_THRESHOLD),
    INVALID_SEND_RECORD_THRESHOLD(ResponseCodeEnum.INVALID_SEND_RECORD_THRESHOLD),
    ACCOUNT_IS_NOT_GENESIS_ACCOUNT(ResponseCodeEnum.ACCOUNT_IS_NOT_GENESIS_ACCOUNT),
    PAYER_ACCOUNT_UNAUTHORIZED(ResponseCodeEnum.PAYER_ACCOUNT_UNAUTHORIZED),
    INVALID_FREEZE_TRANSACTION_BODY(ResponseCodeEnum.INVALID_FREEZE_TRANSACTION_BODY),
    FREEZE_TRANSACTION_BODY_NOT_FOUND(ResponseCodeEnum.FREEZE_TRANSACTION_BODY_NOT_FOUND),
    TRANSFER_LIST_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.TRANSFER_LIST_SIZE_LIMIT_EXCEEDED),
    RESULT_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.RESULT_SIZE_LIMIT_EXCEEDED),
    NOT_SPECIAL_ACCOUNT(ResponseCodeEnum.NOT_SPECIAL_ACCOUNT),
    CONTRACT_NEGATIVE_GAS(ResponseCodeEnum.CONTRACT_NEGATIVE_GAS),
    CONTRACT_NEGATIVE_VALUE(ResponseCodeEnum.CONTRACT_NEGATIVE_VALUE),
    INVALID_FEE_FILE(ResponseCodeEnum.INVALID_FEE_FILE),
    INVALID_EXCHANGE_RATE_FILE(ResponseCodeEnum.INVALID_EXCHANGE_RATE_FILE),
    INSUFFICIENT_LOCAL_CALL_GAS(ResponseCodeEnum.INSUFFICIENT_LOCAL_CALL_GAS),
    ENTITY_NOT_ALLOWED_TO_DELETE(ResponseCodeEnum.ENTITY_NOT_ALLOWED_TO_DELETE),
    AUTHORIZATION_FAILED(ResponseCodeEnum.AUTHORIZATION_FAILED),
    FILE_UPLOADED_PROTO_INVALID(ResponseCodeEnum.FILE_UPLOADED_PROTO_INVALID),
    FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK(ResponseCodeEnum.FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK),
    FEE_SCHEDULE_FILE_PART_UPLOADED(ResponseCodeEnum.FEE_SCHEDULE_FILE_PART_UPLOADED),
    EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED(ResponseCodeEnum.EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED),
    MAX_CONTRACT_STORAGE_EXCEEDED(ResponseCodeEnum.MAX_CONTRACT_STORAGE_EXCEEDED),
    TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT(ResponseCodeEnum.TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT),
    TOTAL_LEDGER_BALANCE_INVALID(ResponseCodeEnum.TOTAL_LEDGER_BALANCE_INVALID),
    EXPIRATION_REDUCTION_NOT_ALLOWED(ResponseCodeEnum.EXPIRATION_REDUCTION_NOT_ALLOWED),
    MAX_GAS_LIMIT_EXCEEDED(ResponseCodeEnum.MAX_GAS_LIMIT_EXCEEDED),
    MAX_FILE_SIZE_EXCEEDED(ResponseCodeEnum.MAX_FILE_SIZE_EXCEEDED),
    RECEIVER_SIG_REQUIRED(ResponseCodeEnum.RECEIVER_SIG_REQUIRED),
    INVALID_TOPIC_ID(ResponseCodeEnum.INVALID_TOPIC_ID),
    INVALID_ADMIN_KEY(ResponseCodeEnum.INVALID_ADMIN_KEY),
    INVALID_SUBMIT_KEY(ResponseCodeEnum.INVALID_SUBMIT_KEY),
    UNAUTHORIZED(ResponseCodeEnum.UNAUTHORIZED),
    INVALID_TOPIC_MESSAGE(ResponseCodeEnum.INVALID_TOPIC_MESSAGE),
    INVALID_AUTORENEW_ACCOUNT(ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT),
    AUTORENEW_ACCOUNT_NOT_ALLOWED(ResponseCodeEnum.AUTORENEW_ACCOUNT_NOT_ALLOWED),
    TOPIC_EXPIRED(ResponseCodeEnum.TOPIC_EXPIRED),
    INVALID_CHUNK_NUMBER(ResponseCodeEnum.INVALID_CHUNK_NUMBER),
    INVALID_CHUNK_TRANSACTION_ID(ResponseCodeEnum.INVALID_CHUNK_TRANSACTION_ID),
    ACCOUNT_FROZEN_FOR_TOKEN(ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN),
    TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED(ResponseCodeEnum.TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED),
    INVALID_TOKEN_ID(ResponseCodeEnum.INVALID_TOKEN_ID),
    INVALID_TOKEN_DECIMALS(ResponseCodeEnum.INVALID_TOKEN_DECIMALS),
    INVALID_TOKEN_INITIAL_SUPPLY(ResponseCodeEnum.INVALID_TOKEN_INITIAL_SUPPLY),
    INVALID_TREASURY_ACCOUNT_FOR_TOKEN(ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN),
    INVALID_TOKEN_SYMBOL(ResponseCodeEnum.INVALID_TOKEN_SYMBOL),
    TOKEN_HAS_NO_FREEZE_KEY(ResponseCodeEnum.TOKEN_HAS_NO_FREEZE_KEY),
    TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN(ResponseCodeEnum.TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN),
    MISSING_TOKEN_SYMBOL(ResponseCodeEnum.MISSING_TOKEN_SYMBOL),
    TOKEN_SYMBOL_TOO_LONG(ResponseCodeEnum.TOKEN_SYMBOL_TOO_LONG),
    ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN(ResponseCodeEnum.ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN),
    TOKEN_HAS_NO_KYC_KEY(ResponseCodeEnum.TOKEN_HAS_NO_KYC_KEY),
    INSUFFICIENT_TOKEN_BALANCE(ResponseCodeEnum.INSUFFICIENT_TOKEN_BALANCE),
    TOKEN_WAS_DELETED(ResponseCodeEnum.TOKEN_WAS_DELETED),
    TOKEN_HAS_NO_SUPPLY_KEY(ResponseCodeEnum.TOKEN_HAS_NO_SUPPLY_KEY),
    TOKEN_HAS_NO_WIPE_KEY(ResponseCodeEnum.TOKEN_HAS_NO_WIPE_KEY),
    INVALID_TOKEN_MINT_AMOUNT(ResponseCodeEnum.INVALID_TOKEN_MINT_AMOUNT),
    INVALID_TOKEN_BURN_AMOUNT(ResponseCodeEnum.INVALID_TOKEN_BURN_AMOUNT),
    TOKEN_NOT_ASSOCIATED_TO_ACCOUNT(ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_ACCOUNT),
    CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT(ResponseCodeEnum.CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT),
    INVALID_KYC_KEY(ResponseCodeEnum.INVALID_KYC_KEY),
    INVALID_WIPE_KEY(ResponseCodeEnum.INVALID_WIPE_KEY),
    INVALID_FREEZE_KEY(ResponseCodeEnum.INVALID_FREEZE_KEY),
    INVALID_SUPPLY_KEY(ResponseCodeEnum.INVALID_SUPPLY_KEY),
    MISSING_TOKEN_NAME(ResponseCodeEnum.MISSING_TOKEN_NAME),
    TOKEN_NAME_TOO_LONG(ResponseCodeEnum.TOKEN_NAME_TOO_LONG),
    INVALID_WIPING_AMOUNT(ResponseCodeEnum.INVALID_WIPING_AMOUNT),
    TOKEN_IS_IMMUTABLE(ResponseCodeEnum.TOKEN_IS_IMMUTABLE),
    TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT(ResponseCodeEnum.TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT),
    TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES(ResponseCodeEnum.TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES),
    ACCOUNT_IS_TREASURY(ResponseCodeEnum.ACCOUNT_IS_TREASURY),
    TOKEN_ID_REPEATED_IN_TOKEN_LIST(ResponseCodeEnum.TOKEN_ID_REPEATED_IN_TOKEN_LIST),
    TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED),
    EMPTY_TOKEN_TRANSFER_BODY(ResponseCodeEnum.EMPTY_TOKEN_TRANSFER_BODY),
    EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS(ResponseCodeEnum.EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS),
    INVALID_SCHEDULE_ID(ResponseCodeEnum.INVALID_SCHEDULE_ID),
    SCHEDULE_IS_IMMUTABLE(ResponseCodeEnum.SCHEDULE_IS_IMMUTABLE),
    INVALID_SCHEDULE_PAYER_ID(ResponseCodeEnum.INVALID_SCHEDULE_PAYER_ID),
    INVALID_SCHEDULE_ACCOUNT_ID(ResponseCodeEnum.INVALID_SCHEDULE_ACCOUNT_ID),
    NO_NEW_VALID_SIGNATURES(ResponseCodeEnum.NO_NEW_VALID_SIGNATURES),
    UNRESOLVABLE_REQUIRED_SIGNERS(ResponseCodeEnum.UNRESOLVABLE_REQUIRED_SIGNERS),
    SCHEDULED_TRANSACTION_NOT_IN_WHITELIST(ResponseCodeEnum.SCHEDULED_TRANSACTION_NOT_IN_WHITELIST),
    SOME_SIGNATURES_WERE_INVALID(ResponseCodeEnum.SOME_SIGNATURES_WERE_INVALID),
    TRANSACTION_ID_FIELD_NOT_ALLOWED(ResponseCodeEnum.TRANSACTION_ID_FIELD_NOT_ALLOWED),
    IDENTICAL_SCHEDULE_ALREADY_CREATED(ResponseCodeEnum.IDENTICAL_SCHEDULE_ALREADY_CREATED),
    INVALID_ZERO_BYTE_IN_STRING(ResponseCodeEnum.INVALID_ZERO_BYTE_IN_STRING),
    SCHEDULE_ALREADY_DELETED(ResponseCodeEnum.SCHEDULE_ALREADY_DELETED),
    SCHEDULE_ALREADY_EXECUTED(ResponseCodeEnum.SCHEDULE_ALREADY_EXECUTED),
    MESSAGE_SIZE_TOO_LARGE(ResponseCodeEnum.MESSAGE_SIZE_TOO_LARGE),
    OPERATION_REPEATED_IN_BUCKET_GROUPS(ResponseCodeEnum.OPERATION_REPEATED_IN_BUCKET_GROUPS),
    BUCKET_CAPACITY_OVERFLOW(ResponseCodeEnum.BUCKET_CAPACITY_OVERFLOW),
    NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION(ResponseCodeEnum.NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION),
    BUCKET_HAS_NO_THROTTLE_GROUPS(ResponseCodeEnum.BUCKET_HAS_NO_THROTTLE_GROUPS),
    THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC(ResponseCodeEnum.THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC),
    SUCCESS_BUT_MISSING_EXPECTED_OPERATION(ResponseCodeEnum.SUCCESS_BUT_MISSING_EXPECTED_OPERATION),
    UNPARSEABLE_THROTTLE_DEFINITIONS(ResponseCodeEnum.UNPARSEABLE_THROTTLE_DEFINITIONS),
    INVALID_THROTTLE_DEFINITIONS(ResponseCodeEnum.INVALID_THROTTLE_DEFINITIONS),
    ACCOUNT_EXPIRED_AND_PENDING_REMOVAL(ResponseCodeEnum.ACCOUNT_EXPIRED_AND_PENDING_REMOVAL),
    INVALID_TOKEN_MAX_SUPPLY(ResponseCodeEnum.INVALID_TOKEN_MAX_SUPPLY),
    INVALID_TOKEN_NFT_SERIAL_NUMBER(ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER),
    INVALID_NFT_ID(ResponseCodeEnum.INVALID_NFT_ID),
    METADATA_TOO_LONG(ResponseCodeEnum.METADATA_TOO_LONG),
    BATCH_SIZE_LIMIT_EXCEEDED(ResponseCodeEnum.BATCH_SIZE_LIMIT_EXCEEDED),
    INVALID_QUERY_RANGE(ResponseCodeEnum.INVALID_QUERY_RANGE),
    FRACTION_DIVIDES_BY_ZERO(ResponseCodeEnum.FRACTION_DIVIDES_BY_ZERO),
    INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE(ResponseCodeEnum.INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE),
    CUSTOM_FEES_LIST_TOO_LONG(ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG),
    INVALID_CUSTOM_FEE_COLLECTOR(ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR),
    INVALID_TOKEN_ID_IN_CUSTOM_FEES(ResponseCodeEnum.INVALID_TOKEN_ID_IN_CUSTOM_FEES),
    TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR(ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR),
    TOKEN_MAX_SUPPLY_REACHED(ResponseCodeEnum.TOKEN_MAX_SUPPLY_REACHED),
    SENDER_DOES_NOT_OWN_NFT_SERIAL_NO(ResponseCodeEnum.SENDER_DOES_NOT_OWN_NFT_SERIAL_NO),
    CUSTOM_FEE_NOT_FULLY_SPECIFIED(ResponseCodeEnum.CUSTOM_FEE_NOT_FULLY_SPECIFIED),
    CUSTOM_FEE_MUST_BE_POSITIVE(ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE),
    TOKEN_HAS_NO_FEE_SCHEDULE_KEY(ResponseCodeEnum.TOKEN_HAS_NO_FEE_SCHEDULE_KEY),
    CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE(ResponseCodeEnum.CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE),
    ROYALTY_FRACTION_CANNOT_EXCEED_ONE(ResponseCodeEnum.ROYALTY_FRACTION_CANNOT_EXCEED_ONE),
    FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT(ResponseCodeEnum.FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT),
    CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES(ResponseCodeEnum.CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES),
    CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON(ResponseCodeEnum.CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON),
    CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON(ResponseCodeEnum.CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON),
    INVALID_CUSTOM_FEE_SCHEDULE_KEY(ResponseCodeEnum.INVALID_CUSTOM_FEE_SCHEDULE_KEY),
    INVALID_TOKEN_MINT_METADATA(ResponseCodeEnum.INVALID_TOKEN_MINT_METADATA),
    INVALID_TOKEN_BURN_METADATA(ResponseCodeEnum.INVALID_TOKEN_BURN_METADATA),
    CURRENT_TREASURY_STILL_OWNS_NFTS(ResponseCodeEnum.CURRENT_TREASURY_STILL_OWNS_NFTS),
    ACCOUNT_STILL_OWNS_NFTS(ResponseCodeEnum.ACCOUNT_STILL_OWNS_NFTS),
    TREASURY_MUST_OWN_BURNED_NFT(ResponseCodeEnum.TREASURY_MUST_OWN_BURNED_NFT),
    ACCOUNT_DOES_NOT_OWN_WIPED_NFT(ResponseCodeEnum.ACCOUNT_DOES_NOT_OWN_WIPED_NFT),
    ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON(ResponseCodeEnum.ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON),
    MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED(ResponseCodeEnum.MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED),
    PAYER_ACCOUNT_DELETED(ResponseCodeEnum.PAYER_ACCOUNT_DELETED),
    CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH(ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH),
    CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS(ResponseCodeEnum.CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS),
    INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE(ResponseCodeEnum.INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE),
    SERIAL_NUMBER_LIMIT_REACHED(ResponseCodeEnum.SERIAL_NUMBER_LIMIT_REACHED),
    CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE(ResponseCodeEnum.CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE),
    NO_REMAINING_AUTOMATIC_ASSOCIATIONS(ResponseCodeEnum.NO_REMAINING_AUTOMATIC_ASSOCIATIONS),
    EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT(ResponseCodeEnum.EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT),
    REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT(ResponseCodeEnum.REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT),
    TOKEN_IS_PAUSED(ResponseCodeEnum.TOKEN_IS_PAUSED),
    TOKEN_HAS_NO_PAUSE_KEY(ResponseCodeEnum.TOKEN_HAS_NO_PAUSE_KEY),
    INVALID_PAUSE_KEY(ResponseCodeEnum.INVALID_PAUSE_KEY),
    FREEZE_UPDATE_FILE_DOES_NOT_EXIST(ResponseCodeEnum.FREEZE_UPDATE_FILE_DOES_NOT_EXIST),
    FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH(ResponseCodeEnum.FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH),
    NO_UPGRADE_HAS_BEEN_PREPARED(ResponseCodeEnum.NO_UPGRADE_HAS_BEEN_PREPARED),
    NO_FREEZE_IS_SCHEDULED(ResponseCodeEnum.NO_FREEZE_IS_SCHEDULED),
    UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE(ResponseCodeEnum.UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE),
    FREEZE_START_TIME_MUST_BE_FUTURE(ResponseCodeEnum.FREEZE_START_TIME_MUST_BE_FUTURE),
    PREPARED_UPDATE_FILE_IS_IMMUTABLE(ResponseCodeEnum.PREPARED_UPDATE_FILE_IS_IMMUTABLE),
    FREEZE_ALREADY_SCHEDULED(ResponseCodeEnum.FREEZE_ALREADY_SCHEDULED),
    FREEZE_UPGRADE_IN_PROGRESS(ResponseCodeEnum.FREEZE_UPGRADE_IN_PROGRESS),
    UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED(ResponseCodeEnum.UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED),
    UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED(ResponseCodeEnum.UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED),
    CONSENSUS_GAS_EXHAUSTED(ResponseCodeEnum.CONSENSUS_GAS_EXHAUSTED),
    REVERTED_SUCCESS(ResponseCodeEnum.REVERTED_SUCCESS),
    MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED(ResponseCodeEnum.MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED),
    INVALID_ALIAS_KEY(ResponseCodeEnum.INVALID_ALIAS_KEY),
    UNEXPECTED_TOKEN_DECIMALS(ResponseCodeEnum.UNEXPECTED_TOKEN_DECIMALS),
    INVALID_PROXY_ACCOUNT_ID(ResponseCodeEnum.INVALID_PROXY_ACCOUNT_ID),
    INVALID_TRANSFER_ACCOUNT_ID(ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID),
    INVALID_FEE_COLLECTOR_ACCOUNT_ID(ResponseCodeEnum.INVALID_FEE_COLLECTOR_ACCOUNT_ID),
    ALIAS_IS_IMMUTABLE(ResponseCodeEnum.ALIAS_IS_IMMUTABLE),
    SPENDER_ACCOUNT_SAME_AS_OWNER(ResponseCodeEnum.SPENDER_ACCOUNT_SAME_AS_OWNER),
    AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY(ResponseCodeEnum.AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY),
    NEGATIVE_ALLOWANCE_AMOUNT(ResponseCodeEnum.NEGATIVE_ALLOWANCE_AMOUNT),
    CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON(ResponseCodeEnum.CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON),
    SPENDER_DOES_NOT_HAVE_ALLOWANCE(ResponseCodeEnum.SPENDER_DOES_NOT_HAVE_ALLOWANCE),
    AMOUNT_EXCEEDS_ALLOWANCE(ResponseCodeEnum.AMOUNT_EXCEEDS_ALLOWANCE),
    MAX_ALLOWANCES_EXCEEDED(ResponseCodeEnum.MAX_ALLOWANCES_EXCEEDED),
    EMPTY_ALLOWANCES(ResponseCodeEnum.EMPTY_ALLOWANCES),
    SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES(ResponseCodeEnum.SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES),
    REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES(ResponseCodeEnum.REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES),
    FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES(ResponseCodeEnum.FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES),
    NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES(ResponseCodeEnum.NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES),
    INVALID_ALLOWANCE_OWNER_ID(ResponseCodeEnum.INVALID_ALLOWANCE_OWNER_ID),
    INVALID_ALLOWANCE_SPENDER_ID(ResponseCodeEnum.INVALID_ALLOWANCE_SPENDER_ID),
    REPEATED_ALLOWANCES_TO_DELETE(ResponseCodeEnum.REPEATED_ALLOWANCES_TO_DELETE),
    INVALID_DELEGATING_SPENDER(ResponseCodeEnum.INVALID_DELEGATING_SPENDER),
    DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL(ResponseCodeEnum.DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL),
    DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL(ResponseCodeEnum.DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL),
    SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE(ResponseCodeEnum.SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE),
    SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME(ResponseCodeEnum.SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME),
    SCHEDULE_FUTURE_THROTTLE_EXCEEDED(ResponseCodeEnum.SCHEDULE_FUTURE_THROTTLE_EXCEEDED),
    SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED(ResponseCodeEnum.SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED),
    INVALID_ETHEREUM_TRANSACTION(ResponseCodeEnum.INVALID_ETHEREUM_TRANSACTION),
    WRONG_CHAIN_ID(ResponseCodeEnum.WRONG_CHAIN_ID),
    WRONG_NONCE(ResponseCodeEnum.WRONG_NONCE),
    ACCESS_LIST_UNSUPPORTED(ResponseCodeEnum.ACCESS_LIST_UNSUPPORTED),
    SCHEDULE_PENDING_EXPIRATION(ResponseCodeEnum.SCHEDULE_PENDING_EXPIRATION),
    CONTRACT_IS_TOKEN_TREASURY(ResponseCodeEnum.CONTRACT_IS_TOKEN_TREASURY),
    CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES(ResponseCodeEnum.CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES),
    CONTRACT_EXPIRED_AND_PENDING_REMOVAL(ResponseCodeEnum.CONTRACT_EXPIRED_AND_PENDING_REMOVAL),
    CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT(ResponseCodeEnum.CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT),
    PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION(ResponseCodeEnum.PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION),
    PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED(ResponseCodeEnum.PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED),
    SELF_STAKING_IS_NOT_ALLOWED(ResponseCodeEnum.SELF_STAKING_IS_NOT_ALLOWED),
    INVALID_STAKING_ID(ResponseCodeEnum.INVALID_STAKING_ID),
    STAKING_NOT_ENABLED(ResponseCodeEnum.STAKING_NOT_ENABLED),
    INVALID_PRNG_RANGE(ResponseCodeEnum.INVALID_PRNG_RANGE),
    MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED(ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED),
    INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE(ResponseCodeEnum.INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE),
    INSUFFICIENT_BALANCES_FOR_STORAGE_RENT(ResponseCodeEnum.INSUFFICIENT_BALANCES_FOR_STORAGE_RENT),
    MAX_CHILD_RECORDS_EXCEEDED(ResponseCodeEnum.MAX_CHILD_RECORDS_EXCEEDED),
    INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES(ResponseCodeEnum.INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES),
    TRANSACTION_HAS_UNKNOWN_FIELDS(ResponseCodeEnum.TRANSACTION_HAS_UNKNOWN_FIELDS),
    ACCOUNT_IS_IMMUTABLE(ResponseCodeEnum.ACCOUNT_IS_IMMUTABLE),
    ALIAS_ALREADY_ASSIGNED(ResponseCodeEnum.ALIAS_ALREADY_ASSIGNED);

    final ResponseCodeEnum code;

    private Status(ResponseCodeEnum code) {
        this.code = code;
    }

    static Status valueOf(ResponseCodeEnum code) {
        Status status;
        switch (code) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case OK: {
                status = OK;
                break;
            }
            case INVALID_TRANSACTION: {
                status = INVALID_TRANSACTION;
                break;
            }
            case PAYER_ACCOUNT_NOT_FOUND: {
                status = PAYER_ACCOUNT_NOT_FOUND;
                break;
            }
            case INVALID_NODE_ACCOUNT: {
                status = INVALID_NODE_ACCOUNT;
                break;
            }
            case TRANSACTION_EXPIRED: {
                status = TRANSACTION_EXPIRED;
                break;
            }
            case INVALID_TRANSACTION_START: {
                status = INVALID_TRANSACTION_START;
                break;
            }
            case INVALID_TRANSACTION_DURATION: {
                status = INVALID_TRANSACTION_DURATION;
                break;
            }
            case INVALID_SIGNATURE: {
                status = INVALID_SIGNATURE;
                break;
            }
            case MEMO_TOO_LONG: {
                status = MEMO_TOO_LONG;
                break;
            }
            case INSUFFICIENT_TX_FEE: {
                status = INSUFFICIENT_TX_FEE;
                break;
            }
            case INSUFFICIENT_PAYER_BALANCE: {
                status = INSUFFICIENT_PAYER_BALANCE;
                break;
            }
            case DUPLICATE_TRANSACTION: {
                status = DUPLICATE_TRANSACTION;
                break;
            }
            case BUSY: {
                status = BUSY;
                break;
            }
            case NOT_SUPPORTED: {
                status = NOT_SUPPORTED;
                break;
            }
            case INVALID_FILE_ID: {
                status = INVALID_FILE_ID;
                break;
            }
            case INVALID_ACCOUNT_ID: {
                status = INVALID_ACCOUNT_ID;
                break;
            }
            case INVALID_CONTRACT_ID: {
                status = INVALID_CONTRACT_ID;
                break;
            }
            case INVALID_TRANSACTION_ID: {
                status = INVALID_TRANSACTION_ID;
                break;
            }
            case RECEIPT_NOT_FOUND: {
                status = RECEIPT_NOT_FOUND;
                break;
            }
            case RECORD_NOT_FOUND: {
                status = RECORD_NOT_FOUND;
                break;
            }
            case INVALID_SOLIDITY_ID: {
                status = INVALID_SOLIDITY_ID;
                break;
            }
            case UNKNOWN: {
                status = UNKNOWN;
                break;
            }
            case SUCCESS: {
                status = SUCCESS;
                break;
            }
            case FAIL_INVALID: {
                status = FAIL_INVALID;
                break;
            }
            case FAIL_FEE: {
                status = FAIL_FEE;
                break;
            }
            case FAIL_BALANCE: {
                status = FAIL_BALANCE;
                break;
            }
            case KEY_REQUIRED: {
                status = KEY_REQUIRED;
                break;
            }
            case BAD_ENCODING: {
                status = BAD_ENCODING;
                break;
            }
            case INSUFFICIENT_ACCOUNT_BALANCE: {
                status = INSUFFICIENT_ACCOUNT_BALANCE;
                break;
            }
            case INVALID_SOLIDITY_ADDRESS: {
                status = INVALID_SOLIDITY_ADDRESS;
                break;
            }
            case INSUFFICIENT_GAS: {
                status = INSUFFICIENT_GAS;
                break;
            }
            case CONTRACT_SIZE_LIMIT_EXCEEDED: {
                status = CONTRACT_SIZE_LIMIT_EXCEEDED;
                break;
            }
            case LOCAL_CALL_MODIFICATION_EXCEPTION: {
                status = LOCAL_CALL_MODIFICATION_EXCEPTION;
                break;
            }
            case CONTRACT_REVERT_EXECUTED: {
                status = CONTRACT_REVERT_EXECUTED;
                break;
            }
            case CONTRACT_EXECUTION_EXCEPTION: {
                status = CONTRACT_EXECUTION_EXCEPTION;
                break;
            }
            case INVALID_RECEIVING_NODE_ACCOUNT: {
                status = INVALID_RECEIVING_NODE_ACCOUNT;
                break;
            }
            case MISSING_QUERY_HEADER: {
                status = MISSING_QUERY_HEADER;
                break;
            }
            case ACCOUNT_UPDATE_FAILED: {
                status = ACCOUNT_UPDATE_FAILED;
                break;
            }
            case INVALID_KEY_ENCODING: {
                status = INVALID_KEY_ENCODING;
                break;
            }
            case NULL_SOLIDITY_ADDRESS: {
                status = NULL_SOLIDITY_ADDRESS;
                break;
            }
            case CONTRACT_UPDATE_FAILED: {
                status = CONTRACT_UPDATE_FAILED;
                break;
            }
            case INVALID_QUERY_HEADER: {
                status = INVALID_QUERY_HEADER;
                break;
            }
            case INVALID_FEE_SUBMITTED: {
                status = INVALID_FEE_SUBMITTED;
                break;
            }
            case INVALID_PAYER_SIGNATURE: {
                status = INVALID_PAYER_SIGNATURE;
                break;
            }
            case KEY_NOT_PROVIDED: {
                status = KEY_NOT_PROVIDED;
                break;
            }
            case INVALID_EXPIRATION_TIME: {
                status = INVALID_EXPIRATION_TIME;
                break;
            }
            case NO_WACL_KEY: {
                status = NO_WACL_KEY;
                break;
            }
            case FILE_CONTENT_EMPTY: {
                status = FILE_CONTENT_EMPTY;
                break;
            }
            case INVALID_ACCOUNT_AMOUNTS: {
                status = INVALID_ACCOUNT_AMOUNTS;
                break;
            }
            case EMPTY_TRANSACTION_BODY: {
                status = EMPTY_TRANSACTION_BODY;
                break;
            }
            case INVALID_TRANSACTION_BODY: {
                status = INVALID_TRANSACTION_BODY;
                break;
            }
            case INVALID_SIGNATURE_TYPE_MISMATCHING_KEY: {
                status = INVALID_SIGNATURE_TYPE_MISMATCHING_KEY;
                break;
            }
            case INVALID_SIGNATURE_COUNT_MISMATCHING_KEY: {
                status = INVALID_SIGNATURE_COUNT_MISMATCHING_KEY;
                break;
            }
            case EMPTY_LIVE_HASH_BODY: {
                status = EMPTY_LIVE_HASH_BODY;
                break;
            }
            case EMPTY_LIVE_HASH: {
                status = EMPTY_LIVE_HASH;
                break;
            }
            case EMPTY_LIVE_HASH_KEYS: {
                status = EMPTY_LIVE_HASH_KEYS;
                break;
            }
            case INVALID_LIVE_HASH_SIZE: {
                status = INVALID_LIVE_HASH_SIZE;
                break;
            }
            case EMPTY_QUERY_BODY: {
                status = EMPTY_QUERY_BODY;
                break;
            }
            case EMPTY_LIVE_HASH_QUERY: {
                status = EMPTY_LIVE_HASH_QUERY;
                break;
            }
            case LIVE_HASH_NOT_FOUND: {
                status = LIVE_HASH_NOT_FOUND;
                break;
            }
            case ACCOUNT_ID_DOES_NOT_EXIST: {
                status = ACCOUNT_ID_DOES_NOT_EXIST;
                break;
            }
            case LIVE_HASH_ALREADY_EXISTS: {
                status = LIVE_HASH_ALREADY_EXISTS;
                break;
            }
            case INVALID_FILE_WACL: {
                status = INVALID_FILE_WACL;
                break;
            }
            case SERIALIZATION_FAILED: {
                status = SERIALIZATION_FAILED;
                break;
            }
            case TRANSACTION_OVERSIZE: {
                status = TRANSACTION_OVERSIZE;
                break;
            }
            case TRANSACTION_TOO_MANY_LAYERS: {
                status = TRANSACTION_TOO_MANY_LAYERS;
                break;
            }
            case CONTRACT_DELETED: {
                status = CONTRACT_DELETED;
                break;
            }
            case PLATFORM_NOT_ACTIVE: {
                status = PLATFORM_NOT_ACTIVE;
                break;
            }
            case KEY_PREFIX_MISMATCH: {
                status = KEY_PREFIX_MISMATCH;
                break;
            }
            case PLATFORM_TRANSACTION_NOT_CREATED: {
                status = PLATFORM_TRANSACTION_NOT_CREATED;
                break;
            }
            case INVALID_RENEWAL_PERIOD: {
                status = INVALID_RENEWAL_PERIOD;
                break;
            }
            case INVALID_PAYER_ACCOUNT_ID: {
                status = INVALID_PAYER_ACCOUNT_ID;
                break;
            }
            case ACCOUNT_DELETED: {
                status = ACCOUNT_DELETED;
                break;
            }
            case FILE_DELETED: {
                status = FILE_DELETED;
                break;
            }
            case ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS: {
                status = ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS;
                break;
            }
            case SETTING_NEGATIVE_ACCOUNT_BALANCE: {
                status = SETTING_NEGATIVE_ACCOUNT_BALANCE;
                break;
            }
            case OBTAINER_REQUIRED: {
                status = OBTAINER_REQUIRED;
                break;
            }
            case OBTAINER_SAME_CONTRACT_ID: {
                status = OBTAINER_SAME_CONTRACT_ID;
                break;
            }
            case OBTAINER_DOES_NOT_EXIST: {
                status = OBTAINER_DOES_NOT_EXIST;
                break;
            }
            case MODIFYING_IMMUTABLE_CONTRACT: {
                status = MODIFYING_IMMUTABLE_CONTRACT;
                break;
            }
            case FILE_SYSTEM_EXCEPTION: {
                status = FILE_SYSTEM_EXCEPTION;
                break;
            }
            case AUTORENEW_DURATION_NOT_IN_RANGE: {
                status = AUTORENEW_DURATION_NOT_IN_RANGE;
                break;
            }
            case ERROR_DECODING_BYTESTRING: {
                status = ERROR_DECODING_BYTESTRING;
                break;
            }
            case CONTRACT_FILE_EMPTY: {
                status = CONTRACT_FILE_EMPTY;
                break;
            }
            case CONTRACT_BYTECODE_EMPTY: {
                status = CONTRACT_BYTECODE_EMPTY;
                break;
            }
            case INVALID_INITIAL_BALANCE: {
                status = INVALID_INITIAL_BALANCE;
                break;
            }
            case INVALID_RECEIVE_RECORD_THRESHOLD: {
                status = INVALID_RECEIVE_RECORD_THRESHOLD;
                break;
            }
            case INVALID_SEND_RECORD_THRESHOLD: {
                status = INVALID_SEND_RECORD_THRESHOLD;
                break;
            }
            case ACCOUNT_IS_NOT_GENESIS_ACCOUNT: {
                status = ACCOUNT_IS_NOT_GENESIS_ACCOUNT;
                break;
            }
            case PAYER_ACCOUNT_UNAUTHORIZED: {
                status = PAYER_ACCOUNT_UNAUTHORIZED;
                break;
            }
            case INVALID_FREEZE_TRANSACTION_BODY: {
                status = INVALID_FREEZE_TRANSACTION_BODY;
                break;
            }
            case FREEZE_TRANSACTION_BODY_NOT_FOUND: {
                status = FREEZE_TRANSACTION_BODY_NOT_FOUND;
                break;
            }
            case TRANSFER_LIST_SIZE_LIMIT_EXCEEDED: {
                status = TRANSFER_LIST_SIZE_LIMIT_EXCEEDED;
                break;
            }
            case RESULT_SIZE_LIMIT_EXCEEDED: {
                status = RESULT_SIZE_LIMIT_EXCEEDED;
                break;
            }
            case NOT_SPECIAL_ACCOUNT: {
                status = NOT_SPECIAL_ACCOUNT;
                break;
            }
            case CONTRACT_NEGATIVE_GAS: {
                status = CONTRACT_NEGATIVE_GAS;
                break;
            }
            case CONTRACT_NEGATIVE_VALUE: {
                status = CONTRACT_NEGATIVE_VALUE;
                break;
            }
            case INVALID_FEE_FILE: {
                status = INVALID_FEE_FILE;
                break;
            }
            case INVALID_EXCHANGE_RATE_FILE: {
                status = INVALID_EXCHANGE_RATE_FILE;
                break;
            }
            case INSUFFICIENT_LOCAL_CALL_GAS: {
                status = INSUFFICIENT_LOCAL_CALL_GAS;
                break;
            }
            case ENTITY_NOT_ALLOWED_TO_DELETE: {
                status = ENTITY_NOT_ALLOWED_TO_DELETE;
                break;
            }
            case AUTHORIZATION_FAILED: {
                status = AUTHORIZATION_FAILED;
                break;
            }
            case FILE_UPLOADED_PROTO_INVALID: {
                status = FILE_UPLOADED_PROTO_INVALID;
                break;
            }
            case FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK: {
                status = FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK;
                break;
            }
            case FEE_SCHEDULE_FILE_PART_UPLOADED: {
                status = FEE_SCHEDULE_FILE_PART_UPLOADED;
                break;
            }
            case EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED: {
                status = EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED;
                break;
            }
            case MAX_CONTRACT_STORAGE_EXCEEDED: {
                status = MAX_CONTRACT_STORAGE_EXCEEDED;
                break;
            }
            case TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT: {
                status = TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT;
                break;
            }
            case TOTAL_LEDGER_BALANCE_INVALID: {
                status = TOTAL_LEDGER_BALANCE_INVALID;
                break;
            }
            case EXPIRATION_REDUCTION_NOT_ALLOWED: {
                status = EXPIRATION_REDUCTION_NOT_ALLOWED;
                break;
            }
            case MAX_GAS_LIMIT_EXCEEDED: {
                status = MAX_GAS_LIMIT_EXCEEDED;
                break;
            }
            case MAX_FILE_SIZE_EXCEEDED: {
                status = MAX_FILE_SIZE_EXCEEDED;
                break;
            }
            case RECEIVER_SIG_REQUIRED: {
                status = RECEIVER_SIG_REQUIRED;
                break;
            }
            case INVALID_TOPIC_ID: {
                status = INVALID_TOPIC_ID;
                break;
            }
            case INVALID_ADMIN_KEY: {
                status = INVALID_ADMIN_KEY;
                break;
            }
            case INVALID_SUBMIT_KEY: {
                status = INVALID_SUBMIT_KEY;
                break;
            }
            case UNAUTHORIZED: {
                status = UNAUTHORIZED;
                break;
            }
            case INVALID_TOPIC_MESSAGE: {
                status = INVALID_TOPIC_MESSAGE;
                break;
            }
            case INVALID_AUTORENEW_ACCOUNT: {
                status = INVALID_AUTORENEW_ACCOUNT;
                break;
            }
            case AUTORENEW_ACCOUNT_NOT_ALLOWED: {
                status = AUTORENEW_ACCOUNT_NOT_ALLOWED;
                break;
            }
            case TOPIC_EXPIRED: {
                status = TOPIC_EXPIRED;
                break;
            }
            case INVALID_CHUNK_NUMBER: {
                status = INVALID_CHUNK_NUMBER;
                break;
            }
            case INVALID_CHUNK_TRANSACTION_ID: {
                status = INVALID_CHUNK_TRANSACTION_ID;
                break;
            }
            case ACCOUNT_FROZEN_FOR_TOKEN: {
                status = ACCOUNT_FROZEN_FOR_TOKEN;
                break;
            }
            case TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED: {
                status = TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED;
                break;
            }
            case INVALID_TOKEN_ID: {
                status = INVALID_TOKEN_ID;
                break;
            }
            case INVALID_TOKEN_DECIMALS: {
                status = INVALID_TOKEN_DECIMALS;
                break;
            }
            case INVALID_TOKEN_INITIAL_SUPPLY: {
                status = INVALID_TOKEN_INITIAL_SUPPLY;
                break;
            }
            case INVALID_TREASURY_ACCOUNT_FOR_TOKEN: {
                status = INVALID_TREASURY_ACCOUNT_FOR_TOKEN;
                break;
            }
            case INVALID_TOKEN_SYMBOL: {
                status = INVALID_TOKEN_SYMBOL;
                break;
            }
            case TOKEN_HAS_NO_FREEZE_KEY: {
                status = TOKEN_HAS_NO_FREEZE_KEY;
                break;
            }
            case TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN: {
                status = TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN;
                break;
            }
            case MISSING_TOKEN_SYMBOL: {
                status = MISSING_TOKEN_SYMBOL;
                break;
            }
            case TOKEN_SYMBOL_TOO_LONG: {
                status = TOKEN_SYMBOL_TOO_LONG;
                break;
            }
            case ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN: {
                status = ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN;
                break;
            }
            case TOKEN_HAS_NO_KYC_KEY: {
                status = TOKEN_HAS_NO_KYC_KEY;
                break;
            }
            case INSUFFICIENT_TOKEN_BALANCE: {
                status = INSUFFICIENT_TOKEN_BALANCE;
                break;
            }
            case TOKEN_WAS_DELETED: {
                status = TOKEN_WAS_DELETED;
                break;
            }
            case TOKEN_HAS_NO_SUPPLY_KEY: {
                status = TOKEN_HAS_NO_SUPPLY_KEY;
                break;
            }
            case TOKEN_HAS_NO_WIPE_KEY: {
                status = TOKEN_HAS_NO_WIPE_KEY;
                break;
            }
            case INVALID_TOKEN_MINT_AMOUNT: {
                status = INVALID_TOKEN_MINT_AMOUNT;
                break;
            }
            case INVALID_TOKEN_BURN_AMOUNT: {
                status = INVALID_TOKEN_BURN_AMOUNT;
                break;
            }
            case TOKEN_NOT_ASSOCIATED_TO_ACCOUNT: {
                status = TOKEN_NOT_ASSOCIATED_TO_ACCOUNT;
                break;
            }
            case CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT: {
                status = CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT;
                break;
            }
            case INVALID_KYC_KEY: {
                status = INVALID_KYC_KEY;
                break;
            }
            case INVALID_WIPE_KEY: {
                status = INVALID_WIPE_KEY;
                break;
            }
            case INVALID_FREEZE_KEY: {
                status = INVALID_FREEZE_KEY;
                break;
            }
            case INVALID_SUPPLY_KEY: {
                status = INVALID_SUPPLY_KEY;
                break;
            }
            case MISSING_TOKEN_NAME: {
                status = MISSING_TOKEN_NAME;
                break;
            }
            case TOKEN_NAME_TOO_LONG: {
                status = TOKEN_NAME_TOO_LONG;
                break;
            }
            case INVALID_WIPING_AMOUNT: {
                status = INVALID_WIPING_AMOUNT;
                break;
            }
            case TOKEN_IS_IMMUTABLE: {
                status = TOKEN_IS_IMMUTABLE;
                break;
            }
            case TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT: {
                status = TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT;
                break;
            }
            case TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES: {
                status = TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES;
                break;
            }
            case ACCOUNT_IS_TREASURY: {
                status = ACCOUNT_IS_TREASURY;
                break;
            }
            case TOKEN_ID_REPEATED_IN_TOKEN_LIST: {
                status = TOKEN_ID_REPEATED_IN_TOKEN_LIST;
                break;
            }
            case TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED: {
                status = TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED;
                break;
            }
            case EMPTY_TOKEN_TRANSFER_BODY: {
                status = EMPTY_TOKEN_TRANSFER_BODY;
                break;
            }
            case EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS: {
                status = EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS;
                break;
            }
            case INVALID_SCHEDULE_ID: {
                status = INVALID_SCHEDULE_ID;
                break;
            }
            case SCHEDULE_IS_IMMUTABLE: {
                status = SCHEDULE_IS_IMMUTABLE;
                break;
            }
            case INVALID_SCHEDULE_PAYER_ID: {
                status = INVALID_SCHEDULE_PAYER_ID;
                break;
            }
            case INVALID_SCHEDULE_ACCOUNT_ID: {
                status = INVALID_SCHEDULE_ACCOUNT_ID;
                break;
            }
            case NO_NEW_VALID_SIGNATURES: {
                status = NO_NEW_VALID_SIGNATURES;
                break;
            }
            case UNRESOLVABLE_REQUIRED_SIGNERS: {
                status = UNRESOLVABLE_REQUIRED_SIGNERS;
                break;
            }
            case SCHEDULED_TRANSACTION_NOT_IN_WHITELIST: {
                status = SCHEDULED_TRANSACTION_NOT_IN_WHITELIST;
                break;
            }
            case SOME_SIGNATURES_WERE_INVALID: {
                status = SOME_SIGNATURES_WERE_INVALID;
                break;
            }
            case TRANSACTION_ID_FIELD_NOT_ALLOWED: {
                status = TRANSACTION_ID_FIELD_NOT_ALLOWED;
                break;
            }
            case IDENTICAL_SCHEDULE_ALREADY_CREATED: {
                status = IDENTICAL_SCHEDULE_ALREADY_CREATED;
                break;
            }
            case INVALID_ZERO_BYTE_IN_STRING: {
                status = INVALID_ZERO_BYTE_IN_STRING;
                break;
            }
            case SCHEDULE_ALREADY_DELETED: {
                status = SCHEDULE_ALREADY_DELETED;
                break;
            }
            case SCHEDULE_ALREADY_EXECUTED: {
                status = SCHEDULE_ALREADY_EXECUTED;
                break;
            }
            case MESSAGE_SIZE_TOO_LARGE: {
                status = MESSAGE_SIZE_TOO_LARGE;
                break;
            }
            case OPERATION_REPEATED_IN_BUCKET_GROUPS: {
                status = OPERATION_REPEATED_IN_BUCKET_GROUPS;
                break;
            }
            case BUCKET_CAPACITY_OVERFLOW: {
                status = BUCKET_CAPACITY_OVERFLOW;
                break;
            }
            case NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION: {
                status = NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION;
                break;
            }
            case BUCKET_HAS_NO_THROTTLE_GROUPS: {
                status = BUCKET_HAS_NO_THROTTLE_GROUPS;
                break;
            }
            case THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC: {
                status = THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC;
                break;
            }
            case SUCCESS_BUT_MISSING_EXPECTED_OPERATION: {
                status = SUCCESS_BUT_MISSING_EXPECTED_OPERATION;
                break;
            }
            case UNPARSEABLE_THROTTLE_DEFINITIONS: {
                status = UNPARSEABLE_THROTTLE_DEFINITIONS;
                break;
            }
            case INVALID_THROTTLE_DEFINITIONS: {
                status = INVALID_THROTTLE_DEFINITIONS;
                break;
            }
            case ACCOUNT_EXPIRED_AND_PENDING_REMOVAL: {
                status = ACCOUNT_EXPIRED_AND_PENDING_REMOVAL;
                break;
            }
            case INVALID_TOKEN_MAX_SUPPLY: {
                status = INVALID_TOKEN_MAX_SUPPLY;
                break;
            }
            case INVALID_TOKEN_NFT_SERIAL_NUMBER: {
                status = INVALID_TOKEN_NFT_SERIAL_NUMBER;
                break;
            }
            case INVALID_NFT_ID: {
                status = INVALID_NFT_ID;
                break;
            }
            case METADATA_TOO_LONG: {
                status = METADATA_TOO_LONG;
                break;
            }
            case BATCH_SIZE_LIMIT_EXCEEDED: {
                status = BATCH_SIZE_LIMIT_EXCEEDED;
                break;
            }
            case INVALID_QUERY_RANGE: {
                status = INVALID_QUERY_RANGE;
                break;
            }
            case FRACTION_DIVIDES_BY_ZERO: {
                status = FRACTION_DIVIDES_BY_ZERO;
                break;
            }
            case INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE: {
                status = INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE;
                break;
            }
            case CUSTOM_FEES_LIST_TOO_LONG: {
                status = CUSTOM_FEES_LIST_TOO_LONG;
                break;
            }
            case INVALID_CUSTOM_FEE_COLLECTOR: {
                status = INVALID_CUSTOM_FEE_COLLECTOR;
                break;
            }
            case INVALID_TOKEN_ID_IN_CUSTOM_FEES: {
                status = INVALID_TOKEN_ID_IN_CUSTOM_FEES;
                break;
            }
            case TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR: {
                status = TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR;
                break;
            }
            case TOKEN_MAX_SUPPLY_REACHED: {
                status = TOKEN_MAX_SUPPLY_REACHED;
                break;
            }
            case SENDER_DOES_NOT_OWN_NFT_SERIAL_NO: {
                status = SENDER_DOES_NOT_OWN_NFT_SERIAL_NO;
                break;
            }
            case CUSTOM_FEE_NOT_FULLY_SPECIFIED: {
                status = CUSTOM_FEE_NOT_FULLY_SPECIFIED;
                break;
            }
            case CUSTOM_FEE_MUST_BE_POSITIVE: {
                status = CUSTOM_FEE_MUST_BE_POSITIVE;
                break;
            }
            case TOKEN_HAS_NO_FEE_SCHEDULE_KEY: {
                status = TOKEN_HAS_NO_FEE_SCHEDULE_KEY;
                break;
            }
            case CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE: {
                status = CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE;
                break;
            }
            case ROYALTY_FRACTION_CANNOT_EXCEED_ONE: {
                status = ROYALTY_FRACTION_CANNOT_EXCEED_ONE;
                break;
            }
            case FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT: {
                status = FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT;
                break;
            }
            case CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES: {
                status = CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES;
                break;
            }
            case CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON: {
                status = CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON;
                break;
            }
            case CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON: {
                status = CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON;
                break;
            }
            case INVALID_CUSTOM_FEE_SCHEDULE_KEY: {
                status = INVALID_CUSTOM_FEE_SCHEDULE_KEY;
                break;
            }
            case INVALID_TOKEN_MINT_METADATA: {
                status = INVALID_TOKEN_MINT_METADATA;
                break;
            }
            case INVALID_TOKEN_BURN_METADATA: {
                status = INVALID_TOKEN_BURN_METADATA;
                break;
            }
            case CURRENT_TREASURY_STILL_OWNS_NFTS: {
                status = CURRENT_TREASURY_STILL_OWNS_NFTS;
                break;
            }
            case ACCOUNT_STILL_OWNS_NFTS: {
                status = ACCOUNT_STILL_OWNS_NFTS;
                break;
            }
            case TREASURY_MUST_OWN_BURNED_NFT: {
                status = TREASURY_MUST_OWN_BURNED_NFT;
                break;
            }
            case ACCOUNT_DOES_NOT_OWN_WIPED_NFT: {
                status = ACCOUNT_DOES_NOT_OWN_WIPED_NFT;
                break;
            }
            case ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON: {
                status = ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON;
                break;
            }
            case MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED: {
                status = MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED;
                break;
            }
            case PAYER_ACCOUNT_DELETED: {
                status = PAYER_ACCOUNT_DELETED;
                break;
            }
            case CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH: {
                status = CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH;
                break;
            }
            case CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS: {
                status = CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS;
                break;
            }
            case INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE: {
                status = INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE;
                break;
            }
            case SERIAL_NUMBER_LIMIT_REACHED: {
                status = SERIAL_NUMBER_LIMIT_REACHED;
                break;
            }
            case CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE: {
                status = CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE;
                break;
            }
            case NO_REMAINING_AUTOMATIC_ASSOCIATIONS: {
                status = NO_REMAINING_AUTOMATIC_ASSOCIATIONS;
                break;
            }
            case EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT: {
                status = EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT;
                break;
            }
            case REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT: {
                status = REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT;
                break;
            }
            case TOKEN_IS_PAUSED: {
                status = TOKEN_IS_PAUSED;
                break;
            }
            case TOKEN_HAS_NO_PAUSE_KEY: {
                status = TOKEN_HAS_NO_PAUSE_KEY;
                break;
            }
            case INVALID_PAUSE_KEY: {
                status = INVALID_PAUSE_KEY;
                break;
            }
            case FREEZE_UPDATE_FILE_DOES_NOT_EXIST: {
                status = FREEZE_UPDATE_FILE_DOES_NOT_EXIST;
                break;
            }
            case FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH: {
                status = FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH;
                break;
            }
            case NO_UPGRADE_HAS_BEEN_PREPARED: {
                status = NO_UPGRADE_HAS_BEEN_PREPARED;
                break;
            }
            case NO_FREEZE_IS_SCHEDULED: {
                status = NO_FREEZE_IS_SCHEDULED;
                break;
            }
            case UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE: {
                status = UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE;
                break;
            }
            case FREEZE_START_TIME_MUST_BE_FUTURE: {
                status = FREEZE_START_TIME_MUST_BE_FUTURE;
                break;
            }
            case PREPARED_UPDATE_FILE_IS_IMMUTABLE: {
                status = PREPARED_UPDATE_FILE_IS_IMMUTABLE;
                break;
            }
            case FREEZE_ALREADY_SCHEDULED: {
                status = FREEZE_ALREADY_SCHEDULED;
                break;
            }
            case FREEZE_UPGRADE_IN_PROGRESS: {
                status = FREEZE_UPGRADE_IN_PROGRESS;
                break;
            }
            case UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED: {
                status = UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED;
                break;
            }
            case UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED: {
                status = UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED;
                break;
            }
            case CONSENSUS_GAS_EXHAUSTED: {
                status = CONSENSUS_GAS_EXHAUSTED;
                break;
            }
            case REVERTED_SUCCESS: {
                status = REVERTED_SUCCESS;
                break;
            }
            case MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED: {
                status = MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED;
                break;
            }
            case INVALID_ALIAS_KEY: {
                status = INVALID_ALIAS_KEY;
                break;
            }
            case UNEXPECTED_TOKEN_DECIMALS: {
                status = UNEXPECTED_TOKEN_DECIMALS;
                break;
            }
            case INVALID_PROXY_ACCOUNT_ID: {
                status = INVALID_PROXY_ACCOUNT_ID;
                break;
            }
            case INVALID_TRANSFER_ACCOUNT_ID: {
                status = INVALID_TRANSFER_ACCOUNT_ID;
                break;
            }
            case INVALID_FEE_COLLECTOR_ACCOUNT_ID: {
                status = INVALID_FEE_COLLECTOR_ACCOUNT_ID;
                break;
            }
            case ALIAS_IS_IMMUTABLE: {
                status = ALIAS_IS_IMMUTABLE;
                break;
            }
            case SPENDER_ACCOUNT_SAME_AS_OWNER: {
                status = SPENDER_ACCOUNT_SAME_AS_OWNER;
                break;
            }
            case AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY: {
                status = AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY;
                break;
            }
            case NEGATIVE_ALLOWANCE_AMOUNT: {
                status = NEGATIVE_ALLOWANCE_AMOUNT;
                break;
            }
            case CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON: {
                status = CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON;
                break;
            }
            case SPENDER_DOES_NOT_HAVE_ALLOWANCE: {
                status = SPENDER_DOES_NOT_HAVE_ALLOWANCE;
                break;
            }
            case AMOUNT_EXCEEDS_ALLOWANCE: {
                status = AMOUNT_EXCEEDS_ALLOWANCE;
                break;
            }
            case MAX_ALLOWANCES_EXCEEDED: {
                status = MAX_ALLOWANCES_EXCEEDED;
                break;
            }
            case EMPTY_ALLOWANCES: {
                status = EMPTY_ALLOWANCES;
                break;
            }
            case SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES: {
                status = SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES;
                break;
            }
            case REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES: {
                status = REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES;
                break;
            }
            case FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES: {
                status = FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES;
                break;
            }
            case NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES: {
                status = NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES;
                break;
            }
            case INVALID_ALLOWANCE_OWNER_ID: {
                status = INVALID_ALLOWANCE_OWNER_ID;
                break;
            }
            case INVALID_ALLOWANCE_SPENDER_ID: {
                status = INVALID_ALLOWANCE_SPENDER_ID;
                break;
            }
            case REPEATED_ALLOWANCES_TO_DELETE: {
                status = REPEATED_ALLOWANCES_TO_DELETE;
                break;
            }
            case INVALID_DELEGATING_SPENDER: {
                status = INVALID_DELEGATING_SPENDER;
                break;
            }
            case DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL: {
                status = DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL;
                break;
            }
            case DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL: {
                status = DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL;
                break;
            }
            case SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE: {
                status = SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE;
                break;
            }
            case SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME: {
                status = SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME;
                break;
            }
            case SCHEDULE_FUTURE_THROTTLE_EXCEEDED: {
                status = SCHEDULE_FUTURE_THROTTLE_EXCEEDED;
                break;
            }
            case SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED: {
                status = SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED;
                break;
            }
            case INVALID_ETHEREUM_TRANSACTION: {
                status = INVALID_ETHEREUM_TRANSACTION;
                break;
            }
            case WRONG_CHAIN_ID: {
                status = WRONG_CHAIN_ID;
                break;
            }
            case WRONG_NONCE: {
                status = WRONG_NONCE;
                break;
            }
            case ACCESS_LIST_UNSUPPORTED: {
                status = ACCESS_LIST_UNSUPPORTED;
                break;
            }
            case SCHEDULE_PENDING_EXPIRATION: {
                status = SCHEDULE_PENDING_EXPIRATION;
                break;
            }
            case CONTRACT_IS_TOKEN_TREASURY: {
                status = CONTRACT_IS_TOKEN_TREASURY;
                break;
            }
            case CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES: {
                status = CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES;
                break;
            }
            case CONTRACT_EXPIRED_AND_PENDING_REMOVAL: {
                status = CONTRACT_EXPIRED_AND_PENDING_REMOVAL;
                break;
            }
            case CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT: {
                status = CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT;
                break;
            }
            case PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION: {
                status = PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION;
                break;
            }
            case PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED: {
                status = PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED;
                break;
            }
            case SELF_STAKING_IS_NOT_ALLOWED: {
                status = SELF_STAKING_IS_NOT_ALLOWED;
                break;
            }
            case INVALID_STAKING_ID: {
                status = INVALID_STAKING_ID;
                break;
            }
            case STAKING_NOT_ENABLED: {
                status = STAKING_NOT_ENABLED;
                break;
            }
            case INVALID_PRNG_RANGE: {
                status = INVALID_PRNG_RANGE;
                break;
            }
            case MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED: {
                status = MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED;
                break;
            }
            case INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE: {
                status = INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE;
                break;
            }
            case INSUFFICIENT_BALANCES_FOR_STORAGE_RENT: {
                status = INSUFFICIENT_BALANCES_FOR_STORAGE_RENT;
                break;
            }
            case MAX_CHILD_RECORDS_EXCEEDED: {
                status = MAX_CHILD_RECORDS_EXCEEDED;
                break;
            }
            case INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES: {
                status = INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES;
                break;
            }
            case TRANSACTION_HAS_UNKNOWN_FIELDS: {
                status = TRANSACTION_HAS_UNKNOWN_FIELDS;
                break;
            }
            case ACCOUNT_IS_IMMUTABLE: {
                status = ACCOUNT_IS_IMMUTABLE;
                break;
            }
            case ALIAS_ALREADY_ASSIGNED: {
                status = ALIAS_ALREADY_ASSIGNED;
                break;
            }
            case UNRECOGNIZED: {
                throw new IllegalArgumentException("network returned unrecognized response code; your SDK may be out of date");
            }
        }
        return status;
    }

    public static Status fromResponseCode(int reponseCode) {
        return Status.valueOf(Objects.requireNonNull(ResponseCodeEnum.forNumber(reponseCode)));
    }

    public int toResponseCode() {
        return this.code.getNumber();
    }

    public String toString() {
        return this.code.name();
    }
}

