/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ExecutionState;
import com.hedera.hashgraph.sdk.Query;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Query;
import com.hedera.hashgraph.sdk.proto.QueryHeader;
import com.hedera.hashgraph.sdk.proto.Response;
import com.hedera.hashgraph.sdk.proto.ResponseHeader;
import com.hedera.hashgraph.sdk.proto.TransactionGetRecordQuery;
import com.hedera.hashgraph.sdk.proto.TransactionGetRecordResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TransactionRecordQuery
extends Query<TransactionRecord, TransactionRecordQuery> {
    @Nullable
    private TransactionId transactionId = null;
    private boolean includeChildren = false;
    private boolean includeDuplicates = false;

    @Override
    @Nullable
    public TransactionId getTransactionIdInternal() {
        return this.transactionId;
    }

    public TransactionRecordQuery setTransactionId(TransactionId transactionId) {
        Objects.requireNonNull(transactionId);
        this.transactionId = transactionId;
        return this;
    }

    public boolean getIncludeDuplicates() {
        return this.includeDuplicates;
    }

    public TransactionRecordQuery setIncludeDuplicates(boolean value) {
        this.includeDuplicates = value;
        return this;
    }

    public boolean getIncludeChildren() {
        return this.includeChildren;
    }

    public TransactionRecordQuery setIncludeChildren(boolean value) {
        this.includeChildren = value;
        return this;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.transactionId != null) {
            Objects.requireNonNull(this.transactionId.accountId).validateChecksum(client);
        }
    }

    @Override
    void onMakeRequest(Query.Builder queryBuilder, QueryHeader header) {
        TransactionGetRecordQuery.Builder builder = TransactionGetRecordQuery.newBuilder().setIncludeChildRecords(this.includeChildren).setIncludeDuplicates(this.includeDuplicates);
        if (this.transactionId != null) {
            builder.setTransactionID(this.transactionId.toProtobuf());
        }
        queryBuilder.setTransactionGetRecord(builder.setHeader(header));
    }

    @Override
    ResponseHeader mapResponseHeader(Response response) {
        return response.getTransactionGetRecord().getHeader();
    }

    @Override
    QueryHeader mapRequestHeader(com.hedera.hashgraph.sdk.proto.Query request) {
        return request.getTransactionGetRecord().getHeader();
    }

    @Override
    TransactionRecord mapResponse(Response response, AccountId nodeId, com.hedera.hashgraph.sdk.proto.Query request) {
        TransactionGetRecordResponse recordResponse = response.getTransactionGetRecord();
        List<TransactionRecord> children = this.mapRecordList(recordResponse.getChildTransactionRecordsList());
        List<TransactionRecord> duplicates = this.mapRecordList(recordResponse.getDuplicateTransactionRecordsList());
        return TransactionRecord.fromProtobuf(recordResponse.getTransactionRecord(), children, duplicates, this.transactionId);
    }

    private List<TransactionRecord> mapRecordList(List<com.hedera.hashgraph.sdk.proto.TransactionRecord> protoRecordList) {
        ArrayList<TransactionRecord> outList = new ArrayList<TransactionRecord>(protoRecordList.size());
        for (com.hedera.hashgraph.sdk.proto.TransactionRecord protoRecord : protoRecordList) {
            outList.add(TransactionRecord.fromProtobuf(protoRecord));
        }
        return outList;
    }

    @Override
    MethodDescriptor<com.hedera.hashgraph.sdk.proto.Query, Response> getMethodDescriptor() {
        return CryptoServiceGrpc.getGetTxRecordByTxIDMethod();
    }

    @Override
    ExecutionState shouldRetry(Status status, Response response) {
        ExecutionState retry = super.shouldRetry(status, response);
        if (retry != ExecutionState.Success) {
            return retry;
        }
        switch (status) {
            case BUSY: 
            case UNKNOWN: 
            case RECEIPT_NOT_FOUND: 
            case RECORD_NOT_FOUND: {
                return ExecutionState.Retry;
            }
            case OK: {
                if (this.paymentTransactions != null && !this.paymentTransactions.isEmpty()) break;
                return ExecutionState.Success;
            }
            default: {
                return ExecutionState.RequestError;
            }
        }
        Status receiptStatus = Status.valueOf(response.getTransactionGetRecord().getTransactionRecord().getReceipt().getStatus());
        switch (receiptStatus) {
            case BUSY: 
            case UNKNOWN: 
            case RECEIPT_NOT_FOUND: 
            case RECORD_NOT_FOUND: 
            case OK: {
                return ExecutionState.Retry;
            }
        }
        return ExecutionState.Success;
    }
}

