/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoDeleteTransactionBody;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AccountDeleteTransaction
extends com.hedera.hashgraph.sdk.Transaction<AccountDeleteTransaction> {
    @Nullable
    private AccountId accountId = null;
    @Nullable
    private AccountId transferAccountId = null;

    public AccountDeleteTransaction() {
    }

    AccountDeleteTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    AccountDeleteTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public AccountDeleteTransaction setAccountId(AccountId deleteAccountId) {
        Objects.requireNonNull(deleteAccountId);
        this.requireNotFrozen();
        this.accountId = deleteAccountId;
        return this;
    }

    @Nullable
    public AccountId getTransferAccountId() {
        return this.transferAccountId;
    }

    public AccountDeleteTransaction setTransferAccountId(AccountId transferAccountId) {
        this.requireNotFrozen();
        Objects.requireNonNull(transferAccountId);
        this.transferAccountId = transferAccountId;
        return this;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
        if (this.transferAccountId != null) {
            this.transferAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getCryptoDeleteMethod();
    }

    CryptoDeleteTransactionBody.Builder build() {
        CryptoDeleteTransactionBody.Builder builder = CryptoDeleteTransactionBody.newBuilder();
        if (this.accountId != null) {
            builder.setDeleteAccountID(this.accountId.toProtobuf());
        }
        if (this.transferAccountId != null) {
            builder.setTransferAccountID(this.transferAccountId.toProtobuf());
        }
        return builder;
    }

    void initFromTransactionBody() {
        CryptoDeleteTransactionBody body = this.sourceTransactionBody.getCryptoDelete();
        if (body.hasDeleteAccountID()) {
            this.accountId = AccountId.fromProtobuf(body.getDeleteAccountID());
        }
        if (body.hasTransferAccountID()) {
            this.transferAccountId = AccountId.fromProtobuf(body.getTransferAccountID());
        }
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoDelete(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setCryptoDelete(this.build());
    }
}

