/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hashgraph.sdk.BaseNode;
import com.hedera.hashgraph.sdk.BaseNodeAddress;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.LedgerId;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

abstract class BaseNetwork<BaseNetworkT extends BaseNetwork<BaseNetworkT, KeyT, BaseNodeT>, KeyT, BaseNodeT extends BaseNode<BaseNodeT, KeyT>> {
    protected static final Integer DEFAULT_MAX_NODE_ATTEMPTS = -1;
    protected static final Random random = new Random();
    protected final ExecutorService executor;
    protected Map<KeyT, List<BaseNodeT>> network = new ConcurrentHashMap<KeyT, List<BaseNodeT>>();
    protected List<BaseNodeT> nodes = new ArrayList<BaseNodeT>();
    protected List<BaseNodeT> healthyNodes = new ArrayList<BaseNodeT>();
    protected Duration minNodeBackoff = Client.DEFAULT_MIN_NODE_BACKOFF;
    protected Duration maxNodeBackoff = Client.DEFAULT_MAX_NODE_BACKOFF;
    protected Duration closeTimeout = Client.DEFAULT_CLOSE_TIMEOUT;
    protected int maxNodeAttempts = DEFAULT_MAX_NODE_ATTEMPTS;
    protected boolean transportSecurity;
    protected Duration minNodeReadmitTime = Client.DEFAULT_MIN_NODE_BACKOFF;
    protected Duration maxNodeReadmitTime = Client.DEFAULT_MAX_NODE_BACKOFF;
    protected Instant earliestReadmitTime;
    @Nullable
    private LedgerId ledgerId;
    @VisibleForTesting
    @SuppressFBWarnings(value={"URF_UNREAD_FIELD"}, justification="this field is used for testing")
    boolean hasShutDownNow = false;

    protected BaseNetwork(ExecutorService executor) {
        this.executor = executor;
        this.earliestReadmitTime = Instant.now().plus(this.minNodeReadmitTime);
    }

    @Nullable
    synchronized LedgerId getLedgerId() {
        return this.ledgerId;
    }

    synchronized BaseNetworkT setLedgerId(@Nullable LedgerId ledgerId) {
        this.ledgerId = ledgerId;
        return (BaseNetworkT)this;
    }

    synchronized int getMaxNodeAttempts() {
        return this.maxNodeAttempts;
    }

    synchronized BaseNetworkT setMaxNodeAttempts(int maxNodeAttempts) {
        this.maxNodeAttempts = maxNodeAttempts;
        return (BaseNetworkT)this;
    }

    synchronized Duration getMinNodeBackoff() {
        return this.minNodeBackoff;
    }

    synchronized BaseNetworkT setMinNodeBackoff(Duration minNodeBackoff) {
        this.minNodeBackoff = minNodeBackoff;
        for (BaseNode node : this.nodes) {
            node.setMinBackoff(minNodeBackoff);
        }
        return (BaseNetworkT)this;
    }

    synchronized Duration getMaxNodeBackoff() {
        return this.maxNodeBackoff;
    }

    synchronized BaseNetworkT setMaxNodeBackoff(Duration maxNodeBackoff) {
        this.maxNodeBackoff = maxNodeBackoff;
        for (BaseNode node : this.nodes) {
            node.setMaxBackoff(maxNodeBackoff);
        }
        return (BaseNetworkT)this;
    }

    public synchronized Duration getMinNodeReadmitTime() {
        return this.minNodeReadmitTime;
    }

    public synchronized void setMinNodeReadmitTime(Duration minNodeReadmitTime) {
        this.minNodeReadmitTime = minNodeReadmitTime;
        for (BaseNode node : this.nodes) {
            node.readmitTime = Instant.now();
        }
    }

    public Duration getMaxNodeReadmitTime() {
        return this.maxNodeReadmitTime;
    }

    public void setMaxNodeReadmitTime(Duration maxNodeReadmitTime) {
        this.maxNodeReadmitTime = maxNodeReadmitTime;
    }

    boolean isTransportSecurity() {
        return this.transportSecurity;
    }

    synchronized Duration getCloseTimeout() {
        return this.closeTimeout;
    }

    synchronized BaseNetworkT setCloseTimeout(Duration closeTimeout) {
        this.closeTimeout = closeTimeout;
        return (BaseNetworkT)this;
    }

    protected abstract BaseNodeT createNodeFromNetworkEntry(Map.Entry<String, KeyT> var1);

    protected List<Integer> getNodesToRemove(Map<String, KeyT> network) {
        ArrayList<Integer> nodes = new ArrayList<Integer>(this.nodes.size());
        for (int i = this.nodes.size() - 1; i >= 0; --i) {
            BaseNode node = (BaseNode)this.nodes.get(i);
            if (this.nodeIsInGivenNetwork(node, network)) continue;
            nodes.add(i);
        }
        return nodes;
    }

    private boolean nodeIsInGivenNetwork(BaseNodeT node, Map<String, KeyT> network) {
        for (Map.Entry<String, KeyT> entry : network.entrySet()) {
            if (!((BaseNode)node).getKey().equals(entry.getValue()) || !((BaseNode)node).address.equals(BaseNodeAddress.fromString(entry.getKey()))) continue;
            return true;
        }
        return false;
    }

    synchronized BaseNetworkT setNetwork(Map<String, KeyT> network) throws TimeoutException, InterruptedException {
        ArrayList<BaseNodeT> newNodes = new ArrayList<BaseNodeT>();
        ArrayList<BaseNodeT> newHealthyNodes = new ArrayList<BaseNodeT>();
        HashMap<KeyT, List<BaseNodeT>> newNetwork = new HashMap<KeyT, List<BaseNodeT>>();
        HashSet newNodeKeys = new HashSet();
        HashSet<String> newNodeAddresses = new HashSet<String>();
        for (Integer n : this.getNodesToRemove(network)) {
            long stopAt = Instant.now().getEpochSecond() + this.closeTimeout.getSeconds();
            long remainingTime = stopAt - Instant.now().getEpochSecond();
            BaseNode node = (BaseNode)this.nodes.get(n);
            if (remainingTime <= 0L) {
                throw new TimeoutException("Failed to properly shutdown all channels");
            }
            this.removeNodeFromNetwork(node);
            node.close(Duration.ofSeconds(remainingTime));
            this.nodes.remove(n);
        }
        for (BaseNode baseNode : this.nodes) {
            newNodes.add(baseNode);
            newNodeKeys.add(baseNode.getKey());
            newNodeAddresses.add(baseNode.address.toString());
        }
        for (Map.Entry entry : network.entrySet()) {
            BaseNodeT node = this.createNodeFromNetworkEntry(entry);
            if (newNodeKeys.contains(((BaseNode)node).getKey()) && newNodeAddresses.contains(((BaseNode)node).getAddress().toString())) continue;
            newNodes.add(node);
        }
        for (BaseNode baseNode : newNodes) {
            if (newNetwork.containsKey(baseNode.getKey())) {
                newNetwork.get(baseNode.getKey()).add(baseNode);
            } else {
                ArrayList<BaseNode> list = new ArrayList<BaseNode>();
                list.add(baseNode);
                newNetwork.put(baseNode.getKey(), list);
            }
            newHealthyNodes.add(baseNode);
        }
        this.nodes = newNodes;
        this.network = newNetwork;
        this.healthyNodes = newHealthyNodes;
        return (BaseNetworkT)this;
    }

    synchronized void increaseBackoff(BaseNodeT node) {
        ((BaseNode)node).increaseBackoff();
        this.healthyNodes.remove(node);
    }

    synchronized void decreaseBackoff(BaseNodeT node) {
        ((BaseNode)node).decreaseBackoff();
    }

    private void removeNodeFromNetwork(BaseNodeT node) {
        List<BaseNodeT> nodesForKey = this.network.get(((BaseNode)node).getKey());
        nodesForKey.remove(node);
        if (nodesForKey.isEmpty()) {
            this.network.remove(((BaseNode)node).getKey());
        }
    }

    private boolean addressIsInNodeList(String addressString, List<BaseNodeT> nodes) {
        BaseNodeAddress address = BaseNodeAddress.fromString(addressString);
        for (BaseNode node : nodes) {
            if (!node.address.equals(address)) continue;
            return true;
        }
        return false;
    }

    protected void removeDeadNodes() throws InterruptedException {
        if (this.maxNodeAttempts > 0) {
            for (int i = this.nodes.size() - 1; i >= 0; --i) {
                BaseNode node = Objects.requireNonNull((BaseNode)this.nodes.get(i));
                if (node.getBadGrpcStatusCount() < (long)this.maxNodeAttempts) continue;
                node.close(this.closeTimeout);
                this.removeNodeFromNetwork(node);
                this.nodes.remove(i);
            }
        }
    }

    synchronized void readmitNodes() {
        Instant now = Instant.now();
        if (now.toEpochMilli() > this.earliestReadmitTime.toEpochMilli()) {
            Instant nextEarliestReadmitTime = now.plus(this.maxNodeReadmitTime);
            for (BaseNode node : this.nodes) {
                if (!node.readmitTime.isAfter(now) || !node.readmitTime.isBefore(nextEarliestReadmitTime)) continue;
                nextEarliestReadmitTime = node.readmitTime;
            }
            this.earliestReadmitTime = nextEarliestReadmitTime;
            if (this.earliestReadmitTime.isBefore(now.plus(this.minNodeReadmitTime))) {
                this.earliestReadmitTime = now.plus(this.minNodeReadmitTime);
            }
            block1: for (int i = 0; i < this.nodes.size(); ++i) {
                for (int j = 0; j < this.healthyNodes.size(); ++j) {
                    if (this.nodes.get(i) == this.healthyNodes.get(j)) continue block1;
                }
                if (!((BaseNode)this.nodes.get((int)i)).readmitTime.isBefore(now)) continue;
                this.healthyNodes.add((BaseNode)this.nodes.get(i));
            }
        }
    }

    synchronized BaseNodeT getNode(@Nullable KeyT key) {
        this.readmitNodes();
        if (key == null) {
            if (this.healthyNodes.isEmpty()) {
                throw new IllegalStateException("No healthy node was found");
            }
            return (BaseNodeT)((BaseNode)this.healthyNodes.get(random.nextInt(this.healthyNodes.size())));
        }
        List<BaseNodeT> list = this.network.get(key);
        return (BaseNodeT)((BaseNode)list.get(random.nextInt(list.size())));
    }

    protected synchronized List<BaseNodeT> getNumberOfMostHealthyNodes(int count) throws InterruptedException {
        this.readmitNodes();
        this.removeDeadNodes();
        HashMap returnNodes = new HashMap(count);
        for (int i = 0; i < count; ++i) {
            BaseNodeT node = this.getNode(null);
            if (returnNodes.containsKey(((BaseNode)node).getKey())) continue;
            returnNodes.put(((BaseNode)node).getKey(), node);
        }
        ArrayList returnList = new ArrayList();
        returnList.addAll(returnNodes.values());
        return returnList;
    }

    synchronized void beginClose() {
        for (BaseNode node : this.nodes) {
            if (node.channel == null) continue;
            node.channel = node.channel.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    synchronized Throwable awaitClose(Instant deadline, @Nullable Throwable previousError) {
        try {
            if (previousError != null) {
                throw previousError;
            }
            for (BaseNode node : this.nodes) {
                if (node.channel == null) continue;
                long timeoutMillis = Duration.between(Instant.now(), deadline).toMillis();
                if (timeoutMillis <= 0L || !node.channel.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS)) {
                    throw new TimeoutException("Failed to properly shutdown all channels");
                }
                node.channel = null;
            }
            Iterator<BaseNodeT> iterator = null;
            return iterator;
        }
        catch (Throwable error) {
            for (BaseNode node : this.nodes) {
                if (node.channel == null) continue;
                node.channel.shutdownNow();
            }
            this.hasShutDownNow = true;
            Throwable throwable = error;
            return throwable;
        }
        finally {
            this.nodes.clear();
            this.network.clear();
        }
    }
}

