/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

class BaseNodeAddress {
    private static final Pattern HOST_AND_PORT = Pattern.compile("^(\\S+):(\\d+)$");
    private static final Pattern IN_PROCESS = Pattern.compile("^in-process:(\\S+)$");
    static final int PORT_MIRROR_TLS = 443;
    static final int PORT_NODE_PLAIN = 50211;
    static final int PORT_NODE_TLS = 50212;
    @Nullable
    private final String name;
    @Nullable
    private final String address;
    private final int port;

    public BaseNodeAddress(@Nullable String name, @Nullable String address, int port) {
        this.name = name;
        this.address = address;
        this.port = port;
    }

    public static BaseNodeAddress fromString(String string) {
        Matcher hostAndPortMatcher = HOST_AND_PORT.matcher(string);
        Matcher inProcessMatcher = IN_PROCESS.matcher(string);
        if (hostAndPortMatcher.matches() && hostAndPortMatcher.groupCount() == 2) {
            String address = hostAndPortMatcher.group(1);
            String port = hostAndPortMatcher.group(2);
            return new BaseNodeAddress(null, address, Integer.parseInt(port));
        }
        if (inProcessMatcher.matches() && inProcessMatcher.groupCount() == 1) {
            return new BaseNodeAddress(inProcessMatcher.group(1), null, 0);
        }
        throw new IllegalStateException("failed to parse node address");
    }

    public String getName() {
        return this.name;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isInProcess() {
        return this.name != null;
    }

    public boolean isTransportSecurity() {
        return this.port == 50212 || this.port == 443;
    }

    public BaseNodeAddress toInsecure() {
        int newPort = this.port == 50212 ? 50211 : this.port;
        return new BaseNodeAddress(this.name, this.address, newPort);
    }

    public BaseNodeAddress toSecure() {
        int newPort = this.port == 50211 ? 50212 : this.port;
        return new BaseNodeAddress(this.name, this.address, newPort);
    }

    public String toString() {
        if (this.name != null) {
            return this.name;
        }
        return this.address + ":" + this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseNodeAddress that = (BaseNodeAddress)o;
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.getAddress(), that.getAddress()) && this.port == that.port;
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getAddress(), this.getPort());
    }
}

