/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.BoolValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ContractUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ContractUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<ContractUpdateTransaction> {
    @Nullable
    private ContractId contractId = null;
    @Nullable
    private AccountId proxyAccountId = null;
    @Nullable
    private FileId bytecodeFileId = null;
    @Nullable
    private Instant expirationTime = null;
    @Nullable
    private Key adminKey = null;
    @Nullable
    private Integer maxAutomaticTokenAssociations = null;
    @Nullable
    private Duration autoRenewPeriod = null;
    @Nullable
    private String contractMemo = null;
    @Nullable
    private AccountId stakedAccountId = null;
    @Nullable
    private Long stakedNodeId = null;
    @Nullable
    private Boolean declineStakingReward = null;
    @Nullable
    private AccountId autoRenewAccountId = null;

    public ContractUpdateTransaction() {
    }

    ContractUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    ContractUpdateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public ContractId getContractId() {
        return this.contractId;
    }

    public ContractUpdateTransaction setContractId(ContractId contractId) {
        Objects.requireNonNull(contractId);
        this.requireNotFrozen();
        this.contractId = contractId;
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="An instant can't actually be mutated")
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="An Instant can't actually be mutated")
    public ContractUpdateTransaction setExpirationTime(Instant expirationTime) {
        Objects.requireNonNull(expirationTime);
        this.requireNotFrozen();
        this.expirationTime = expirationTime;
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public ContractUpdateTransaction setAdminKey(Key adminKey) {
        Objects.requireNonNull(adminKey);
        this.requireNotFrozen();
        this.adminKey = adminKey;
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.proxyAccountId;
    }

    public ContractUpdateTransaction setProxyAccountId(AccountId proxyAccountId) {
        Objects.requireNonNull(proxyAccountId);
        this.requireNotFrozen();
        this.proxyAccountId = proxyAccountId;
        return this;
    }

    @Nullable
    public Integer getMaxAutomaticTokenAssociations() {
        return this.maxAutomaticTokenAssociations;
    }

    public ContractUpdateTransaction setMaxAutomaticTokenAssociations(int maxAutomaticTokenAssociations) {
        this.requireNotFrozen();
        this.maxAutomaticTokenAssociations = maxAutomaticTokenAssociations;
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="A Duration can't actually be mutated")
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="A Duration can't actually be mutated")
    public ContractUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        Objects.requireNonNull(autoRenewPeriod);
        this.requireNotFrozen();
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    @Nullable
    @Deprecated
    public FileId getBytecodeFileId() {
        return this.bytecodeFileId;
    }

    @Deprecated
    public ContractUpdateTransaction setBytecodeFileId(FileId bytecodeFileId) {
        Objects.requireNonNull(bytecodeFileId);
        this.requireNotFrozen();
        this.bytecodeFileId = bytecodeFileId;
        return this;
    }

    @Nullable
    public String getContractMemo() {
        return this.contractMemo;
    }

    public ContractUpdateTransaction setContractMemo(String memo) {
        Objects.requireNonNull(memo);
        this.requireNotFrozen();
        this.contractMemo = memo;
        return this;
    }

    public ContractUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.contractMemo = "";
        return this;
    }

    @Nullable
    public AccountId getStakedAccountId() {
        return this.stakedAccountId;
    }

    public ContractUpdateTransaction setStakedAccountId(@Nullable AccountId stakedAccountId) {
        this.requireNotFrozen();
        this.stakedAccountId = stakedAccountId;
        this.stakedNodeId = null;
        return this;
    }

    public ContractUpdateTransaction clearStakedAccountId() {
        this.requireNotFrozen();
        this.stakedAccountId = new AccountId(0L);
        this.stakedNodeId = null;
        return this;
    }

    @Nullable
    public Long getStakedNodeId() {
        return this.stakedNodeId;
    }

    public ContractUpdateTransaction setStakedNodeId(@Nullable Long stakedNodeId) {
        this.requireNotFrozen();
        this.stakedNodeId = stakedNodeId;
        this.stakedAccountId = null;
        return this;
    }

    public ContractUpdateTransaction clearStakedNodeId() {
        this.requireNotFrozen();
        this.stakedNodeId = -1L;
        this.stakedAccountId = null;
        return this;
    }

    @Nullable
    public Boolean getDeclineStakingReward() {
        return this.declineStakingReward;
    }

    public ContractUpdateTransaction setDeclineStakingReward(boolean declineStakingReward) {
        this.requireNotFrozen();
        this.declineStakingReward = declineStakingReward;
        return this;
    }

    public ContractUpdateTransaction clearDeclineStakingReward() {
        this.requireNotFrozen();
        this.declineStakingReward = null;
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public ContractUpdateTransaction setAutoRenewAccountId(AccountId autoRenewAccountId) {
        Objects.requireNonNull(autoRenewAccountId);
        this.requireNotFrozen();
        this.autoRenewAccountId = autoRenewAccountId;
        return this;
    }

    public ContractUpdateTransaction clearAutoRenewAccountId() {
        this.autoRenewAccountId = new AccountId(0L);
        return this;
    }

    void initFromTransactionBody() {
        ContractUpdateTransactionBody body = this.sourceTransactionBody.getContractUpdateInstance();
        if (body.hasContractID()) {
            this.contractId = ContractId.fromProtobuf(body.getContractID());
        }
        if (body.hasProxyAccountID()) {
            this.proxyAccountId = AccountId.fromProtobuf(body.getProxyAccountID());
        }
        if (body.hasExpirationTime()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpirationTime());
        }
        if (body.hasAdminKey()) {
            this.adminKey = Key.fromProtobufKey(body.getAdminKey());
        }
        if (body.hasMaxAutomaticTokenAssociations()) {
            this.maxAutomaticTokenAssociations = body.getMaxAutomaticTokenAssociations().getValue();
        }
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        if (body.hasMemoWrapper()) {
            this.contractMemo = body.getMemoWrapper().getValue();
        }
        if (body.hasDeclineReward()) {
            this.declineStakingReward = body.getDeclineReward().getValue();
        }
        if (body.hasStakedAccountId()) {
            this.stakedAccountId = AccountId.fromProtobuf(body.getStakedAccountId());
        }
        if (body.hasStakedNodeId()) {
            this.stakedNodeId = body.getStakedNodeId();
        }
        if (body.hasAutoRenewAccountId()) {
            this.autoRenewAccountId = AccountId.fromProtobuf(body.getAutoRenewAccountId());
        }
    }

    ContractUpdateTransactionBody.Builder build() {
        ContractUpdateTransactionBody.Builder builder = ContractUpdateTransactionBody.newBuilder();
        if (this.contractId != null) {
            builder.setContractID(this.contractId.toProtobuf());
        }
        if (this.proxyAccountId != null) {
            builder.setProxyAccountID(this.proxyAccountId.toProtobuf());
        }
        if (this.expirationTime != null) {
            builder.setExpirationTime(InstantConverter.toProtobuf(this.expirationTime));
        }
        if (this.adminKey != null) {
            builder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.maxAutomaticTokenAssociations != null) {
            builder.setMaxAutomaticTokenAssociations(Int32Value.of((int)this.maxAutomaticTokenAssociations));
        }
        if (this.autoRenewPeriod != null) {
            builder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        if (this.contractMemo != null) {
            builder.setMemoWrapper(StringValue.of((String)this.contractMemo));
        }
        if (this.stakedAccountId != null) {
            builder.setStakedAccountId(this.stakedAccountId.toProtobuf());
        }
        if (this.stakedNodeId != null) {
            builder.setStakedNodeId(this.stakedNodeId);
        }
        if (this.declineStakingReward != null) {
            builder.setDeclineReward((BoolValue)BoolValue.newBuilder().setValue(this.declineStakingReward.booleanValue()).build());
        }
        if (this.autoRenewAccountId != null) {
            builder.setAutoRenewAccountId(this.autoRenewAccountId.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.contractId != null) {
            this.contractId.validateChecksum(client);
        }
        if (this.proxyAccountId != null) {
            this.proxyAccountId.validateChecksum(client);
        }
        if (this.stakedAccountId != null) {
            this.stakedAccountId.validateChecksum(client);
        }
        if (this.autoRenewAccountId != null) {
            this.autoRenewAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getUpdateContractMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setContractUpdateInstance(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setContractUpdateInstance(this.build());
    }
}

