/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.hedera.hashgraph.sdk.Key;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class EvmAddress
extends Key {
    private final byte[] bytes;

    public EvmAddress(byte[] bytes) {
        this.bytes = Arrays.copyOf(bytes, bytes.length);
    }

    public static EvmAddress fromString(String text) {
        String address = text.startsWith("0x") ? text.substring(2) : text;
        return new EvmAddress(Hex.decode((String)address));
    }

    @Nullable
    static EvmAddress fromAliasBytes(ByteString aliasBytes) {
        if (!aliasBytes.isEmpty() && aliasBytes.size() == 20) {
            return new EvmAddress(aliasBytes.toByteArray());
        }
        return null;
    }

    public static EvmAddress fromBytes(byte[] bytes) {
        return new EvmAddress(bytes);
    }

    @Override
    com.hedera.hashgraph.sdk.proto.Key toProtobufKey() {
        throw new UnsupportedOperationException("toProtobufKey() not implemented for EvmAddress");
    }

    @Override
    public byte[] toBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public String toString() {
        return Hex.toHexString((byte[])this.bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EvmAddress)) {
            return false;
        }
        EvmAddress other = (EvmAddress)o;
        return Arrays.equals(this.bytes, other.bytes);
    }
}

