/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.MessageLite;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ConsumerHelper;
import com.hedera.hashgraph.sdk.Delayer;
import com.hedera.hashgraph.sdk.ExecutionState;
import com.hedera.hashgraph.sdk.LockableList;
import com.hedera.hashgraph.sdk.MaxAttemptsExceededException;
import com.hedera.hashgraph.sdk.Network;
import com.hedera.hashgraph.sdk.Node;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionId;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.javacrumbs.futureconverter.common.internal.ValueSource;
import net.javacrumbs.futureconverter.guavacommon.GuavaFutureUtils;
import net.javacrumbs.futureconverter.java8common.Java8FutureUtils;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Executable<SdkRequestT, ProtoRequestT extends MessageLite, ResponseT extends MessageLite, O> {
    static final Pattern RST_STREAM = Pattern.compile(".*\\brst[^0-9a-zA-Z]stream\\b.*", 34);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    protected Integer maxAttempts = null;
    @Nullable
    protected Duration maxBackoff = null;
    @Nullable
    protected Duration minBackoff = null;
    protected LockableList<AccountId> nodeAccountIds = new LockableList();
    protected List<Node> nodes = new ArrayList<Node>();
    protected boolean attemptedAllNodes = false;
    @VisibleForTesting
    Function<GrpcRequest, ResponseT> blockingUnaryCall = grpcRequest -> (MessageLite)ClientCalls.blockingUnaryCall(grpcRequest.createCall(), grpcRequest.getRequest());
    protected Duration grpcDeadline;
    private Function<ProtoRequestT, ProtoRequestT> requestListener = request -> {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Sent protobuf {}", (Object)Hex.toHexString((byte[])request.toByteArray()));
        }
        return request;
    };
    private Function<ResponseT, ResponseT> responseListener = response -> {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Received protobuf {}", (Object)Hex.toHexString((byte[])response.toByteArray()));
        }
        return response;
    };

    Executable() {
    }

    public final Duration grpcDeadline() {
        return this.grpcDeadline;
    }

    public final SdkRequestT setGrpcDeadline(Duration grpcDeadline) {
        this.grpcDeadline = Objects.requireNonNull(grpcDeadline);
        return (SdkRequestT)this;
    }

    public final Duration getMaxBackoff() {
        return this.maxBackoff != null ? this.maxBackoff : Client.DEFAULT_MAX_BACKOFF;
    }

    public final SdkRequestT setMaxBackoff(Duration maxBackoff) {
        if (maxBackoff == null || maxBackoff.toNanos() < 0L) {
            throw new IllegalArgumentException("maxBackoff must be a positive duration");
        }
        if (maxBackoff.compareTo(this.getMinBackoff()) < 0) {
            throw new IllegalArgumentException("maxBackoff must be greater than or equal to minBackoff");
        }
        this.maxBackoff = maxBackoff;
        return (SdkRequestT)this;
    }

    public final Duration getMinBackoff() {
        return this.minBackoff != null ? this.minBackoff : Client.DEFAULT_MIN_BACKOFF;
    }

    public final SdkRequestT setMinBackoff(Duration minBackoff) {
        if (minBackoff == null || minBackoff.toNanos() < 0L) {
            throw new IllegalArgumentException("minBackoff must be a positive duration");
        }
        if (minBackoff.compareTo(this.getMaxBackoff()) > 0) {
            throw new IllegalArgumentException("minBackoff must be less than or equal to maxBackoff");
        }
        this.minBackoff = minBackoff;
        return (SdkRequestT)this;
    }

    @Deprecated
    public final int getMaxRetry() {
        return this.getMaxAttempts();
    }

    @Deprecated
    public final SdkRequestT setMaxRetry(int count) {
        return this.setMaxAttempts(count);
    }

    public final int getMaxAttempts() {
        return this.maxAttempts != null ? this.maxAttempts : 10;
    }

    public final SdkRequestT setMaxAttempts(int maxAttempts) {
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("maxAttempts must be greater than zero");
        }
        this.maxAttempts = maxAttempts;
        return (SdkRequestT)this;
    }

    @Nullable
    public final List<AccountId> getNodeAccountIds() {
        if (!this.nodeAccountIds.isEmpty()) {
            return new ArrayList<AccountId>(this.nodeAccountIds.getList());
        }
        return null;
    }

    public SdkRequestT setNodeAccountIds(List<AccountId> nodeAccountIds) {
        this.nodeAccountIds.setList(nodeAccountIds).setLocked(true);
        return (SdkRequestT)this;
    }

    public final SdkRequestT setRequestListener(Function<ProtoRequestT, ProtoRequestT> requestListener) {
        this.requestListener = Objects.requireNonNull(requestListener);
        return (SdkRequestT)this;
    }

    public final SdkRequestT setResponseListener(Function<ResponseT, ResponseT> responseListener) {
        this.responseListener = Objects.requireNonNull(responseListener);
        return (SdkRequestT)this;
    }

    void checkNodeAccountIds() {
        if (this.nodeAccountIds.isEmpty()) {
            throw new IllegalStateException("Request node account IDs were not set before executing");
        }
    }

    abstract void onExecute(Client var1) throws TimeoutException, PrecheckStatusException;

    abstract CompletableFuture<Void> onExecuteAsync(Client var1);

    void mergeFromClient(Client client) {
        if (this.maxAttempts == null) {
            this.maxAttempts = client.getMaxAttempts();
        }
        if (this.maxBackoff == null) {
            this.maxBackoff = client.getMaxBackoff();
        }
        if (this.minBackoff == null) {
            this.minBackoff = client.getMinBackoff();
        }
        if (this.grpcDeadline == null) {
            this.grpcDeadline = client.getGrpcDeadline();
        }
    }

    private void delay(long delay) {
        if (delay <= 0L) {
            return;
        }
        try {
            if (delay > 0L) {
                Thread.sleep(delay);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public O execute(Client client) throws TimeoutException, PrecheckStatusException {
        return this.execute(client, client.getRequestTimeout());
    }

    public O execute(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException {
        Throwable lastException = null;
        this.mergeFromClient(client);
        this.onExecute(client);
        this.checkNodeAccountIds();
        this.setNodesFromNodeAccountIds(client);
        Instant timeoutTime = Instant.now().plus(timeout);
        int attempt = 1;
        while (true) {
            if (attempt > this.maxAttempts) {
                throw new MaxAttemptsExceededException(lastException);
            }
            Duration currentTimeout = Duration.between(Instant.now(), timeoutTime);
            if (currentTimeout.isNegative() || currentTimeout.isZero()) {
                throw new TimeoutException();
            }
            GrpcRequest grpcRequest = new GrpcRequest(client.network, attempt, currentTimeout);
            Node node = grpcRequest.getNode();
            MessageLite response = null;
            if (!node.isHealthy()) {
                this.delay(node.getRemainingTimeForBackoff());
            }
            if (node.channelFailedToConnect()) {
                this.logger.trace("Failed to connect channel for node {} for request #{}", (Object)node.getAccountId(), (Object)attempt);
                lastException = grpcRequest.reactToConnectionFailure();
            } else {
                try {
                    response = (MessageLite)this.blockingUnaryCall.apply(grpcRequest);
                    this.logTransaction(this.getTransactionIdInternal(), client, node, false, attempt, response, null);
                }
                catch (Throwable e) {
                    lastException = e;
                    this.logTransaction(this.getTransactionIdInternal(), client, node, false, attempt, null, e);
                }
                if (response == null) {
                    if (!grpcRequest.shouldRetryExceptionally(lastException)) {
                        throw new RuntimeException(lastException);
                    }
                } else {
                    Status status = this.mapResponseStatus(response);
                    ExecutionState executionState = this.getExecutionState(status, response);
                    grpcRequest.handleResponse(response, status, executionState);
                    switch (executionState) {
                        case SERVER_ERROR: {
                            lastException = grpcRequest.mapStatusException();
                            break;
                        }
                        case RETRY: {
                            lastException = grpcRequest.mapStatusException();
                            if (attempt >= this.maxAttempts) break;
                            this.delay(grpcRequest.getDelay());
                            break;
                        }
                        case REQUEST_ERROR: {
                            throw grpcRequest.mapStatusException();
                        }
                        default: {
                            return grpcRequest.mapResponse();
                        }
                    }
                }
            }
            ++attempt;
        }
    }

    public CompletableFuture<O> executeAsync(Client client) {
        return this.executeAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<O> executeAsync(Client client, Duration timeout) {
        CompletableFuture retval = new CompletableFuture().orTimeout(timeout.toMillis(), TimeUnit.MILLISECONDS);
        this.mergeFromClient(client);
        ((CompletableFuture)this.onExecuteAsync(client).thenRun(() -> {
            this.checkNodeAccountIds();
            this.setNodesFromNodeAccountIds(client);
            this.executeAsyncInternal(client, 1, null, retval, timeout);
        })).exceptionally(error -> {
            retval.completeExceptionally((Throwable)error);
            return null;
        });
        return retval;
    }

    public void executeAsync(Client client, BiConsumer<O, Throwable> callback) {
        ConsumerHelper.biConsumer(this.executeAsync(client), callback);
    }

    public void executeAsync(Client client, Duration timeout, BiConsumer<O, Throwable> callback) {
        ConsumerHelper.biConsumer(this.executeAsync(client, timeout), callback);
    }

    public void executeAsync(Client client, Consumer<O> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.executeAsync(client), onSuccess, onFailure);
    }

    public void executeAsync(Client client, Duration timeout, Consumer<O> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.executeAsync(client, timeout), onSuccess, onFailure);
    }

    protected void logTransaction(TransactionId transactionId, Client client, Node node, boolean isAsync, int attempt, @Nullable ResponseT response, @Nullable Throwable error) {
        if (!this.logger.isTraceEnabled()) {
            return;
        }
        this.logger.trace("Execute{} Transaction ID: {}, submit to {}, node: {}, attempt: {}", new Object[]{isAsync ? "Async" : "", transactionId, client.network, node.getAccountId(), attempt});
        if (response != null) {
            this.logger.trace(" - Response: {}", response);
        }
        if (error != null) {
            this.logger.trace(" - Error: {}", (Object)error.getMessage());
        }
    }

    @VisibleForTesting
    void setNodesFromNodeAccountIds(Client client) {
        this.nodes.clear();
        for (AccountId accountId : this.nodeAccountIds) {
            Node node = (Node)client.network.getNode(accountId);
            if (node == null) {
                throw new IllegalStateException("Some node account IDs did not map to valid nodes in the client's network");
            }
            this.nodes.add(Objects.requireNonNull(node));
        }
    }

    @VisibleForTesting
    Node getNodeForExecute(int attempt) {
        Node node = null;
        Node candidate = null;
        long smallestDelay = Long.MAX_VALUE;
        for (int _i = 0; _i < this.nodes.size() && !(node = this.nodes.get(this.nodeAccountIds.getIndex())).isHealthy(); ++_i) {
            long backoff = node.getRemainingTimeForBackoff();
            if (backoff < smallestDelay) {
                candidate = node;
                smallestDelay = backoff;
            }
            node = null;
            this.advanceRequest();
        }
        if (node == null) {
            node = candidate;
            this.nodeAccountIds.setIndex(Math.max(0, this.nodeAccountIds.getIndex()));
        }
        if (node != null) {
            this.logger.trace("Using node {} for request #{}: {}", new Object[]{node.getAccountId(), attempt, this});
        }
        return node;
    }

    private ProtoRequestT getRequestForExecute() {
        ProtoRequestT request = this.makeRequest();
        this.advanceRequest();
        return request;
    }

    private void executeAsyncInternal(Client client, int attempt, @Nullable Throwable lastException, CompletableFuture<O> returnFuture, Duration timeout) {
        if (returnFuture.isCancelled() || returnFuture.isCompletedExceptionally() || returnFuture.isDone()) {
            return;
        }
        if (attempt > this.maxAttempts) {
            returnFuture.completeExceptionally(new CompletionException(new MaxAttemptsExceededException(lastException)));
            return;
        }
        Instant timeoutTime = Instant.now().plus(timeout);
        GrpcRequest grpcRequest = new GrpcRequest(client.network, attempt, Duration.between(Instant.now(), timeoutTime));
        Supplier<CompletableFuture> afterUnhealthyDelay = () -> grpcRequest.getNode().isHealthy() ? CompletableFuture.completedFuture(null) : Delayer.delayFor(grpcRequest.getNode().getRemainingTimeForBackoff(), client.executor);
        afterUnhealthyDelay.get().thenRun(() -> ((CompletableFuture)grpcRequest.getNode().channelFailedToConnectAsync().thenAccept(connectionFailed -> {
            if (connectionFailed.booleanValue()) {
                Throwable connectionException = grpcRequest.reactToConnectionFailure();
                this.executeAsyncInternal(client, attempt + 1, connectionException, returnFuture, Duration.between(Instant.now(), timeoutTime));
                return;
            }
            ((CompletableFuture)Java8FutureUtils.createCompletableFuture((ValueSource)GuavaFutureUtils.createValueSource((ListenableFuture)ClientCalls.futureUnaryCall(grpcRequest.createCall(), grpcRequest.getRequest()))).handle((response, error) -> {
                this.logTransaction(this.getTransactionIdInternal(), client, grpcRequest.getNode(), true, attempt, (ResponseT)response, (Throwable)error);
                if (grpcRequest.shouldRetryExceptionally((Throwable)error)) {
                    this.executeAsyncInternal(client, attempt + 1, (Throwable)error, returnFuture, Duration.between(Instant.now(), timeoutTime));
                    return null;
                }
                if (error != null) {
                    returnFuture.completeExceptionally(new CompletionException((Throwable)error));
                    return null;
                }
                Status status = this.mapResponseStatus(response);
                ExecutionState executionState = this.getExecutionState(status, response);
                grpcRequest.handleResponse(response, status, executionState);
                switch (executionState) {
                    case SERVER_ERROR: {
                        this.executeAsyncInternal(client, attempt + 1, grpcRequest.mapStatusException(), returnFuture, Duration.between(Instant.now(), timeoutTime));
                        break;
                    }
                    case RETRY: {
                        Delayer.delayFor(attempt < this.maxAttempts ? grpcRequest.getDelay() : 0L, client.executor).thenRun(() -> this.executeAsyncInternal(client, attempt + 1, grpcRequest.mapStatusException(), returnFuture, Duration.between(Instant.now(), timeoutTime)));
                        break;
                    }
                    case REQUEST_ERROR: {
                        returnFuture.completeExceptionally(new CompletionException(grpcRequest.mapStatusException()));
                        break;
                    }
                    default: {
                        returnFuture.complete(grpcRequest.mapResponse());
                    }
                }
                return null;
            })).exceptionally(error -> {
                returnFuture.completeExceptionally((Throwable)error);
                return null;
            });
        })).exceptionally(error -> {
            returnFuture.completeExceptionally((Throwable)error);
            return null;
        }));
    }

    abstract ProtoRequestT makeRequest();

    GrpcRequest getGrpcRequest(int attempt) {
        return new GrpcRequest(null, attempt, this.grpcDeadline);
    }

    void advanceRequest() {
        if (this.nodeAccountIds.getIndex() + 1 == this.nodes.size() - 1) {
            this.attemptedAllNodes = true;
        }
        this.nodeAccountIds.advance();
    }

    abstract O mapResponse(ResponseT var1, AccountId var2, ProtoRequestT var3);

    abstract Status mapResponseStatus(ResponseT var1);

    abstract MethodDescriptor<ProtoRequestT, ResponseT> getMethodDescriptor();

    @Nullable
    abstract TransactionId getTransactionIdInternal();

    boolean shouldRetryExceptionally(@Nullable Throwable error) {
        if (error instanceof StatusRuntimeException) {
            StatusRuntimeException statusException = (StatusRuntimeException)error;
            Status.Code status = statusException.getStatus().getCode();
            String description = statusException.getStatus().getDescription();
            return status == Status.Code.UNAVAILABLE || status == Status.Code.RESOURCE_EXHAUSTED || status == Status.Code.INTERNAL && description != null && RST_STREAM.matcher(description).matches();
        }
        return false;
    }

    ExecutionState getExecutionState(Status status, ResponseT response) {
        switch (status) {
            case PLATFORM_TRANSACTION_NOT_CREATED: 
            case PLATFORM_NOT_ACTIVE: 
            case BUSY: {
                return ExecutionState.SERVER_ERROR;
            }
            case OK: {
                return ExecutionState.SUCCESS;
            }
        }
        return ExecutionState.REQUEST_ERROR;
    }

    @VisibleForTesting
    class GrpcRequest {
        @Nullable
        private final Network network;
        private final Node node;
        private final int attempt;
        private final ProtoRequestT request;
        private final long startAt;
        private final long delay;
        private Duration grpcDeadline;
        private ResponseT response;
        private double latency;
        private Status responseStatus;

        GrpcRequest(Network network, int attempt, Duration grpcDeadline) {
            this.network = network;
            this.attempt = attempt;
            this.grpcDeadline = grpcDeadline;
            this.node = Executable.this.getNodeForExecute(attempt);
            this.request = Executable.this.getRequestForExecute();
            this.startAt = System.nanoTime();
            this.delay = (long)Math.min((double)Objects.requireNonNull(Executable.this.minBackoff).toMillis() * Math.pow(2.0, attempt - 1), (double)Objects.requireNonNull(Executable.this.maxBackoff).toMillis());
        }

        public CallOptions getCallOptions() {
            long deadline = Math.min(this.grpcDeadline.toMillis(), Executable.this.grpcDeadline.toMillis());
            return CallOptions.DEFAULT.withDeadlineAfter(deadline, TimeUnit.MILLISECONDS);
        }

        public Node getNode() {
            return this.node;
        }

        public ClientCall<ProtoRequestT, ResponseT> createCall() {
            this.verboseLog(this.node);
            return this.node.getChannel().newCall(Executable.this.getMethodDescriptor(), this.getCallOptions());
        }

        public ProtoRequestT getRequest() {
            return (MessageLite)Executable.this.requestListener.apply(this.request);
        }

        public long getDelay() {
            return this.delay;
        }

        Throwable reactToConnectionFailure() {
            Objects.requireNonNull(this.network).increaseBackoff(this.node);
            Executable.this.logger.warn("Retrying in {} ms after channel connection failure with node {} during attempt #{}", new Object[]{this.node.getRemainingTimeForBackoff(), this.node.getAccountId(), this.attempt});
            this.verboseLog(this.node);
            return new IllegalStateException("Failed to connect to node " + this.node.getAccountId());
        }

        boolean shouldRetryExceptionally(@Nullable Throwable e) {
            this.latency = (double)(System.nanoTime() - this.startAt) / 1.0E9;
            boolean retry = Executable.this.shouldRetryExceptionally(e);
            if (retry) {
                Objects.requireNonNull(this.network).increaseBackoff(this.node);
                Executable.this.logger.warn("Retrying in {} ms after failure with node {} during attempt #{}: {}", new Object[]{this.node.getRemainingTimeForBackoff(), this.node.getAccountId(), this.attempt, e != null ? e.getMessage() : "NULL"});
                this.verboseLog(this.node);
            }
            return retry;
        }

        PrecheckStatusException mapStatusException() {
            return new PrecheckStatusException(this.responseStatus, Executable.this.getTransactionIdInternal());
        }

        O mapResponse() {
            return Executable.this.mapResponse(this.response, this.node.getAccountId(), this.request);
        }

        void handleResponse(ResponseT response, Status status, ExecutionState executionState) {
            this.node.decreaseBackoff();
            this.response = (MessageLite)Executable.this.responseListener.apply(response);
            this.responseStatus = status;
            Executable.this.logger.trace("Received {} response in {} s from node {} during attempt #{}: {}", new Object[]{this.responseStatus, this.latency, this.node.getAccountId(), this.attempt, response});
            if (executionState == ExecutionState.SERVER_ERROR && Executable.this.attemptedAllNodes) {
                executionState = ExecutionState.RETRY;
                Executable.this.attemptedAllNodes = false;
            }
            switch (executionState) {
                case RETRY: {
                    Executable.this.logger.warn("Retrying in {} ms after failure with node {} during attempt #{}: {}", new Object[]{this.delay, this.node.getAccountId(), this.attempt, this.responseStatus});
                    this.verboseLog(this.node);
                    break;
                }
                case SERVER_ERROR: {
                    Executable.this.logger.warn("Problem submitting request to node {} for attempt #{}, retry with new node: {}", new Object[]{this.node.getAccountId(), this.attempt, this.responseStatus});
                    break;
                }
            }
        }

        void verboseLog(Node node) {
            String ipAddress = node.address == null ? "NULL" : (node.address.getAddress() == null ? "NULL" : node.address.getAddress());
            Executable.this.logger.trace("Node IP {} Timestamp {} Transaction Type {}", new Object[]{ipAddress, System.currentTimeMillis(), this.getClass().getSimpleName()});
        }
    }
}

