/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.Timestamp;
import com.hedera.hashgraph.sdk.proto.TimestampSeconds;
import java.time.Instant;

final class InstantConverter {
    private InstantConverter() {
    }

    static Instant fromProtobuf(Timestamp timestamp) {
        return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
    }

    static Instant fromProtobuf(TimestampSeconds timestampSeconds) {
        return Instant.ofEpochSecond(timestampSeconds.getSeconds());
    }

    static Timestamp toProtobuf(Instant instant) {
        return (Timestamp)Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
    }

    static TimestampSeconds toSecondsProtobuf(Instant instant) {
        return (TimestampSeconds)TimestampSeconds.newBuilder().setSeconds(instant.getEpochSecond()).build();
    }
}

