/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.EvmAddress;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.PublicKeyECDSA;
import com.hedera.hashgraph.sdk.PublicKeyED25519;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.proto.SignaturePair;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.util.encoders.Hex;

public abstract class PublicKey
extends Key {
    public static PublicKey fromBytes(byte[] publicKey) {
        if (publicKey.length == 32) {
            return new PublicKeyED25519(publicKey);
        }
        return PublicKey.fromBytesDER(publicKey);
    }

    public static PublicKey fromBytesDER(byte[] publicKey) {
        return PublicKey.fromSubjectKeyInfo(SubjectPublicKeyInfo.getInstance((Object)publicKey));
    }

    public static PublicKey fromBytesED25519(byte[] publicKey) {
        return PublicKeyED25519.fromBytesInternal(publicKey);
    }

    public static PublicKey fromBytesECDSA(byte[] publicKey) {
        return PublicKeyECDSA.fromBytesInternal(publicKey);
    }

    public static PublicKey fromString(String publicKey) {
        return PublicKey.fromBytes(Hex.decode((String)publicKey));
    }

    public static PublicKey fromStringED25519(String publicKey) {
        return PublicKey.fromBytesED25519(Hex.decode((String)publicKey));
    }

    public static PublicKey fromStringECDSA(String publicKey) {
        return PublicKey.fromBytesECDSA(Hex.decode((String)publicKey));
    }

    public static PublicKey fromStringDER(String publicKey) {
        return PublicKey.fromBytesDER(Hex.decode((String)publicKey));
    }

    private static PublicKey fromSubjectKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (subjectPublicKeyInfo.getAlgorithm().equals((Object)new AlgorithmIdentifier(ID_ED25519))) {
            return PublicKeyED25519.fromSubjectKeyInfoInternal(subjectPublicKeyInfo);
        }
        return PublicKeyECDSA.fromSubjectKeyInfoInternal(subjectPublicKeyInfo);
    }

    @Nullable
    static PublicKey fromAliasBytes(ByteString aliasBytes) {
        if (!aliasBytes.isEmpty()) {
            try {
                Key key = Key.fromProtobufKey(com.hedera.hashgraph.sdk.proto.Key.parseFrom(aliasBytes));
                return key instanceof PublicKey ? (PublicKey)key : null;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract boolean verify(byte[] var1, byte[] var2);

    abstract ByteString extractSignatureFromProtobuf(SignaturePair var1);

    public boolean verifyTransaction(Transaction<?> transaction) {
        if (!transaction.isFrozen()) {
            transaction.freeze();
        }
        for (PublicKey publicKey : transaction.publicKeys) {
            if (!publicKey.equals(this)) continue;
            return true;
        }
        for (SignedTransaction.Builder signedTransaction : transaction.innerSignedTransactions) {
            boolean found = false;
            for (SignaturePair sigPair : signedTransaction.getSigMap().getSigPairList()) {
                if (!sigPair.getPubKeyPrefix().equals((Object)ByteString.copyFrom((byte[])this.toBytesRaw()))) continue;
                found = true;
                if (this.verify(signedTransaction.getBodyBytes().toByteArray(), this.extractSignatureFromProtobuf(sigPair).toByteArray())) continue;
                return false;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    abstract SignaturePair toSignaturePairProtobuf(byte[] var1);

    @Override
    public abstract byte[] toBytes();

    public abstract byte[] toBytesDER();

    public abstract byte[] toBytesRaw();

    public String toString() {
        return this.toStringDER();
    }

    public String toStringDER() {
        return Hex.toHexString((byte[])this.toBytesDER());
    }

    public String toStringRaw() {
        return Hex.toHexString((byte[])this.toBytesRaw());
    }

    public AccountId toAccountId(@Nonnegative long shard, @Nonnegative long realm) {
        return new AccountId(shard, realm, 0L, null, this, null);
    }

    public abstract boolean isED25519();

    public abstract boolean isECDSA();

    public abstract EvmAddress toEvmAddress();
}

