/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.HederaFunctionality;

public enum RequestType {
    NONE(HederaFunctionality.NONE),
    CRYPTO_TRANSFER(HederaFunctionality.CryptoTransfer),
    CRYPTO_UPDATE(HederaFunctionality.CryptoUpdate),
    CRYPTO_DELETE(HederaFunctionality.CryptoDelete),
    CRYPTO_ADD_LIVE_HASH(HederaFunctionality.CryptoAddLiveHash),
    CRYPTO_DELETE_LIVE_HASH(HederaFunctionality.CryptoDeleteLiveHash),
    CONTRACT_CALL(HederaFunctionality.ContractCall),
    CONTRACT_CREATE(HederaFunctionality.ContractCreate),
    CONTRACT_UPDATE(HederaFunctionality.ContractUpdate),
    FILE_CREATE(HederaFunctionality.FileCreate),
    FILE_APPEND(HederaFunctionality.FileAppend),
    FILE_UPDATE(HederaFunctionality.FileUpdate),
    FILE_DELETE(HederaFunctionality.FileDelete),
    CRYPTO_GET_ACCOUNT_BALANCE(HederaFunctionality.CryptoGetAccountBalance),
    CRYPTO_GET_ACCOUNT_RECORDS(HederaFunctionality.CryptoGetAccountRecords),
    CRYPTO_GET_INFO(HederaFunctionality.CryptoGetInfo),
    CONTRACT_CALL_LOCAL(HederaFunctionality.ContractCallLocal),
    CONTRACT_GET_INFO(HederaFunctionality.ContractGetInfo),
    CONTRACT_GET_BYTECODE(HederaFunctionality.ContractGetBytecode),
    GET_BY_SOLIDITY_ID(HederaFunctionality.GetBySolidityID),
    GET_BY_KEY(HederaFunctionality.GetByKey),
    CRYPTO_GET_LIVE_HASH(HederaFunctionality.CryptoGetLiveHash),
    CRYPTO_GET_STAKERS(HederaFunctionality.CryptoGetStakers),
    FILE_GET_CONTENTS(HederaFunctionality.FileGetContents),
    FILE_GET_INFO(HederaFunctionality.FileGetInfo),
    TRANSACTION_GET_RECORD(HederaFunctionality.TransactionGetRecord),
    CONTRACT_GET_RECORDS(HederaFunctionality.ContractGetRecords),
    CRYPTO_CREATE(HederaFunctionality.CryptoCreate),
    SYSTEM_DELETE(HederaFunctionality.SystemDelete),
    SYSTEM_UNDELETE(HederaFunctionality.SystemUndelete),
    CONTRACT_DELETE(HederaFunctionality.ContractDelete),
    FREEZE(HederaFunctionality.Freeze),
    CREATE_TRANSACTION_RECORD(HederaFunctionality.CreateTransactionRecord),
    CRYPTO_ACCOUNT_AUTO_RENEW(HederaFunctionality.CryptoAccountAutoRenew),
    CONTRACT_AUTO_RENEW(HederaFunctionality.ContractAutoRenew),
    GET_VERSION_INFO(HederaFunctionality.GetVersionInfo),
    TRANSACTION_GET_RECEIPT(HederaFunctionality.TransactionGetReceipt),
    CONSENSUS_CREATE_TOPIC(HederaFunctionality.ConsensusCreateTopic),
    CONSENSUS_UPDATE_TOPIC(HederaFunctionality.ConsensusUpdateTopic),
    CONSENSUS_DELETE_TOPIC(HederaFunctionality.ConsensusDeleteTopic),
    CONSENSUS_GET_TOPIC_INFO(HederaFunctionality.ConsensusGetTopicInfo),
    CONSENSUS_SUBMIT_MESSAGE(HederaFunctionality.ConsensusSubmitMessage),
    UNCHECKED_SUBMIT(HederaFunctionality.UncheckedSubmit),
    TOKEN_CREATE(HederaFunctionality.TokenCreate),
    TOKEN_GET_INFO(HederaFunctionality.TokenGetInfo),
    TOKEN_FREEZE_ACCOUNT(HederaFunctionality.TokenFreezeAccount),
    TOKEN_UNFREEZE_ACCOUNT(HederaFunctionality.TokenUnfreezeAccount),
    TOKEN_GRANT_KYC_TO_ACCOUNT(HederaFunctionality.TokenGrantKycToAccount),
    TOKEN_REVOKE_KYC_FROM_ACCOUNT(HederaFunctionality.TokenRevokeKycFromAccount),
    TOKEN_DELETE(HederaFunctionality.TokenDelete),
    TOKEN_UPDATE(HederaFunctionality.TokenUpdate),
    TOKEN_MINT(HederaFunctionality.TokenMint),
    TOKEN_BURN(HederaFunctionality.TokenBurn),
    TOKEN_ACCOUNT_WIPE(HederaFunctionality.TokenAccountWipe),
    TOKEN_ASSOCIATE_TO_ACCOUNT(HederaFunctionality.TokenAssociateToAccount),
    TOKEN_DISSOCIATE_FROM_ACCOUNT(HederaFunctionality.TokenDissociateFromAccount),
    SCHEDULE_CREATE(HederaFunctionality.ScheduleCreate),
    SCHEDULE_DELETE(HederaFunctionality.ScheduleDelete),
    SCHEDULE_SIGN(HederaFunctionality.ScheduleSign),
    SCHEDULE_GET_INFO(HederaFunctionality.ScheduleGetInfo),
    TOKEN_GET_ACCOUNT_NFT_INFOS(HederaFunctionality.TokenGetAccountNftInfos),
    TOKEN_GET_NFT_INFO(HederaFunctionality.TokenGetNftInfo),
    TOKEN_GET_NFT_INFOS(HederaFunctionality.TokenGetNftInfos),
    TOKEN_FEE_SCHEDULE_UPDATE(HederaFunctionality.TokenFeeScheduleUpdate),
    NETWORK_GET_EXECUTION_TIME(HederaFunctionality.NetworkGetExecutionTime),
    TOKEN_PAUSE(HederaFunctionality.TokenPause),
    TOKEN_UNPAUSE(HederaFunctionality.TokenUnpause),
    CRYPTO_APPROVE_ALLOWANCE(HederaFunctionality.CryptoApproveAllowance),
    CRYPTO_DELETE_ALLOWANCE(HederaFunctionality.CryptoDeleteAllowance),
    GET_ACCOUNT_DETAILS(HederaFunctionality.GetAccountDetails),
    ETHEREUM_TRANSACTION(HederaFunctionality.EthereumTransaction),
    NODE_STAKE_UPDATE(HederaFunctionality.NodeStakeUpdate),
    PRNG(HederaFunctionality.UtilPrng);

    final HederaFunctionality code;

    private RequestType(HederaFunctionality code) {
        this.code = code;
    }

    static RequestType valueOf(HederaFunctionality code) {
        RequestType requestType;
        switch (code) {
            case NONE: {
                requestType = NONE;
                break;
            }
            case CryptoTransfer: {
                requestType = CRYPTO_TRANSFER;
                break;
            }
            case CryptoUpdate: {
                requestType = CRYPTO_UPDATE;
                break;
            }
            case CryptoDelete: {
                requestType = CRYPTO_DELETE;
                break;
            }
            case CryptoAddLiveHash: {
                requestType = CRYPTO_ADD_LIVE_HASH;
                break;
            }
            case CryptoDeleteLiveHash: {
                requestType = CRYPTO_DELETE_LIVE_HASH;
                break;
            }
            case ContractCall: {
                requestType = CONTRACT_CALL;
                break;
            }
            case ContractCreate: {
                requestType = CONTRACT_CREATE;
                break;
            }
            case ContractUpdate: {
                requestType = CONTRACT_UPDATE;
                break;
            }
            case FileCreate: {
                requestType = FILE_CREATE;
                break;
            }
            case FileAppend: {
                requestType = FILE_APPEND;
                break;
            }
            case FileUpdate: {
                requestType = FILE_UPDATE;
                break;
            }
            case FileDelete: {
                requestType = FILE_DELETE;
                break;
            }
            case CryptoGetAccountBalance: {
                requestType = CRYPTO_GET_ACCOUNT_BALANCE;
                break;
            }
            case CryptoGetAccountRecords: {
                requestType = CRYPTO_GET_ACCOUNT_RECORDS;
                break;
            }
            case CryptoGetInfo: {
                requestType = CRYPTO_GET_INFO;
                break;
            }
            case ContractCallLocal: {
                requestType = CONTRACT_CALL_LOCAL;
                break;
            }
            case ContractGetInfo: {
                requestType = CONTRACT_GET_INFO;
                break;
            }
            case ContractGetBytecode: {
                requestType = CONTRACT_GET_BYTECODE;
                break;
            }
            case GetBySolidityID: {
                requestType = GET_BY_SOLIDITY_ID;
                break;
            }
            case GetByKey: {
                requestType = GET_BY_KEY;
                break;
            }
            case CryptoGetLiveHash: {
                requestType = CRYPTO_GET_LIVE_HASH;
                break;
            }
            case CryptoGetStakers: {
                requestType = CRYPTO_GET_STAKERS;
                break;
            }
            case FileGetContents: {
                requestType = FILE_GET_CONTENTS;
                break;
            }
            case FileGetInfo: {
                requestType = FILE_GET_INFO;
                break;
            }
            case TransactionGetRecord: {
                requestType = TRANSACTION_GET_RECORD;
                break;
            }
            case ContractGetRecords: {
                requestType = CONTRACT_GET_RECORDS;
                break;
            }
            case CryptoCreate: {
                requestType = CRYPTO_CREATE;
                break;
            }
            case SystemDelete: {
                requestType = SYSTEM_DELETE;
                break;
            }
            case SystemUndelete: {
                requestType = SYSTEM_UNDELETE;
                break;
            }
            case ContractDelete: {
                requestType = CONTRACT_DELETE;
                break;
            }
            case Freeze: {
                requestType = FREEZE;
                break;
            }
            case CreateTransactionRecord: {
                requestType = CREATE_TRANSACTION_RECORD;
                break;
            }
            case CryptoAccountAutoRenew: {
                requestType = CRYPTO_ACCOUNT_AUTO_RENEW;
                break;
            }
            case ContractAutoRenew: {
                requestType = CONTRACT_AUTO_RENEW;
                break;
            }
            case GetVersionInfo: {
                requestType = GET_VERSION_INFO;
                break;
            }
            case TransactionGetReceipt: {
                requestType = TRANSACTION_GET_RECEIPT;
                break;
            }
            case ConsensusCreateTopic: {
                requestType = CONSENSUS_CREATE_TOPIC;
                break;
            }
            case ConsensusUpdateTopic: {
                requestType = CONSENSUS_UPDATE_TOPIC;
                break;
            }
            case ConsensusDeleteTopic: {
                requestType = CONSENSUS_DELETE_TOPIC;
                break;
            }
            case ConsensusGetTopicInfo: {
                requestType = CONSENSUS_GET_TOPIC_INFO;
                break;
            }
            case ConsensusSubmitMessage: {
                requestType = CONSENSUS_SUBMIT_MESSAGE;
                break;
            }
            case UncheckedSubmit: {
                requestType = UNCHECKED_SUBMIT;
                break;
            }
            case TokenCreate: {
                requestType = TOKEN_CREATE;
                break;
            }
            case TokenGetInfo: {
                requestType = TOKEN_GET_INFO;
                break;
            }
            case TokenFreezeAccount: {
                requestType = TOKEN_FREEZE_ACCOUNT;
                break;
            }
            case TokenUnfreezeAccount: {
                requestType = TOKEN_UNFREEZE_ACCOUNT;
                break;
            }
            case TokenGrantKycToAccount: {
                requestType = TOKEN_GRANT_KYC_TO_ACCOUNT;
                break;
            }
            case TokenRevokeKycFromAccount: {
                requestType = TOKEN_REVOKE_KYC_FROM_ACCOUNT;
                break;
            }
            case TokenDelete: {
                requestType = TOKEN_DELETE;
                break;
            }
            case TokenUpdate: {
                requestType = TOKEN_UPDATE;
                break;
            }
            case TokenMint: {
                requestType = TOKEN_MINT;
                break;
            }
            case TokenBurn: {
                requestType = TOKEN_BURN;
                break;
            }
            case TokenAccountWipe: {
                requestType = TOKEN_ACCOUNT_WIPE;
                break;
            }
            case TokenAssociateToAccount: {
                requestType = TOKEN_ASSOCIATE_TO_ACCOUNT;
                break;
            }
            case TokenDissociateFromAccount: {
                requestType = TOKEN_DISSOCIATE_FROM_ACCOUNT;
                break;
            }
            case ScheduleCreate: {
                requestType = SCHEDULE_CREATE;
                break;
            }
            case ScheduleDelete: {
                requestType = SCHEDULE_DELETE;
                break;
            }
            case ScheduleSign: {
                requestType = SCHEDULE_SIGN;
                break;
            }
            case ScheduleGetInfo: {
                requestType = SCHEDULE_GET_INFO;
                break;
            }
            case TokenGetAccountNftInfos: {
                requestType = TOKEN_GET_ACCOUNT_NFT_INFOS;
                break;
            }
            case TokenGetNftInfo: {
                requestType = TOKEN_GET_NFT_INFO;
                break;
            }
            case TokenGetNftInfos: {
                requestType = TOKEN_GET_NFT_INFOS;
                break;
            }
            case TokenFeeScheduleUpdate: {
                requestType = TOKEN_FEE_SCHEDULE_UPDATE;
                break;
            }
            case NetworkGetExecutionTime: {
                requestType = NETWORK_GET_EXECUTION_TIME;
                break;
            }
            case TokenPause: {
                requestType = TOKEN_PAUSE;
                break;
            }
            case TokenUnpause: {
                requestType = TOKEN_UNPAUSE;
                break;
            }
            case CryptoApproveAllowance: {
                requestType = CRYPTO_APPROVE_ALLOWANCE;
                break;
            }
            case CryptoDeleteAllowance: {
                requestType = CRYPTO_DELETE_ALLOWANCE;
                break;
            }
            case GetAccountDetails: {
                requestType = GET_ACCOUNT_DETAILS;
                break;
            }
            case EthereumTransaction: {
                requestType = ETHEREUM_TRANSACTION;
                break;
            }
            case NodeStakeUpdate: {
                requestType = NODE_STAKE_UPDATE;
                break;
            }
            case UtilPrng: {
                requestType = PRNG;
                break;
            }
            default: {
                throw new IllegalStateException("(BUG) unhandled HederaFunctionality");
            }
        }
        return requestType;
    }

    public String toString() {
        String string;
        switch (this) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NONE: {
                string = "NONE";
                break;
            }
            case CRYPTO_TRANSFER: {
                string = "CRYPTO_TRANSFER";
                break;
            }
            case CRYPTO_UPDATE: {
                string = "CRYPTO_UPDATE";
                break;
            }
            case CRYPTO_DELETE: {
                string = "CRYPTO_DELETE";
                break;
            }
            case CRYPTO_ADD_LIVE_HASH: {
                string = "CRYPTO_ADD_LIVE_HASH";
                break;
            }
            case CRYPTO_DELETE_LIVE_HASH: {
                string = "CRYPTO_DELETE_LIVE_HASH";
                break;
            }
            case CONTRACT_CALL: {
                string = "CONTRACT_CALL";
                break;
            }
            case CONTRACT_CREATE: {
                string = "CONTRACT_CREATE";
                break;
            }
            case CONTRACT_UPDATE: {
                string = "CONTRACT_UPDATE";
                break;
            }
            case FILE_CREATE: {
                string = "FILE_CREATE";
                break;
            }
            case FILE_APPEND: {
                string = "FILE_APPEND";
                break;
            }
            case FILE_UPDATE: {
                string = "FILE_UPDATE";
                break;
            }
            case FILE_DELETE: {
                string = "FILE_DELETE";
                break;
            }
            case CRYPTO_GET_ACCOUNT_BALANCE: {
                string = "CRYPTO_GET_ACCOUNT_BALANCE";
                break;
            }
            case CRYPTO_GET_ACCOUNT_RECORDS: {
                string = "CRYPTO_GET_ACCOUNT_RECORDS";
                break;
            }
            case CRYPTO_GET_INFO: {
                string = "CRYPTO_GET_INFO";
                break;
            }
            case CONTRACT_CALL_LOCAL: {
                string = "CONTRACT_CALL_LOCAL";
                break;
            }
            case CONTRACT_GET_INFO: {
                string = "CONTRACT_GET_INFO";
                break;
            }
            case CONTRACT_GET_BYTECODE: {
                string = "CONTRACT_GET_BYTECODE";
                break;
            }
            case GET_BY_SOLIDITY_ID: {
                string = "GET_BY_SOLIDITY_ID";
                break;
            }
            case GET_BY_KEY: {
                string = "GET_BY_KEY";
                break;
            }
            case CRYPTO_GET_LIVE_HASH: {
                string = "CRYPTO_GET_LIVE_HASH";
                break;
            }
            case CRYPTO_GET_STAKERS: {
                string = "CRYPTO_GET_STAKERS";
                break;
            }
            case FILE_GET_CONTENTS: {
                string = "FILE_GET_CONTENTS";
                break;
            }
            case FILE_GET_INFO: {
                string = "FILE_GET_INFO";
                break;
            }
            case TRANSACTION_GET_RECORD: {
                string = "TRANSACTION_GET_RECORD";
                break;
            }
            case CONTRACT_GET_RECORDS: {
                string = "CONTRACT_GET_RECORDS";
                break;
            }
            case CRYPTO_CREATE: {
                string = "CRYPTO_CREATE";
                break;
            }
            case SYSTEM_DELETE: {
                string = "SYSTEM_DELETE";
                break;
            }
            case SYSTEM_UNDELETE: {
                string = "SYSTEM_UNDELETE";
                break;
            }
            case CONTRACT_DELETE: {
                string = "CONTRACT_DELETE";
                break;
            }
            case FREEZE: {
                string = "FREEZE";
                break;
            }
            case CREATE_TRANSACTION_RECORD: {
                string = "CREATE_TRANSACTION_RECORD";
                break;
            }
            case CRYPTO_ACCOUNT_AUTO_RENEW: {
                string = "CRYPTO_ACCOUNT_AUTO_RENEW";
                break;
            }
            case CONTRACT_AUTO_RENEW: {
                string = "CONTRACT_AUTO_RENEW";
                break;
            }
            case GET_VERSION_INFO: {
                string = "GET_VERSION_INFO";
                break;
            }
            case TRANSACTION_GET_RECEIPT: {
                string = "TRANSACTION_GET_RECEIPT";
                break;
            }
            case CONSENSUS_CREATE_TOPIC: {
                string = "CONSENSUS_CREATE_TOPIC";
                break;
            }
            case CONSENSUS_UPDATE_TOPIC: {
                string = "CONSENSUS_UPDATE_TOPIC";
                break;
            }
            case CONSENSUS_DELETE_TOPIC: {
                string = "CONSENSUS_DELETE_TOPIC";
                break;
            }
            case CONSENSUS_GET_TOPIC_INFO: {
                string = "CONSENSUS_GET_TOPIC_INFO";
                break;
            }
            case CONSENSUS_SUBMIT_MESSAGE: {
                string = "CONSENSUS_SUBMIT_MESSAGE";
                break;
            }
            case UNCHECKED_SUBMIT: {
                string = "UNCHECKED_SUBMIT";
                break;
            }
            case TOKEN_CREATE: {
                string = "TOKEN_CREATE";
                break;
            }
            case TOKEN_GET_INFO: {
                string = "TOKEN_GET_INFO";
                break;
            }
            case TOKEN_FREEZE_ACCOUNT: {
                string = "TOKEN_FREEZE_ACCOUNT";
                break;
            }
            case TOKEN_UNFREEZE_ACCOUNT: {
                string = "TOKEN_UNFREEZE_ACCOUNT";
                break;
            }
            case TOKEN_GRANT_KYC_TO_ACCOUNT: {
                string = "TOKEN_GRANT_KYC_TO_ACCOUNT";
                break;
            }
            case TOKEN_REVOKE_KYC_FROM_ACCOUNT: {
                string = "TOKEN_REVOKE_KYC_FROM_ACCOUNT";
                break;
            }
            case TOKEN_DELETE: {
                string = "TOKEN_DELETE";
                break;
            }
            case TOKEN_UPDATE: {
                string = "TOKEN_UPDATE";
                break;
            }
            case TOKEN_MINT: {
                string = "TOKEN_MINT";
                break;
            }
            case TOKEN_BURN: {
                string = "TOKEN_BURN";
                break;
            }
            case TOKEN_ACCOUNT_WIPE: {
                string = "TOKEN_ACCOUNT_WIPE";
                break;
            }
            case TOKEN_ASSOCIATE_TO_ACCOUNT: {
                string = "TOKEN_ASSOCIATE_TO_ACCOUNT";
                break;
            }
            case TOKEN_DISSOCIATE_FROM_ACCOUNT: {
                string = "TOKEN_DISSOCIATE_FROM_ACCOUNT";
                break;
            }
            case SCHEDULE_CREATE: {
                string = "SCHEDULE_CREATE";
                break;
            }
            case SCHEDULE_DELETE: {
                string = "SCHEDULE_DELETE";
                break;
            }
            case SCHEDULE_SIGN: {
                string = "SCHEDULE_SIGN";
                break;
            }
            case SCHEDULE_GET_INFO: {
                string = "SCHEDULE_GET_INFO";
                break;
            }
            case TOKEN_GET_ACCOUNT_NFT_INFOS: {
                string = "TOKEN_GET_ACCOUNT_NFT_INFOS";
                break;
            }
            case TOKEN_GET_NFT_INFO: {
                string = "TOKEN_GET_NFT_INFO";
                break;
            }
            case TOKEN_GET_NFT_INFOS: {
                string = "TOKEN_GET_NFT_INFOS";
                break;
            }
            case TOKEN_FEE_SCHEDULE_UPDATE: {
                string = "TOKEN_FEE_SCHEDULE_UPDATE";
                break;
            }
            case NETWORK_GET_EXECUTION_TIME: {
                string = "NETWORK_GET_EXECUTION_TIME";
                break;
            }
            case TOKEN_PAUSE: {
                string = "TOKEN_PAUSE";
                break;
            }
            case TOKEN_UNPAUSE: {
                string = "TOKEN_UNPAUSE";
                break;
            }
            case CRYPTO_APPROVE_ALLOWANCE: {
                string = "CRYPTO_APPROVE_ALLOWANCE";
                break;
            }
            case CRYPTO_DELETE_ALLOWANCE: {
                string = "CRYPTO_DELETE_ALLOWANCE";
                break;
            }
            case GET_ACCOUNT_DETAILS: {
                string = "GET_ACCOUNT_DETAILS";
                break;
            }
            case ETHEREUM_TRANSACTION: {
                string = "ETHEREUM_TRANSACTION";
                break;
            }
            case NODE_STAKE_UPDATE: {
                string = "NODE_STAKE_UPDATE";
                break;
            }
            case PRNG: {
                string = "PRNG";
            }
        }
        return string;
    }
}

