/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenFeeScheduleUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.TokenServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

public class TokenFeeScheduleUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TokenFeeScheduleUpdateTransaction> {
    @Nullable
    private TokenId tokenId = null;
    private List<com.hedera.hashgraph.sdk.CustomFee> customFees = new ArrayList<com.hedera.hashgraph.sdk.CustomFee>();

    public TokenFeeScheduleUpdateTransaction() {
    }

    TokenFeeScheduleUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TokenFeeScheduleUpdateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TokenId getTokenId() {
        return this.tokenId;
    }

    public TokenFeeScheduleUpdateTransaction setTokenId(TokenId tokenId) {
        Objects.requireNonNull(tokenId);
        this.requireNotFrozen();
        this.tokenId = tokenId;
        return this;
    }

    public List<com.hedera.hashgraph.sdk.CustomFee> getCustomFees() {
        return com.hedera.hashgraph.sdk.CustomFee.deepCloneList(this.customFees);
    }

    public TokenFeeScheduleUpdateTransaction setCustomFees(List<com.hedera.hashgraph.sdk.CustomFee> customFees) {
        Objects.requireNonNull(customFees);
        this.requireNotFrozen();
        this.customFees = com.hedera.hashgraph.sdk.CustomFee.deepCloneList(customFees);
        return this;
    }

    void initFromTransactionBody() {
        TokenFeeScheduleUpdateTransactionBody body = this.sourceTransactionBody.getTokenFeeScheduleUpdate();
        if (body.hasTokenId()) {
            this.tokenId = TokenId.fromProtobuf(body.getTokenId());
        }
        for (CustomFee fee : body.getCustomFeesList()) {
            this.customFees.add(com.hedera.hashgraph.sdk.CustomFee.fromProtobuf(fee));
        }
    }

    TokenFeeScheduleUpdateTransactionBody.Builder build() {
        TokenFeeScheduleUpdateTransactionBody.Builder builder = TokenFeeScheduleUpdateTransactionBody.newBuilder();
        if (this.tokenId != null) {
            builder.setTokenId(this.tokenId.toProtobuf());
        }
        builder.clearCustomFees();
        for (com.hedera.hashgraph.sdk.CustomFee fee : this.customFees) {
            builder.addCustomFees(fee.toProtobuf());
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.tokenId != null) {
            this.tokenId.validateChecksum(client);
        }
        for (com.hedera.hashgraph.sdk.CustomFee fee : this.customFees) {
            fee.validateChecksums(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return TokenServiceGrpc.getUpdateTokenFeeScheduleMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setTokenFeeScheduleUpdate(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        throw new UnsupportedOperationException("Cannot schedule TokenFeeScheduleUpdateTransaction");
    }
}

