/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.BadKeyException;
import com.hedera.hashgraph.sdk.Crypto;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.PublicKeyECDSA;
import com.hedera.hashgraph.sdk.ThreadLocalSecureRandom;
import com.hedera.hashgraph.sdk.utils.Bip32Utils;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;

public class PrivateKeyECDSA
extends PrivateKey {
    private final BigInteger keyData;
    @Nullable
    private final KeyParameter chainCode;

    PrivateKeyECDSA(BigInteger keyData, @Nullable KeyParameter chainCode) {
        this.keyData = keyData;
        this.chainCode = chainCode;
    }

    static PrivateKeyECDSA generateInternal() {
        ECKeyPairGenerator generator = new ECKeyPairGenerator();
        ECKeyGenerationParameters keygenParams = new ECKeyGenerationParameters(ECDSA_SECP256K1_DOMAIN, ThreadLocalSecureRandom.current());
        generator.init((KeyGenerationParameters)keygenParams);
        AsymmetricCipherKeyPair keypair = generator.generateKeyPair();
        ECPrivateKeyParameters privParams = (ECPrivateKeyParameters)keypair.getPrivate();
        return new PrivateKeyECDSA(privParams.getD(), null);
    }

    static PrivateKeyECDSA fromPrivateKeyInfoInternal(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1OctetString privateKey = (ASN1OctetString)privateKeyInfo.parsePrivateKey();
            return new PrivateKeyECDSA(new BigInteger(1, privateKey.getOctets()), null);
        }
        catch (IOException e) {
            throw new BadKeyException(e);
        }
    }

    public static PrivateKey fromBytesInternal(byte[] privateKey) {
        if (privateKey.length == 32) {
            return new PrivateKeyECDSA(new BigInteger(1, privateKey), null);
        }
        return PrivateKeyECDSA.fromPrivateKeyInfoInternal(PrivateKeyInfo.getInstance((Object)privateKey));
    }

    static byte[] legacyDeriveChildKey(byte[] entropy, long index) {
        throw new IllegalStateException("ECDSA secp256k1 keys do not currently support derivation");
    }

    @Override
    public PrivateKey legacyDerive(long index) {
        throw new IllegalStateException("ECDSA secp256k1 keys do not currently support derivation");
    }

    @Override
    public boolean isDerivable() {
        return this.chainCode != null;
    }

    @Override
    public PrivateKey derive(int index) {
        if (!this.isDerivable()) {
            throw new IllegalStateException("this private key does not support derivation");
        }
        boolean isHardened = Bip32Utils.isHardenedIndex(index);
        ByteBuffer data = ByteBuffer.allocate(37);
        if (isHardened) {
            byte[] bytes33 = new byte[33];
            byte[] priv = this.toBytesRaw();
            System.arraycopy(priv, 0, bytes33, 33 - priv.length, priv.length);
            data.put(bytes33);
        } else {
            data.put(this.getPublicKey().toBytesRaw());
        }
        data.putInt(index);
        byte[] dataArray = data.array();
        HMac hmacSha512 = new HMac((Digest)new SHA512Digest());
        hmacSha512.init((CipherParameters)new KeyParameter(this.chainCode.getKey()));
        hmacSha512.update(dataArray, 0, dataArray.length);
        byte[] i = new byte[64];
        hmacSha512.doFinal(i, 0);
        byte[] il = java.util.Arrays.copyOfRange(i, 0, 32);
        byte[] ir = java.util.Arrays.copyOfRange(i, 32, 64);
        BigInteger ki = this.keyData.add(new BigInteger(1, il)).mod(ECDSA_SECP256K1_CURVE.getN());
        return new PrivateKeyECDSA(ki, new KeyParameter(ir));
    }

    public static PrivateKey fromSeed(byte[] seed) {
        HMac hmacSha512 = new HMac((Digest)new SHA512Digest());
        hmacSha512.init((CipherParameters)new KeyParameter("Bitcoin seed".getBytes(StandardCharsets.UTF_8)));
        hmacSha512.update(seed, 0, seed.length);
        byte[] derivedState = new byte[hmacSha512.getMacSize()];
        hmacSha512.doFinal(derivedState, 0);
        return PrivateKeyECDSA.derivableKeyECDSA(derivedState);
    }

    static PrivateKeyECDSA derivableKeyECDSA(byte[] deriveData) {
        byte[] keyData = java.util.Arrays.copyOfRange(deriveData, 0, 32);
        KeyParameter chainCode = new KeyParameter(deriveData, 32, 32);
        return new PrivateKeyECDSA(new BigInteger(1, keyData), chainCode);
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        ECPoint q = ECDSA_SECP256K1_DOMAIN.getG().multiply(this.keyData);
        ECPublicKeyParameters publicParams = new ECPublicKeyParameters(q, ECDSA_SECP256K1_DOMAIN);
        this.publicKey = new PublicKeyECDSA(publicParams.getQ().getEncoded(true));
        return this.publicKey;
    }

    @Override
    public KeyParameter getChainCode() {
        return this.chainCode;
    }

    @Override
    public byte[] sign(byte[] message) {
        byte[] hash = Crypto.calcKeccak256(message);
        ECDSASigner signer = new ECDSASigner((DSAKCalculator)new HMacDSAKCalculator((Digest)new SHA256Digest()));
        signer.init(true, (CipherParameters)new ECPrivateKeyParameters(this.keyData, ECDSA_SECP256K1_DOMAIN));
        BigInteger[] bigSig = signer.generateSignature(hash);
        byte[] sigBytes = Arrays.copyOf((byte[])PrivateKeyECDSA.bigIntTo32Bytes(bigSig[0]), (int)64);
        System.arraycopy(PrivateKeyECDSA.bigIntTo32Bytes(bigSig[1]), 0, sigBytes, 32, 32);
        return sigBytes;
    }

    @Override
    public byte[] toBytes() {
        return this.toBytesDER();
    }

    private static byte[] bigIntTo32Bytes(BigInteger n) {
        byte[] bytes = n.toByteArray();
        byte[] bytes32 = new byte[32];
        System.arraycopy(bytes, Math.max(0, bytes.length - 32), bytes32, Math.max(0, 32 - bytes.length), Math.min(32, bytes.length));
        return bytes32;
    }

    @Override
    public byte[] toBytesRaw() {
        return PrivateKeyECDSA.bigIntTo32Bytes(this.keyData);
    }

    @Override
    public byte[] toBytesDER() {
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(ID_ECDSA_SECP256K1), (ASN1Encodable)new DEROctetString(this.toBytesRaw())).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isED25519() {
        return false;
    }

    @Override
    public boolean isECDSA() {
        return true;
    }
}

