/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.BadKeyException;
import com.hedera.hashgraph.sdk.PrivateKey;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.PublicKeyED25519;
import com.hedera.hashgraph.sdk.ThreadLocalSecureRandom;
import com.hedera.hashgraph.sdk.utils.Bip32Utils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.math.ec.rfc8032.Ed25519;

class PrivateKeyED25519
extends PrivateKey {
    private final byte[] keyData;
    @Nullable
    private final KeyParameter chainCode;

    PrivateKeyED25519(byte[] keyData, @Nullable KeyParameter chainCode) {
        this.keyData = keyData;
        this.chainCode = chainCode;
    }

    static PrivateKeyED25519 generateInternal() {
        byte[] data = new byte[64];
        ThreadLocalSecureRandom.current().nextBytes(data);
        return PrivateKeyED25519.derivableKeyED25519(data);
    }

    static PrivateKeyED25519 fromPrivateKeyInfoInternal(PrivateKeyInfo privateKeyInfo) {
        try {
            ASN1OctetString privateKey = (ASN1OctetString)privateKeyInfo.parsePrivateKey();
            return new PrivateKeyED25519(privateKey.getOctets(), null);
        }
        catch (IOException e) {
            throw new BadKeyException(e);
        }
    }

    public static PrivateKey fromSeed(byte[] seed) {
        HMac hmacSha512 = new HMac((Digest)new SHA512Digest());
        hmacSha512.init((CipherParameters)new KeyParameter("ed25519 seed".getBytes(StandardCharsets.UTF_8)));
        hmacSha512.update(seed, 0, seed.length);
        byte[] derivedState = new byte[hmacSha512.getMacSize()];
        hmacSha512.doFinal(derivedState, 0);
        return PrivateKeyED25519.derivableKeyED25519(derivedState);
    }

    static PrivateKeyED25519 derivableKeyED25519(byte[] deriveData) {
        byte[] keyData = Arrays.copyOfRange(deriveData, 0, 32);
        KeyParameter chainCode = new KeyParameter(deriveData, 32, 32);
        return new PrivateKeyED25519(keyData, chainCode);
    }

    public static PrivateKey fromBytesInternal(byte[] privateKey) {
        if (privateKey.length == 32 || privateKey.length == 64) {
            return new PrivateKeyED25519(Arrays.copyOfRange(privateKey, 0, 32), null);
        }
        return PrivateKeyED25519.fromPrivateKeyInfoInternal(PrivateKeyInfo.getInstance((Object)privateKey));
    }

    static byte[] legacyDeriveChildKey(byte[] entropy, long index) {
        byte[] seed = new byte[entropy.length + 8];
        Arrays.fill(seed, 0, seed.length, (byte)0);
        if (index == 0xFFFFFFFFFFL) {
            seed[entropy.length + 3] = -1;
            Arrays.fill(seed, entropy.length + 4, seed.length, (byte)(index >>> 32));
        } else {
            if (index < 0L) {
                Arrays.fill(seed, entropy.length, entropy.length + 4, (byte)-1);
            } else {
                Arrays.fill(seed, entropy.length, entropy.length + 4, (byte)0);
            }
            Arrays.fill(seed, entropy.length + 4, seed.length, Long.valueOf(index).byteValue());
        }
        System.arraycopy(entropy, 0, seed, 0, entropy.length);
        byte[] salt = new byte[]{-1};
        PKCS5S2ParametersGenerator pbkdf2 = new PKCS5S2ParametersGenerator((Digest)new SHA512Digest());
        pbkdf2.init(seed, salt, 2048);
        KeyParameter key = (KeyParameter)pbkdf2.generateDerivedParameters(256);
        return key.getKey();
    }

    @Override
    public PrivateKey legacyDerive(long index) {
        byte[] keyBytes = PrivateKeyED25519.legacyDeriveChildKey(this.keyData, index);
        return PrivateKeyED25519.fromBytesInternal(keyBytes);
    }

    @Override
    public boolean isDerivable() {
        return this.chainCode != null;
    }

    @Override
    public PrivateKey derive(int index) {
        if (this.chainCode == null) {
            throw new IllegalStateException("this private key does not support derivation");
        }
        if (Bip32Utils.isHardenedIndex(index)) {
            throw new IllegalArgumentException("the index should not be pre-hardened");
        }
        HMac hmacSha512 = new HMac((Digest)new SHA512Digest());
        hmacSha512.init((CipherParameters)this.chainCode);
        hmacSha512.update((byte)0);
        hmacSha512.update(this.keyData, 0, 32);
        byte[] indexBytes = new byte[4];
        ByteBuffer.wrap(indexBytes).order(ByteOrder.BIG_ENDIAN).putInt(index);
        indexBytes[0] = (byte)(indexBytes[0] | 0xFFFFFF80);
        hmacSha512.update(indexBytes, 0, indexBytes.length);
        byte[] output = new byte[64];
        hmacSha512.doFinal(output, 0);
        return PrivateKeyED25519.derivableKeyED25519(output);
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        byte[] publicKeyData = new byte[32];
        Ed25519.generatePublicKey((byte[])this.keyData, (int)0, (byte[])publicKeyData, (int)0);
        this.publicKey = new PublicKeyED25519(publicKeyData);
        return this.publicKey;
    }

    @Override
    public KeyParameter getChainCode() {
        return this.chainCode;
    }

    @Override
    public byte[] sign(byte[] message) {
        byte[] signature = new byte[64];
        Ed25519.sign((byte[])this.keyData, (int)0, (byte[])message, (int)0, (int)message.length, (byte[])signature, (int)0);
        return signature;
    }

    @Override
    public byte[] toBytes() {
        return this.toBytesRaw();
    }

    @Override
    public byte[] toBytesRaw() {
        return this.keyData;
    }

    @Override
    public byte[] toBytesDER() {
        try {
            return new PrivateKeyInfo(new AlgorithmIdentifier(ID_ED25519), (ASN1Encodable)new DEROctetString(this.keyData)).getEncoded("DER");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isED25519() {
        return true;
    }

    @Override
    public boolean isECDSA() {
        return false;
    }
}

