/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ConsumerHelper;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.Status;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.TransactionRecordQuery;
import com.hedera.hashgraph.sdk.proto.TransactionID;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class TransactionId
implements Comparable<TransactionId> {
    @Nullable
    public final AccountId accountId;
    @Nullable
    public final Instant validStart;
    private boolean scheduled = false;
    @Nullable
    private Integer nonce = null;

    public TransactionId(@Nullable AccountId accountId, @Nullable Instant validStart) {
        this.accountId = accountId;
        this.validStart = validStart;
        this.scheduled = false;
    }

    public static TransactionId withValidStart(AccountId accountId, Instant validStart) {
        return new TransactionId(accountId, validStart);
    }

    public static TransactionId generate(AccountId accountId) {
        Instant instant = Clock.systemUTC().instant().minusNanos((long)(Math.random() * 5.0E9 + 8.0E9));
        return new TransactionId(accountId, instant);
    }

    static TransactionId fromProtobuf(TransactionID transactionID) {
        AccountId accountId = transactionID.hasAccountID() ? AccountId.fromProtobuf(transactionID.getAccountID()) : null;
        Instant validStart = transactionID.hasTransactionValidStart() ? InstantConverter.fromProtobuf(transactionID.getTransactionValidStart()) : null;
        return new TransactionId(accountId, validStart).setScheduled(transactionID.getScheduled()).setNonce(transactionID.getNonce() != 0 ? Integer.valueOf(transactionID.getNonce()) : null);
    }

    public static TransactionId fromString(String s) {
        String[] parts = s.split("/", 2);
        Integer nonce = parts.length == 2 ? Integer.valueOf(Integer.parseInt(parts[1])) : null;
        parts = parts[0].split("\\?", 2);
        boolean scheduled = parts.length == 2 && parts[1].equals("scheduled");
        if ((parts = parts[0].split("@", 2)).length != 2) {
            throw new IllegalArgumentException("expecting {account}@{seconds}.{nanos}[?scheduled][/nonce]");
        }
        AccountId accountId = AccountId.fromString(parts[0]);
        String[] validStartParts = parts[1].split("\\.", 2);
        if (validStartParts.length != 2) {
            throw new IllegalArgumentException("expecting {account}@{seconds}.{nanos}");
        }
        Instant validStart = Instant.ofEpochSecond(Long.parseLong(validStartParts[0]), Long.parseLong(validStartParts[1]));
        return new TransactionId(accountId, validStart).setScheduled(scheduled).setNonce(nonce);
    }

    public static TransactionId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TransactionId.fromProtobuf((TransactionID)((TransactionID.Builder)TransactionID.parseFrom(bytes).toBuilder()).build());
    }

    public boolean getScheduled() {
        return this.scheduled;
    }

    public TransactionId setScheduled(boolean scheduled) {
        this.scheduled = scheduled;
        return this;
    }

    @Nullable
    public Integer getNonce() {
        return this.nonce;
    }

    public TransactionId setNonce(@Nullable Integer nonce) {
        this.nonce = nonce;
        return this;
    }

    public TransactionReceipt getReceipt(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        return this.getReceipt(client, client.getRequestTimeout());
    }

    public TransactionReceipt getReceipt(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        TransactionReceipt receipt = (TransactionReceipt)new TransactionReceiptQuery().setTransactionId(this).execute(client, timeout);
        if (receipt.status != Status.SUCCESS) {
            throw new ReceiptStatusException(this, receipt);
        }
        return receipt;
    }

    public CompletableFuture<TransactionReceipt> getReceiptAsync(Client client) {
        return this.getReceiptAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<TransactionReceipt> getReceiptAsync(Client client, Duration timeout) {
        return new TransactionReceiptQuery().setTransactionId(this).executeAsync(client, timeout).thenCompose(receipt -> {
            if (receipt.status != Status.SUCCESS) {
                return CompletableFuture.failedFuture(new ReceiptStatusException(this, (TransactionReceipt)receipt));
            }
            return CompletableFuture.completedFuture(receipt);
        });
    }

    public void getReceiptAsync(Client client, BiConsumer<TransactionReceipt, Throwable> callback) {
        ConsumerHelper.biConsumer(this.getReceiptAsync(client), callback);
    }

    public void getReceiptAsync(Client client, Duration timeout, BiConsumer<TransactionReceipt, Throwable> callback) {
        ConsumerHelper.biConsumer(this.getReceiptAsync(client, timeout), callback);
    }

    public void getReceiptAsync(Client client, Consumer<TransactionReceipt> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.getReceiptAsync(client), onSuccess, onFailure);
    }

    public void getReceiptAsync(Client client, Duration timeout, Consumer<TransactionReceipt> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.getReceiptAsync(client, timeout), onSuccess, onFailure);
    }

    public TransactionRecord getRecord(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        return this.getRecord(client, client.getRequestTimeout());
    }

    public TransactionRecord getRecord(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        this.getReceipt(client, timeout);
        return (TransactionRecord)new TransactionRecordQuery().setTransactionId(this).execute(client, timeout);
    }

    public CompletableFuture<TransactionRecord> getRecordAsync(Client client) {
        return this.getRecordAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<TransactionRecord> getRecordAsync(Client client, Duration timeout) {
        return this.getReceiptAsync(client, timeout).thenCompose(receipt -> new TransactionRecordQuery().setTransactionId(this).executeAsync(client, timeout));
    }

    public void getRecordAsync(Client client, BiConsumer<TransactionRecord, Throwable> callback) {
        ConsumerHelper.biConsumer(this.getRecordAsync(client), callback);
    }

    public void getRecordAsync(Client client, Duration timeout, BiConsumer<TransactionRecord, Throwable> callback) {
        ConsumerHelper.biConsumer(this.getRecordAsync(client, timeout), callback);
    }

    public void getRecordAsync(Client client, Consumer<TransactionRecord> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.getRecordAsync(client), onSuccess, onFailure);
    }

    public void getRecordAsync(Client client, Duration timeout, Consumer<TransactionRecord> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.getRecordAsync(client, timeout), onSuccess, onFailure);
    }

    TransactionID toProtobuf() {
        TransactionID.Builder id = TransactionID.newBuilder().setScheduled(this.scheduled).setNonce(this.nonce != null ? this.nonce : 0);
        if (this.accountId != null) {
            id.setAccountID(this.accountId.toProtobuf());
        }
        if (this.validStart != null) {
            id.setTransactionValidStart(InstantConverter.toProtobuf(this.validStart));
        }
        return (TransactionID)id.build();
    }

    private String toStringPostfix() {
        Objects.requireNonNull(this.validStart);
        return "@" + this.validStart.getEpochSecond() + "." + String.format("%09d", this.validStart.getNano()) + (this.scheduled ? "?scheduled" : "") + (String)(this.nonce != null ? "/" + this.nonce : "");
    }

    public String toString() {
        if (this.accountId != null && this.validStart != null) {
            return this.accountId + this.toStringPostfix();
        }
        throw new IllegalStateException("`TransactionId.toString()` is non-exhaustive");
    }

    public String toStringWithChecksum(Client client) {
        if (this.accountId != null && this.validStart != null) {
            return this.accountId.toStringWithChecksum(client) + this.toStringPostfix();
        }
        throw new IllegalStateException("`TransactionId.toStringWithChecksum()` is non-exhaustive");
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public boolean equals(Object object) {
        if (!(object instanceof TransactionId)) {
            return false;
        }
        TransactionId id = (TransactionId)object;
        if (this.accountId != null && this.validStart != null && id.accountId != null && id.validStart != null) {
            return id.accountId.equals(this.accountId) && id.validStart.equals(this.validStart) && this.scheduled == id.scheduled;
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(TransactionId o) {
        boolean otherStartIsNull;
        int accountIdComparison;
        boolean otherAccountIdIsNull;
        Objects.requireNonNull(o);
        if (this.scheduled != o.scheduled) {
            return this.scheduled ? 1 : -1;
        }
        boolean thisAccountIdIsNull = this.accountId == null;
        boolean bl = otherAccountIdIsNull = o.accountId == null;
        if (thisAccountIdIsNull != otherAccountIdIsNull) {
            return thisAccountIdIsNull ? -1 : 1;
        }
        if (!thisAccountIdIsNull && (accountIdComparison = this.accountId.compareTo(o.accountId)) != 0) {
            return accountIdComparison;
        }
        boolean thisStartIsNull = this.validStart == null;
        boolean bl2 = otherStartIsNull = o.validStart == null;
        if (thisStartIsNull != otherStartIsNull) {
            return thisAccountIdIsNull ? -1 : 1;
        }
        if (!thisStartIsNull) {
            return this.validStart.compareTo(o.validStart);
        }
        return 0;
    }
}

