/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.ConsumerHelper;
import com.hedera.hashgraph.sdk.PrecheckStatusException;
import com.hedera.hashgraph.sdk.ReceiptStatusException;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.TransactionReceipt;
import com.hedera.hashgraph.sdk.TransactionReceiptQuery;
import com.hedera.hashgraph.sdk.TransactionRecord;
import com.hedera.hashgraph.sdk.TransactionRecordQuery;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class TransactionResponse {
    public final AccountId nodeId;
    public final byte[] transactionHash;
    public final TransactionId transactionId;
    @Nullable
    @Deprecated
    public final TransactionId scheduledTransactionId;
    private boolean validateStatus = true;

    TransactionResponse(AccountId nodeId, TransactionId transactionId, byte[] transactionHash, @Nullable TransactionId scheduledTransactionId) {
        this.nodeId = nodeId;
        this.transactionId = transactionId;
        this.transactionHash = transactionHash;
        this.scheduledTransactionId = scheduledTransactionId;
    }

    public boolean getValidateStatus() {
        return this.validateStatus;
    }

    public TransactionResponse setValidateStatus(boolean validateStatus) {
        this.validateStatus = validateStatus;
        return this;
    }

    public TransactionReceipt getReceipt(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        return this.getReceipt(client, client.getRequestTimeout());
    }

    public TransactionReceipt getReceipt(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        TransactionReceipt receipt = ((TransactionReceipt)this.getReceiptQuery().execute(client, timeout)).validateStatus(this.validateStatus);
        return receipt;
    }

    public TransactionReceiptQuery getReceiptQuery() {
        return (TransactionReceiptQuery)new TransactionReceiptQuery().setTransactionId(this.transactionId).setNodeAccountIds((List)Collections.singletonList(this.nodeId));
    }

    public CompletableFuture<TransactionReceipt> getReceiptAsync(Client client) {
        return this.getReceiptAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<TransactionReceipt> getReceiptAsync(Client client, Duration timeout) {
        return this.getReceiptQuery().executeAsync(client, timeout).thenCompose(receipt -> {
            try {
                return CompletableFuture.completedFuture(receipt.validateStatus(this.validateStatus));
            }
            catch (ReceiptStatusException e) {
                return CompletableFuture.failedFuture(e);
            }
        });
    }

    public void getReceiptAsync(Client client, BiConsumer<TransactionReceipt, Throwable> callback) {
        ConsumerHelper.biConsumer(this.getReceiptAsync(client), callback);
    }

    public void getReceiptAsync(Client client, Duration timeout, BiConsumer<TransactionReceipt, Throwable> callback) {
        ConsumerHelper.biConsumer(this.getReceiptAsync(client, timeout), callback);
    }

    public void getReceiptAsync(Client client, Consumer<TransactionReceipt> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.getReceiptAsync(client), onSuccess, onFailure);
    }

    public void getReceiptAsync(Client client, Duration timeout, Consumer<TransactionReceipt> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.getReceiptAsync(client, timeout), onSuccess, onFailure);
    }

    public TransactionRecord getRecord(Client client) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        return this.getRecord(client, client.getRequestTimeout());
    }

    public TransactionRecord getRecord(Client client, Duration timeout) throws TimeoutException, PrecheckStatusException, ReceiptStatusException {
        this.getReceipt(client, timeout);
        return (TransactionRecord)this.getRecordQuery().execute(client, timeout);
    }

    public TransactionRecordQuery getRecordQuery() {
        return (TransactionRecordQuery)new TransactionRecordQuery().setTransactionId(this.transactionId).setNodeAccountIds((List)Collections.singletonList(this.nodeId));
    }

    public CompletableFuture<TransactionRecord> getRecordAsync(Client client) {
        return this.getRecordAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<TransactionRecord> getRecordAsync(Client client, Duration timeout) {
        return this.getReceiptAsync(client, timeout).thenCompose(receipt -> this.getRecordQuery().executeAsync(client, timeout));
    }

    public void getRecordAsync(Client client, BiConsumer<TransactionRecord, Throwable> callback) {
        ConsumerHelper.biConsumer(this.getRecordAsync(client), callback);
    }

    public void getRecordAsync(Client client, Duration timeout, BiConsumer<TransactionRecord, Throwable> callback) {
        ConsumerHelper.biConsumer(this.getRecordAsync(client, timeout), callback);
    }

    public void getRecordAsync(Client client, Consumer<TransactionRecord> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.getRecordAsync(client), onSuccess, onFailure);
    }

    public void getRecordAsync(Client client, Duration timeout, Consumer<TransactionRecord> onSuccess, Consumer<Throwable> onFailure) {
        ConsumerHelper.twoConsumers(this.getRecordAsync(client, timeout), onSuccess, onFailure);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeId", (Object)this.nodeId).add("transactionHash", (Object)Hex.toHexString((byte[])this.transactionHash)).add("transactionId", (Object)this.transactionId).toString();
    }
}

