/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Executable;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.NodeAddressBook;
import com.hedera.hashgraph.sdk.proto.NodeAddress;
import com.hedera.hashgraph.sdk.proto.mirror.AddressBookQuery;
import com.hedera.hashgraph.sdk.proto.mirror.NetworkServiceGrpc;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.CallOptions;
import io.grpc.ClientCall;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddressBookQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressBookQuery.class);
    @Nullable
    private FileId fileId = null;
    @Nullable
    private Integer limit = null;
    private int maxAttempts = 10;
    private Duration maxBackoff = Duration.ofSeconds(8L);

    private static boolean shouldRetry(Throwable throwable) {
        if (throwable instanceof StatusRuntimeException) {
            StatusRuntimeException statusRuntimeException = (StatusRuntimeException)throwable;
            Status.Code code = statusRuntimeException.getStatus().getCode();
            String description = statusRuntimeException.getStatus().getDescription();
            return code == Status.Code.UNAVAILABLE || code == Status.Code.RESOURCE_EXHAUSTED || code == Status.Code.INTERNAL && description != null && Executable.RST_STREAM.matcher(description).matches();
        }
        return false;
    }

    @Nullable
    public FileId getFileId() {
        return this.fileId;
    }

    public AddressBookQuery setFileId(FileId fileId) {
        this.fileId = fileId;
        return this;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    public AddressBookQuery setLimit(@Nullable @Nonnegative Integer limit) {
        this.limit = limit;
        return this;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public AddressBookQuery setMaxAttempts(@Nonnegative int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="A Duration can't actually be mutated")
    public AddressBookQuery setMaxBackoff(Duration maxBackoff) {
        Objects.requireNonNull(maxBackoff);
        if (maxBackoff.toMillis() < 500L) {
            throw new IllegalArgumentException("maxBackoff must be at least 500 ms");
        }
        this.maxBackoff = maxBackoff;
        return this;
    }

    public NodeAddressBook execute(Client client) {
        return this.execute(client, client.getRequestTimeout());
    }

    public NodeAddressBook execute(Client client, Duration timeout) {
        Deadline deadline = Deadline.after((long)timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        int attempt = 1;
        while (true) {
            try {
                Iterator addressProtoIter = ClientCalls.blockingServerStreamingCall(this.buildCall(client, deadline), (Object)this.buildQuery());
                ArrayList<com.hedera.hashgraph.sdk.NodeAddress> addresses = new ArrayList<com.hedera.hashgraph.sdk.NodeAddress>();
                while (addressProtoIter.hasNext()) {
                    addresses.add(com.hedera.hashgraph.sdk.NodeAddress.fromProtobuf((NodeAddress)addressProtoIter.next()));
                }
                return new NodeAddressBook().setNodeAddresses(addresses);
            }
            catch (Throwable error) {
                if (!AddressBookQuery.shouldRetry(error) || attempt >= this.maxAttempts) {
                    LOGGER.error("Error attempting to get address book at FileId {}", (Object)this.fileId, (Object)error);
                    throw error;
                }
                this.warnAndDelay(attempt, error);
                ++attempt;
                continue;
            }
            break;
        }
    }

    public CompletableFuture<NodeAddressBook> executeAsync(Client client) {
        return this.executeAsync(client, client.getRequestTimeout());
    }

    public CompletableFuture<NodeAddressBook> executeAsync(Client client, Duration timeout) {
        Deadline deadline = Deadline.after((long)timeout.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
        CompletableFuture<NodeAddressBook> returnFuture = new CompletableFuture<NodeAddressBook>();
        this.executeAsync(client, deadline, returnFuture, 1);
        return returnFuture;
    }

    void executeAsync(final Client client, final Deadline deadline, final CompletableFuture<NodeAddressBook> returnFuture, final int attempt) {
        final ArrayList addresses = new ArrayList();
        ClientCalls.asyncServerStreamingCall(this.buildCall(client, deadline), (Object)this.buildQuery(), (StreamObserver)new StreamObserver<NodeAddress>(){

            public void onNext(NodeAddress addressProto) {
                addresses.add(com.hedera.hashgraph.sdk.NodeAddress.fromProtobuf(addressProto));
            }

            public void onError(Throwable error) {
                if (attempt >= AddressBookQuery.this.maxAttempts || !AddressBookQuery.shouldRetry(error)) {
                    LOGGER.error("Error attempting to get address book at FileId {}", (Object)AddressBookQuery.this.fileId, (Object)error);
                    returnFuture.completeExceptionally(error);
                    return;
                }
                AddressBookQuery.this.warnAndDelay(attempt, error);
                addresses.clear();
                AddressBookQuery.this.executeAsync(client, deadline, returnFuture, attempt + 1);
            }

            public void onCompleted() {
                returnFuture.complete(new NodeAddressBook().setNodeAddresses(addresses));
            }
        });
    }

    com.hedera.hashgraph.sdk.proto.mirror.AddressBookQuery buildQuery() {
        AddressBookQuery.Builder builder = com.hedera.hashgraph.sdk.proto.mirror.AddressBookQuery.newBuilder();
        if (this.fileId != null) {
            builder.setFileId(this.fileId.toProtobuf());
        }
        if (this.limit != null) {
            builder.setLimit(this.limit);
        }
        return (com.hedera.hashgraph.sdk.proto.mirror.AddressBookQuery)builder.build();
    }

    private ClientCall<com.hedera.hashgraph.sdk.proto.mirror.AddressBookQuery, NodeAddress> buildCall(Client client, Deadline deadline) {
        try {
            return client.mirrorNetwork.getNextMirrorNode().getChannel().newCall(NetworkServiceGrpc.getGetNodesMethod(), CallOptions.DEFAULT.withDeadline(deadline));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void warnAndDelay(int attempt, Throwable error) {
        long delay = Math.min(500L * (long)Math.pow(2.0, attempt), this.maxBackoff.toMillis());
        LOGGER.warn("Error fetching address book at FileId {} during attempt #{}. Waiting {} ms before next attempt: {}", new Object[]{this.fileId, attempt, delay, error.getMessage()});
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

