/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.CustomFeeBase;
import com.hedera.hashgraph.sdk.CustomFixedFee;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.Fraction;
import com.hedera.hashgraph.sdk.proto.RoyaltyFee;
import java.util.Objects;
import javax.annotation.Nullable;

public class CustomRoyaltyFee
extends CustomFeeBase<CustomRoyaltyFee> {
    private long numerator = 0L;
    private long denominator = 1L;
    @Nullable
    private CustomFixedFee fallbackFee = null;

    static CustomRoyaltyFee fromProtobuf(RoyaltyFee royaltyFee) {
        Fraction fraction = royaltyFee.getExchangeValueFraction();
        CustomRoyaltyFee returnFee = new CustomRoyaltyFee().setNumerator(fraction.getNumerator()).setDenominator(fraction.getDenominator());
        if (royaltyFee.hasFallbackFee()) {
            returnFee.fallbackFee = CustomFixedFee.fromProtobuf(royaltyFee.getFallbackFee());
        }
        return returnFee;
    }

    @Override
    CustomRoyaltyFee deepCloneSubclass() {
        CustomRoyaltyFee returnFee = new CustomRoyaltyFee();
        returnFee.numerator = this.numerator;
        returnFee.denominator = this.denominator;
        returnFee.fallbackFee = this.fallbackFee != null ? this.fallbackFee.deepCloneSubclass() : null;
        returnFee.feeCollectorAccountId = this.feeCollectorAccountId;
        returnFee.allCollectorsAreExempt = this.allCollectorsAreExempt;
        return returnFee;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public CustomRoyaltyFee setNumerator(long numerator) {
        this.numerator = numerator;
        return this;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public CustomRoyaltyFee setDenominator(long denominator) {
        this.denominator = denominator;
        return this;
    }

    public CustomRoyaltyFee setFallbackFee(CustomFixedFee fallbackFee) {
        Objects.requireNonNull(fallbackFee);
        this.fallbackFee = fallbackFee.deepCloneSubclass();
        return this;
    }

    @Nullable
    public CustomFixedFee getFallbackFee() {
        return this.fallbackFee != null ? this.fallbackFee.deepCloneSubclass() : null;
    }

    RoyaltyFee toRoyaltyFeeProtobuf() {
        RoyaltyFee.Builder royaltyFeeBuilder = RoyaltyFee.newBuilder().setExchangeValueFraction(Fraction.newBuilder().setNumerator(this.numerator).setDenominator(this.denominator));
        if (this.fallbackFee != null) {
            royaltyFeeBuilder.setFallbackFee(this.fallbackFee.toFixedFeeProtobuf());
        }
        return (RoyaltyFee)royaltyFeeBuilder.build();
    }

    @Override
    CustomFee toProtobuf() {
        CustomFee.Builder customFeeBuilder = CustomFee.newBuilder().setRoyaltyFee(this.toRoyaltyFeeProtobuf());
        return this.finishToProtobuf(customFeeBuilder);
    }

    public String toString() {
        return this.toStringHelper().add("numerator", this.numerator).add("denominator", this.denominator).add("fallbackFee", (Object)this.fallbackFee).toString();
    }
}

