/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.EthereumTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.SmartContractServiceGrpc;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import io.grpc.MethodDescriptor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public class EthereumTransaction
extends com.hedera.hashgraph.sdk.Transaction<EthereumTransaction> {
    private byte[] ethereumData = new byte[0];
    private FileId callDataFileId = null;
    private Hbar maxGasAllowanceHbar = Hbar.ZERO;

    public EthereumTransaction() {
    }

    EthereumTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    EthereumTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    public byte[] getEthereumData() {
        return Arrays.copyOf(this.ethereumData, this.ethereumData.length);
    }

    public EthereumTransaction setEthereumData(byte[] ethereumData) {
        Objects.requireNonNull(ethereumData);
        this.requireNotFrozen();
        this.ethereumData = Arrays.copyOf(ethereumData, ethereumData.length);
        return this;
    }

    @Nullable
    public FileId getCallDataFileId() {
        return this.callDataFileId;
    }

    public EthereumTransaction setCallDataFileId(FileId fileId) {
        Objects.requireNonNull(fileId);
        this.requireNotFrozen();
        this.callDataFileId = fileId;
        return this;
    }

    public Hbar getMaxGasAllowanceHbar() {
        return this.maxGasAllowanceHbar;
    }

    public EthereumTransaction setMaxGasAllowanceHbar(Hbar maxGasAllowanceHbar) {
        Objects.requireNonNull(maxGasAllowanceHbar);
        this.requireNotFrozen();
        this.maxGasAllowanceHbar = maxGasAllowanceHbar;
        return this;
    }

    private void initFromTransactionBody() {
        EthereumTransactionBody body = this.sourceTransactionBody.getEthereumTransaction();
        this.ethereumData = body.getEthereumData().toByteArray();
        if (body.hasCallData()) {
            this.callDataFileId = FileId.fromProtobuf(body.getCallData());
        }
        this.maxGasAllowanceHbar = Hbar.fromTinybars(body.getMaxGasAllowance());
    }

    private EthereumTransactionBody.Builder build() {
        EthereumTransactionBody.Builder builder = EthereumTransactionBody.newBuilder().setEthereumData(ByteString.copyFrom((byte[])this.ethereumData)).setMaxGasAllowance(this.maxGasAllowanceHbar.toTinybars());
        if (this.callDataFileId != null) {
            builder.setCallData(this.callDataFileId.toProtobuf());
        }
        return builder;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return SmartContractServiceGrpc.getCallEthereumMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setEthereumTransaction(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        throw new UnsupportedOperationException("Cannot schedule EthereumTransaction");
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.callDataFileId != null) {
            this.callDataFileId.validateChecksum(client);
        }
    }
}

