/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.FileId;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.KeyList;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.FileUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.MethodDescriptor;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FileUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<FileUpdateTransaction> {
    @Nullable
    private FileId fileId = null;
    @Nullable
    private KeyList keys = null;
    @Nullable
    private Instant expirationTime = null;
    private byte[] contents = new byte[0];
    @Nullable
    private String fileMemo = null;

    public FileUpdateTransaction() {
    }

    FileUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    FileUpdateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public FileId getFileId() {
        return this.fileId;
    }

    public FileUpdateTransaction setFileId(FileId fileId) {
        Objects.requireNonNull(fileId);
        this.requireNotFrozen();
        this.fileId = fileId;
        return this;
    }

    @Nullable
    public Collection<Key> getKeys() {
        return this.keys != null ? Collections.unmodifiableCollection(this.keys) : null;
    }

    public FileUpdateTransaction setKeys(Key ... keys) {
        this.requireNotFrozen();
        this.keys = KeyList.of(keys);
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="An Instant can't actually be mutated")
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="An Instant can't actually be mutated")
    public FileUpdateTransaction setExpirationTime(Instant expirationTime) {
        Objects.requireNonNull(expirationTime);
        this.requireNotFrozen();
        this.expirationTime = expirationTime;
        return this;
    }

    public ByteString getContents() {
        return ByteString.copyFrom((byte[])this.contents);
    }

    public FileUpdateTransaction setContents(byte[] bytes) {
        this.requireNotFrozen();
        Objects.requireNonNull(bytes);
        this.contents = Arrays.copyOf(bytes, bytes.length);
        return this;
    }

    public FileUpdateTransaction setContents(String text) {
        Objects.requireNonNull(text);
        this.requireNotFrozen();
        this.contents = text.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    @Nullable
    public String getFileMemo() {
        return this.fileMemo;
    }

    public FileUpdateTransaction setFileMemo(String memo) {
        Objects.requireNonNull(memo);
        this.requireNotFrozen();
        this.fileMemo = memo;
        return this;
    }

    public FileUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.fileMemo = "";
        return this;
    }

    void initFromTransactionBody() {
        FileUpdateTransactionBody body = this.sourceTransactionBody.getFileUpdate();
        if (body.hasFileID()) {
            this.fileId = FileId.fromProtobuf(body.getFileID());
        }
        if (body.hasKeys()) {
            this.keys = KeyList.fromProtobuf(body.getKeys(), null);
        }
        if (body.hasExpirationTime()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpirationTime());
        }
        if (body.hasMemo()) {
            this.fileMemo = body.getMemo().getValue();
        }
        this.contents = body.getContents().toByteArray();
    }

    FileUpdateTransactionBody.Builder build() {
        FileUpdateTransactionBody.Builder builder = FileUpdateTransactionBody.newBuilder();
        if (this.fileId != null) {
            builder.setFileID(this.fileId.toProtobuf());
        }
        if (this.keys != null) {
            builder.setKeys(this.keys.toProtobuf());
        }
        if (this.expirationTime != null) {
            builder.setExpirationTime(InstantConverter.toProtobuf(this.expirationTime));
        }
        builder.setContents(ByteString.copyFrom((byte[])this.contents));
        if (this.fileMemo != null) {
            builder.setMemo(StringValue.of((String)this.fileMemo));
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.fileId != null) {
            this.fileId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FileServiceGrpc.getUpdateFileMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFileUpdate(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setFileUpdate(this.build());
    }
}

