/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.proto.TopicID;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class TopicId
implements Comparable<TopicId> {
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;
    @Nullable
    private final String checksum;

    public TopicId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public TopicId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this(shard, realm, num, null);
    }

    TopicId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
    }

    public static TopicId fromString(String id) {
        return EntityIdHelper.fromString(id, TopicId::new);
    }

    public static TopicId fromSolidityAddress(String address) {
        return EntityIdHelper.fromSolidityAddress(address, TopicId::new);
    }

    static TopicId fromProtobuf(TopicID topicId) {
        Objects.requireNonNull(topicId);
        return new TopicId(topicId.getShardNum(), topicId.getRealmNum(), topicId.getTopicNum());
    }

    public static TopicId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return TopicId.fromProtobuf((TopicID)((TopicID.Builder)TopicID.parseFrom(bytes).toBuilder()).build());
    }

    public String toSolidityAddress() {
        return EntityIdHelper.toSolidityAddress(this.shard, this.realm, this.num);
    }

    TopicID toProtobuf() {
        return (TopicID)TopicID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm).setTopicNum(this.num).build();
    }

    @Deprecated
    public void validate(Client client) throws BadEntityIdException {
        this.validateChecksum(client);
    }

    public void validateChecksum(Client client) throws BadEntityIdException {
        EntityIdHelper.validate(this.shard, this.realm, this.num, client, this.checksum);
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        return EntityIdHelper.toString(this.shard, this.realm, this.num);
    }

    public String tostringwithchecksum(Client client) {
        return EntityIdHelper.toStringWithChecksum(this.shard, this.realm, this.num, client, this.checksum);
    }

    public int hashCode() {
        return Objects.hash(this.shard, this.realm, this.num);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TopicId)) {
            return false;
        }
        TopicId otherId = (TopicId)o;
        return this.shard == otherId.shard && this.realm == otherId.realm && this.num == otherId.num;
    }

    @Override
    public int compareTo(TopicId o) {
        Objects.requireNonNull(o);
        int shardComparison = Long.compare(this.shard, o.shard);
        if (shardComparison != 0) {
            return shardComparison;
        }
        int realmComparison = Long.compare(this.realm, o.realm);
        if (realmComparison != 0) {
            return realmComparison;
        }
        return Long.compare(this.num, o.num);
    }
}

