/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.KeyList;
import com.hedera.hashgraph.sdk.TopicId;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.ConsensusServiceGrpc;
import com.hedera.hashgraph.sdk.proto.ConsensusUpdateTopicTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TopicUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<TopicUpdateTransaction> {
    @Nullable
    private TopicId topicId = null;
    @Nullable
    private AccountId autoRenewAccountId = null;
    @Nullable
    private String topicMemo = null;
    @Nullable
    private Key adminKey = null;
    @Nullable
    private Key submitKey = null;
    @Nullable
    private Duration autoRenewPeriod = null;
    @Nullable
    private Instant expirationTime = null;

    public TopicUpdateTransaction() {
    }

    TopicUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    TopicUpdateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public TopicId getTopicId() {
        return this.topicId;
    }

    public TopicUpdateTransaction setTopicId(TopicId topicId) {
        Objects.requireNonNull(topicId);
        this.requireNotFrozen();
        this.topicId = topicId;
        return this;
    }

    @Nullable
    public String getTopicMemo() {
        return this.topicMemo;
    }

    public TopicUpdateTransaction setTopicMemo(String memo) {
        Objects.requireNonNull(memo);
        this.requireNotFrozen();
        this.topicMemo = memo;
        return this;
    }

    public TopicUpdateTransaction clearTopicMemo() {
        this.requireNotFrozen();
        this.topicMemo = "";
        return this;
    }

    @Nullable
    public Key getAdminKey() {
        return this.adminKey;
    }

    public TopicUpdateTransaction setAdminKey(Key adminKey) {
        Objects.requireNonNull(adminKey);
        this.requireNotFrozen();
        this.adminKey = adminKey;
        return this;
    }

    public TopicUpdateTransaction clearAdminKey() {
        this.requireNotFrozen();
        this.adminKey = new KeyList();
        return this;
    }

    @Nullable
    public Key getSubmitKey() {
        return this.submitKey;
    }

    public TopicUpdateTransaction setSubmitKey(Key submitKey) {
        Objects.requireNonNull(submitKey);
        this.requireNotFrozen();
        this.submitKey = submitKey;
        return this;
    }

    public TopicUpdateTransaction clearSubmitKey() {
        this.requireNotFrozen();
        this.submitKey = new KeyList();
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="A Duration can't actually be mutated")
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="A Duration can't actually be mutated")
    public TopicUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        Objects.requireNonNull(autoRenewPeriod);
        this.requireNotFrozen();
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    @Nullable
    public AccountId getAutoRenewAccountId() {
        return this.autoRenewAccountId;
    }

    public TopicUpdateTransaction setAutoRenewAccountId(AccountId autoRenewAccountId) {
        Objects.requireNonNull(autoRenewAccountId);
        this.requireNotFrozen();
        this.autoRenewAccountId = autoRenewAccountId;
        return this;
    }

    @Deprecated
    public TopicUpdateTransaction clearAutoRenewAccountId(AccountId autoRenewAccountId) {
        return this.clearAutoRenewAccountId();
    }

    public TopicUpdateTransaction clearAutoRenewAccountId() {
        this.requireNotFrozen();
        this.autoRenewAccountId = new AccountId(0L);
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="An Instant can't actually be mutated")
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="An Instant can't actually be mutated")
    public TopicUpdateTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        this.expirationTime = Objects.requireNonNull(expirationTime);
        return this;
    }

    void initFromTransactionBody() {
        ConsensusUpdateTopicTransactionBody body = this.sourceTransactionBody.getConsensusUpdateTopic();
        if (body.hasTopicID()) {
            this.topicId = TopicId.fromProtobuf(body.getTopicID());
        }
        if (body.hasAdminKey()) {
            this.adminKey = Key.fromProtobufKey(body.getAdminKey());
        }
        if (body.hasSubmitKey()) {
            this.submitKey = Key.fromProtobufKey(body.getSubmitKey());
        }
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        if (body.hasAutoRenewAccount()) {
            this.autoRenewAccountId = AccountId.fromProtobuf(body.getAutoRenewAccount());
        }
        if (body.hasMemo()) {
            this.topicMemo = body.getMemo().getValue();
        }
        if (body.hasExpirationTime()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpirationTime());
        }
    }

    ConsensusUpdateTopicTransactionBody.Builder build() {
        ConsensusUpdateTopicTransactionBody.Builder builder = ConsensusUpdateTopicTransactionBody.newBuilder();
        if (this.topicId != null) {
            builder.setTopicID(this.topicId.toProtobuf());
        }
        if (this.autoRenewAccountId != null) {
            builder.setAutoRenewAccount(this.autoRenewAccountId.toProtobuf());
        }
        if (this.adminKey != null) {
            builder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.submitKey != null) {
            builder.setSubmitKey(this.submitKey.toProtobufKey());
        }
        if (this.autoRenewPeriod != null) {
            builder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        if (this.topicMemo != null) {
            builder.setMemo(StringValue.of((String)this.topicMemo));
        }
        if (this.expirationTime != null) {
            builder.setExpirationTime(InstantConverter.toProtobuf(this.expirationTime));
        }
        return builder;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.topicId != null) {
            this.topicId.validateChecksum(client);
        }
        if (this.autoRenewAccountId != null && !this.autoRenewAccountId.equals(new AccountId(0L))) {
            this.autoRenewAccountId.validateChecksum(client);
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return ConsensusServiceGrpc.getUpdateTopicMethod();
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setConsensusUpdateTopic(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setConsensusUpdateTopic(this.build());
    }
}

