/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.EntityIdHelper;
import com.hedera.hashgraph.sdk.EvmAddress;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.proto.AccountID;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.bouncycastle.util.encoders.Hex;

public final class AccountId
implements Comparable<AccountId> {
    private static final Pattern ALIAS_ID_REGEX = Pattern.compile("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.((?:[0-9a-fA-F][0-9a-fA-F])+)$");
    @Nonnegative
    public final long shard;
    @Nonnegative
    public final long realm;
    @Nonnegative
    public final long num;
    @Nullable
    public final PublicKey aliasKey;
    @Nullable
    public final EvmAddress evmAddress;
    @Nullable
    private final String checksum;

    public AccountId(@Nonnegative long num) {
        this(0L, 0L, num);
    }

    public AccountId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num) {
        this(shard, realm, num, null);
    }

    AccountId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
        this.aliasKey = null;
        this.evmAddress = null;
    }

    AccountId(@Nonnegative long shard, @Nonnegative long realm, @Nonnegative long num, @Nullable String checksum, @Nullable PublicKey aliasKey, @Nullable EvmAddress evmAddress) {
        this.shard = shard;
        this.realm = realm;
        this.num = num;
        this.checksum = checksum;
        this.aliasKey = aliasKey;
        this.evmAddress = evmAddress;
    }

    public static AccountId fromString(String id) {
        if (id.startsWith("0x") && id.length() == 42 || id.length() == 40) {
            return AccountId.fromEvmAddress(id);
        }
        try {
            return EntityIdHelper.fromString(id, AccountId::new);
        }
        catch (IllegalArgumentException error) {
            Matcher match = ALIAS_ID_REGEX.matcher(id);
            if (!match.find()) {
                throw new IllegalArgumentException("Invalid Account ID \"" + id + "\": format should look like 0.0.123 or 0.0.123-vfmkw or 0.0.1337BEEF (where 1337BEEF is a hex-encoded, DER-format public key)");
            }
            byte[] aliasBytes = Hex.decode((String)match.group(3));
            boolean isEvmAddress = aliasBytes.length == 20;
            return new AccountId(Long.parseLong(match.group(1)), Long.parseLong(match.group(2)), 0L, null, isEvmAddress ? null : PublicKey.fromBytesDER(aliasBytes), isEvmAddress ? EvmAddress.fromBytes(aliasBytes) : null);
        }
    }

    public static AccountId fromEvmAddress(String evmAddress) {
        return AccountId.fromEvmAddress(evmAddress, 0L, 0L);
    }

    public static AccountId fromEvmAddress(String evmAddress, @Nonnegative long shard, @Nonnegative long realm) {
        return AccountId.fromEvmAddress(EvmAddress.fromString(evmAddress), shard, realm);
    }

    public static AccountId fromEvmAddress(EvmAddress evmAddress) {
        return AccountId.fromEvmAddress(evmAddress, 0L, 0L);
    }

    public static AccountId fromEvmAddress(EvmAddress evmAddress, @Nonnegative long shard, @Nonnegative long realm) {
        return new AccountId(shard, realm, 0L, null, null, evmAddress);
    }

    public static AccountId fromSolidityAddress(String address) {
        if (EntityIdHelper.isLongZeroAddress(EntityIdHelper.decodeSolidityAddress(address))) {
            return EntityIdHelper.fromSolidityAddress(address, AccountId::new);
        }
        return AccountId.fromEvmAddress(address);
    }

    static AccountId fromProtobuf(AccountID accountId) {
        PublicKey aliasKey = null;
        EvmAddress evmAddress = null;
        if (accountId.hasAlias()) {
            if (accountId.getAlias().size() == 20) {
                evmAddress = EvmAddress.fromAliasBytes(accountId.getAlias());
            } else {
                aliasKey = PublicKey.fromAliasBytes(accountId.getAlias());
            }
        }
        Objects.requireNonNull(accountId);
        return new AccountId(accountId.getShardNum(), accountId.getRealmNum(), accountId.getAccountNum(), null, aliasKey, evmAddress);
    }

    public static AccountId fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return AccountId.fromProtobuf((AccountID)((AccountID.Builder)AccountID.parseFrom(bytes).toBuilder()).build());
    }

    public String toSolidityAddress() {
        return EntityIdHelper.toSolidityAddress(this.shard, this.realm, this.num);
    }

    AccountID toProtobuf() {
        AccountID.Builder accountIdBuilder = AccountID.newBuilder().setShardNum(this.shard).setRealmNum(this.realm);
        if (this.aliasKey != null) {
            accountIdBuilder.setAlias(this.aliasKey.toProtobufKey().toByteString());
        } else if (this.evmAddress != null) {
            accountIdBuilder.setAlias(ByteString.copyFrom((byte[])this.evmAddress.toBytes()));
        } else {
            accountIdBuilder.setAccountNum(this.num);
        }
        return (AccountID)accountIdBuilder.build();
    }

    public AccountId populateAccountNum(Client client) throws InterruptedException, ExecutionException {
        return this.populateAccountNumAsync(client).get();
    }

    public CompletableFuture<AccountId> populateAccountNumAsync(Client client) {
        return EntityIdHelper.getAccountNumFromMirrorNodeAsync(client, this.evmAddress.toString()).thenApply(accountNumFromMirrorNode -> new AccountId(this.shard, this.realm, (long)accountNumFromMirrorNode, this.checksum, this.aliasKey, this.evmAddress));
    }

    public AccountId populateAccountEvmAddress(Client client) throws ExecutionException, InterruptedException {
        return this.populateAccountEvmAddressAsync(client).get();
    }

    public CompletableFuture<AccountId> populateAccountEvmAddressAsync(Client client) {
        return EntityIdHelper.getEvmAddressFromMirrorNodeAsync(client, this.num).thenApply(evmAddressFromMirrorNode -> new AccountId(this.shard, this.realm, this.num, this.checksum, this.aliasKey, (EvmAddress)evmAddressFromMirrorNode));
    }

    @Deprecated
    public void validate(Client client) throws BadEntityIdException {
        this.validateChecksum(client);
    }

    public void validateChecksum(Client client) throws BadEntityIdException {
        if (this.aliasKey == null && this.evmAddress == null) {
            EntityIdHelper.validate(this.shard, this.realm, this.num, client, this.checksum);
        }
    }

    @Nullable
    public String getChecksum() {
        return this.checksum;
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }

    public String toString() {
        if (this.aliasKey != null) {
            return this.shard + "." + this.realm + "." + this.aliasKey.toStringDER();
        }
        if (this.evmAddress != null) {
            return this.shard + "." + this.realm + "." + this.evmAddress.toString();
        }
        return EntityIdHelper.toString(this.shard, this.realm, this.num);
    }

    public String toStringWithChecksum(Client client) {
        if (this.aliasKey != null || this.evmAddress != null) {
            throw new IllegalStateException("toStringWithChecksum cannot be applied to AccountId with aliasKey or evmAddress");
        }
        return EntityIdHelper.toStringWithChecksum(this.shard, this.realm, this.num, client, this.checksum);
    }

    public int hashCode() {
        byte[] aliasBytes = null;
        if (this.aliasKey != null) {
            aliasBytes = this.aliasKey.toBytes();
        } else if (this.evmAddress != null) {
            aliasBytes = this.evmAddress.toBytes();
        }
        return Objects.hash(this.shard, this.realm, this.num, Arrays.hashCode(aliasBytes));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AccountId)) {
            return false;
        }
        AccountId otherId = (AccountId)o;
        if (this.aliasKey == null != (otherId.aliasKey == null)) {
            return false;
        }
        if (this.evmAddress == null != (otherId.evmAddress == null)) {
            return false;
        }
        return !(this.shard != otherId.shard || this.realm != otherId.realm || this.num != otherId.num || this.aliasKey != null && !this.aliasKey.equals(otherId.aliasKey) || this.evmAddress != null && !this.evmAddress.equals(otherId.evmAddress));
    }

    @Override
    public int compareTo(AccountId o) {
        Objects.requireNonNull(o);
        int shardComparison = Long.compare(this.shard, o.shard);
        if (shardComparison != 0) {
            return shardComparison;
        }
        int realmComparison = Long.compare(this.realm, o.realm);
        if (realmComparison != 0) {
            return realmComparison;
        }
        int numComparison = Long.compare(this.num, o.num);
        if (numComparison != 0) {
            return numComparison;
        }
        if (this.aliasKey == null != (o.aliasKey == null)) {
            return this.aliasKey != null ? 1 : -1;
        }
        if (this.aliasKey != null) {
            return this.aliasKey.toStringDER().compareTo(o.aliasKey.toStringDER());
        }
        if (this.evmAddress == null != (o.evmAddress == null)) {
            return this.evmAddress != null ? 1 : -1;
        }
        if (this.evmAddress == null) {
            return 0;
        }
        return this.evmAddress.toString().compareTo(o.evmAddress.toString());
    }
}

