/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.CustomFeeBase;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.proto.CustomFee;
import com.hedera.hashgraph.sdk.proto.FixedFee;
import javax.annotation.Nullable;

public class CustomFixedFee
extends CustomFeeBase<CustomFixedFee> {
    private long amount = 0L;
    @Nullable
    private TokenId denominatingTokenId = null;

    static CustomFixedFee fromProtobuf(FixedFee fixedFee) {
        CustomFixedFee returnFee = new CustomFixedFee().setAmount(fixedFee.getAmount());
        if (fixedFee.hasDenominatingTokenId()) {
            returnFee.setDenominatingTokenId(TokenId.fromProtobuf(fixedFee.getDenominatingTokenId()));
        }
        return returnFee;
    }

    @Override
    CustomFixedFee deepCloneSubclass() {
        return new CustomFixedFee().setAmount(this.amount).setDenominatingTokenId(this.denominatingTokenId).finishDeepClone(this);
    }

    public long getAmount() {
        return this.amount;
    }

    public CustomFixedFee setAmount(long amount) {
        this.amount = amount;
        return this;
    }

    public Hbar getHbarAmount() {
        return Hbar.fromTinybars(this.amount);
    }

    public CustomFixedFee setHbarAmount(Hbar amount) {
        this.denominatingTokenId = null;
        this.amount = amount.toTinybars();
        return this;
    }

    @Nullable
    public TokenId getDenominatingTokenId() {
        return this.denominatingTokenId;
    }

    public CustomFixedFee setDenominatingTokenId(@Nullable TokenId tokenId) {
        this.denominatingTokenId = tokenId;
        return this;
    }

    public CustomFixedFee setDenominatingTokenToSameToken() {
        this.denominatingTokenId = new TokenId(0L, 0L, 0L);
        return this;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        super.validateChecksums(client);
        if (this.denominatingTokenId != null) {
            this.denominatingTokenId.validateChecksum(client);
        }
    }

    public String toString() {
        return this.toStringHelper().add("amount", this.getAmount()).add("demoninatingTokenId", (Object)this.getDenominatingTokenId()).toString();
    }

    FixedFee toFixedFeeProtobuf() {
        FixedFee.Builder fixedFeeBuilder = FixedFee.newBuilder().setAmount(this.getAmount());
        if (this.getDenominatingTokenId() != null) {
            fixedFeeBuilder.setDenominatingTokenId(this.getDenominatingTokenId().toProtobuf());
        }
        return (FixedFee)fixedFeeBuilder.build();
    }

    @Override
    CustomFee toProtobuf() {
        CustomFee.Builder customFeeBuilder = CustomFee.newBuilder().setFixedFee(this.toFixedFeeProtobuf());
        return this.finishToProtobuf(customFeeBuilder);
    }
}

