/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class LockableList<T>
implements Iterable<T> {
    private ArrayList<T> list = new ArrayList();
    private int index = 0;
    private boolean locked = false;

    LockableList() {
    }

    LockableList(ArrayList<T> list) {
        this.list = list;
    }

    void requireNotLocked() {
        if (this.locked) {
            throw new IllegalStateException("Cannot modify a locked list");
        }
    }

    LockableList<T> ensureCapacity(int capacity) {
        this.list.ensureCapacity(capacity);
        return this;
    }

    LockableList<T> setList(List<T> list) {
        this.requireNotLocked();
        this.list = new ArrayList<T>(list);
        this.index = 0;
        return this;
    }

    ArrayList<T> getList() {
        return this.list;
    }

    LockableList<T> add(T ... elements) {
        this.requireNotLocked();
        for (T e : elements) {
            this.list.add(e);
        }
        return this;
    }

    LockableList<T> addAll(Collection<? extends T> elements) {
        this.requireNotLocked();
        this.list.addAll(elements);
        return this;
    }

    public LockableList<T> shuffle() {
        this.requireNotLocked();
        Collections.shuffle(this.list);
        return this;
    }

    LockableList<T> remove(T element) {
        this.requireNotLocked();
        this.list.remove(element);
        return this;
    }

    T getCurrent() {
        return this.get(this.index);
    }

    T getNext() {
        return this.get(this.advance());
    }

    T get(int index) {
        return this.list.get(index);
    }

    LockableList<T> set(int index, T item) {
        this.requireNotLocked();
        if (index == this.list.size()) {
            this.list.add(item);
        } else {
            this.list.set(index, item);
        }
        return this;
    }

    LockableList<T> setIfAbsent(int index, T item) {
        if (index == this.list.size() || this.list.get(index) == null) {
            this.set(index, item);
        }
        return this;
    }

    int advance() {
        int index = this.index;
        this.index = (this.index + 1) % this.list.size();
        return index;
    }

    boolean isEmpty() {
        return this.list.isEmpty();
    }

    boolean isLocked() {
        return this.locked;
    }

    LockableList<T> setLocked(boolean locked) {
        this.locked = locked;
        return this;
    }

    int size() {
        return this.list.size();
    }

    LockableList<T> setIndex(int index) {
        this.index = index;
        return this;
    }

    int getIndex() {
        return this.index;
    }

    LockableList<T> clear() {
        this.requireNotLocked();
        this.list.clear();
        return this;
    }

    @Override
    public Iterator<T> iterator() {
        return this.list.iterator();
    }
}

