/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Mnemonic;
import com.hedera.hashgraph.sdk.Pem;
import com.hedera.hashgraph.sdk.PrivateKeyECDSA;
import com.hedera.hashgraph.sdk.PrivateKeyED25519;
import com.hedera.hashgraph.sdk.PublicKey;
import com.hedera.hashgraph.sdk.Transaction;
import com.hedera.hashgraph.sdk.proto.Key;
import com.hedera.hashgraph.sdk.proto.SignedTransaction;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.util.encoders.Hex;

public abstract class PrivateKey
extends com.hedera.hashgraph.sdk.Key {
    @Nullable
    protected PublicKey publicKey = null;

    public static PrivateKey generate() {
        return PrivateKey.generateED25519();
    }

    public static PrivateKey generateED25519() {
        return PrivateKeyED25519.generateInternal();
    }

    public static PrivateKey generateECDSA() {
        return PrivateKeyECDSA.generateInternal();
    }

    public static PrivateKey fromSeedED25519(byte[] seed) {
        return PrivateKeyED25519.fromSeed(seed);
    }

    public static PrivateKey fromSeedECDSAsecp256k1(byte[] seed) {
        return PrivateKeyECDSA.fromSeed(seed);
    }

    @Deprecated
    public static PrivateKey fromMnemonic(Mnemonic mnemonic, String passphrase) {
        byte[] seed = mnemonic.toSeed(passphrase);
        PrivateKey derivedKey = PrivateKey.fromSeedED25519(seed);
        for (int index : new int[]{44, 3030, 0, 0}) {
            derivedKey = derivedKey.derive(index);
        }
        return derivedKey;
    }

    @Deprecated
    public static PrivateKey fromMnemonic(Mnemonic mnemonic) {
        return PrivateKey.fromMnemonic(mnemonic, "");
    }

    public static PrivateKey fromString(String privateKey) {
        return PrivateKey.fromBytes(Hex.decode((String)(privateKey.startsWith("0x") ? privateKey.substring(2) : privateKey)));
    }

    public static PrivateKey fromStringDER(String privateKey) {
        return PrivateKey.fromBytesDER(Hex.decode((String)privateKey));
    }

    public static PrivateKey fromStringED25519(String privateKey) {
        return PrivateKey.fromBytesED25519(Hex.decode((String)privateKey));
    }

    public static PrivateKey fromStringECDSA(String privateKey) {
        return PrivateKey.fromBytesECDSA(Hex.decode((String)privateKey));
    }

    public static PrivateKey fromBytes(byte[] privateKey) {
        if (privateKey.length == 32 || privateKey.length == 64) {
            return new PrivateKeyED25519(Arrays.copyOfRange(privateKey, 0, 32), null);
        }
        return PrivateKey.fromBytesDER(privateKey);
    }

    public static PrivateKey fromBytesED25519(byte[] privateKey) {
        return PrivateKeyED25519.fromBytesInternal(privateKey);
    }

    public static PrivateKey fromBytesECDSA(byte[] privateKey) {
        return PrivateKeyECDSA.fromBytesInternal(privateKey);
    }

    public static PrivateKey fromBytesDER(byte[] privateKey) {
        try {
            return PrivateKey.fromPrivateKeyInfo(PrivateKeyInfo.getInstance((Object)privateKey));
        }
        catch (ClassCastException | IllegalArgumentException e) {
            return PrivateKeyECDSA.fromECPrivateKeyInternal(ECPrivateKey.getInstance((Object)privateKey));
        }
    }

    private static PrivateKey fromPrivateKeyInfo(PrivateKeyInfo privateKeyInfo) {
        if (privateKeyInfo.getPrivateKeyAlgorithm().equals((Object)new AlgorithmIdentifier(ID_ED25519))) {
            return PrivateKeyED25519.fromPrivateKeyInfoInternal(privateKeyInfo);
        }
        return PrivateKeyECDSA.fromPrivateKeyInfoInternal(privateKeyInfo);
    }

    public static PrivateKey readPem(Reader pemFile) throws IOException {
        return PrivateKey.readPem(pemFile, null);
    }

    public static PrivateKey readPem(Reader pemFile, @Nullable String password) throws IOException {
        return PrivateKey.fromPrivateKeyInfo(Pem.readPrivateKey(pemFile, password));
    }

    public static PrivateKey fromPem(String pemEncoded) throws IOException {
        return PrivateKey.readPem(new StringReader(pemEncoded));
    }

    public static PrivateKey fromPem(String encodedPem, @Nullable String password) throws IOException {
        return PrivateKey.readPem(new StringReader(encodedPem), password);
    }

    public PrivateKey legacyDerive(int index) {
        return this.legacyDerive((long)index);
    }

    public abstract PrivateKey legacyDerive(long var1);

    public abstract boolean isDerivable();

    public abstract PrivateKey derive(int var1);

    public abstract PublicKey getPublicKey();

    public abstract byte[] sign(byte[] var1);

    public byte[] signTransaction(Transaction<?> transaction) {
        transaction.requireOneNodeAccountId();
        if (!transaction.isFrozen()) {
            transaction.freeze();
        }
        SignedTransaction.Builder builder = transaction.innerSignedTransactions.get(0);
        byte[] signature = this.sign(builder.getBodyBytes().toByteArray());
        transaction.addSignature(this.getPublicKey(), signature);
        return signature;
    }

    @Override
    public abstract byte[] toBytes();

    public abstract byte[] toBytesDER();

    public abstract byte[] toBytesRaw();

    public String toString() {
        return this.toStringDER();
    }

    public String toStringDER() {
        return Hex.toHexString((byte[])this.toBytesDER());
    }

    public String toStringRaw() {
        return Hex.toHexString((byte[])this.toBytesRaw());
    }

    public AccountId toAccountId(@Nonnegative long shard, @Nonnegative long realm) {
        return this.getPublicKey().toAccountId(shard, realm);
    }

    @Override
    Key toProtobufKey() {
        return this.getPublicKey().toProtobufKey();
    }

    public abstract boolean isED25519();

    public abstract boolean isECDSA();

    public abstract KeyParameter getChainCode();
}

