/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.HederaFunctionality;

public enum RequestType {
    NONE(HederaFunctionality.NONE),
    CRYPTO_TRANSFER(HederaFunctionality.CryptoTransfer),
    CRYPTO_UPDATE(HederaFunctionality.CryptoUpdate),
    CRYPTO_DELETE(HederaFunctionality.CryptoDelete),
    CRYPTO_ADD_LIVE_HASH(HederaFunctionality.CryptoAddLiveHash),
    CRYPTO_DELETE_LIVE_HASH(HederaFunctionality.CryptoDeleteLiveHash),
    CONTRACT_CALL(HederaFunctionality.ContractCall),
    CONTRACT_CREATE(HederaFunctionality.ContractCreate),
    CONTRACT_UPDATE(HederaFunctionality.ContractUpdate),
    FILE_CREATE(HederaFunctionality.FileCreate),
    FILE_APPEND(HederaFunctionality.FileAppend),
    FILE_UPDATE(HederaFunctionality.FileUpdate),
    FILE_DELETE(HederaFunctionality.FileDelete),
    CRYPTO_GET_ACCOUNT_BALANCE(HederaFunctionality.CryptoGetAccountBalance),
    CRYPTO_GET_ACCOUNT_RECORDS(HederaFunctionality.CryptoGetAccountRecords),
    CRYPTO_GET_INFO(HederaFunctionality.CryptoGetInfo),
    CONTRACT_CALL_LOCAL(HederaFunctionality.ContractCallLocal),
    CONTRACT_GET_INFO(HederaFunctionality.ContractGetInfo),
    CONTRACT_GET_BYTECODE(HederaFunctionality.ContractGetBytecode),
    GET_BY_SOLIDITY_ID(HederaFunctionality.GetBySolidityID),
    GET_BY_KEY(HederaFunctionality.GetByKey),
    CRYPTO_GET_LIVE_HASH(HederaFunctionality.CryptoGetLiveHash),
    CRYPTO_GET_STAKERS(HederaFunctionality.CryptoGetStakers),
    FILE_GET_CONTENTS(HederaFunctionality.FileGetContents),
    FILE_GET_INFO(HederaFunctionality.FileGetInfo),
    TRANSACTION_GET_RECORD(HederaFunctionality.TransactionGetRecord),
    CONTRACT_GET_RECORDS(HederaFunctionality.ContractGetRecords),
    CRYPTO_CREATE(HederaFunctionality.CryptoCreate),
    SYSTEM_DELETE(HederaFunctionality.SystemDelete),
    SYSTEM_UNDELETE(HederaFunctionality.SystemUndelete),
    CONTRACT_DELETE(HederaFunctionality.ContractDelete),
    FREEZE(HederaFunctionality.Freeze),
    CREATE_TRANSACTION_RECORD(HederaFunctionality.CreateTransactionRecord),
    CRYPTO_ACCOUNT_AUTO_RENEW(HederaFunctionality.CryptoAccountAutoRenew),
    CONTRACT_AUTO_RENEW(HederaFunctionality.ContractAutoRenew),
    GET_VERSION_INFO(HederaFunctionality.GetVersionInfo),
    TRANSACTION_GET_RECEIPT(HederaFunctionality.TransactionGetReceipt),
    CONSENSUS_CREATE_TOPIC(HederaFunctionality.ConsensusCreateTopic),
    CONSENSUS_UPDATE_TOPIC(HederaFunctionality.ConsensusUpdateTopic),
    CONSENSUS_DELETE_TOPIC(HederaFunctionality.ConsensusDeleteTopic),
    CONSENSUS_GET_TOPIC_INFO(HederaFunctionality.ConsensusGetTopicInfo),
    CONSENSUS_SUBMIT_MESSAGE(HederaFunctionality.ConsensusSubmitMessage),
    UNCHECKED_SUBMIT(HederaFunctionality.UncheckedSubmit),
    TOKEN_CREATE(HederaFunctionality.TokenCreate),
    TOKEN_GET_INFO(HederaFunctionality.TokenGetInfo),
    TOKEN_FREEZE_ACCOUNT(HederaFunctionality.TokenFreezeAccount),
    TOKEN_UNFREEZE_ACCOUNT(HederaFunctionality.TokenUnfreezeAccount),
    TOKEN_GRANT_KYC_TO_ACCOUNT(HederaFunctionality.TokenGrantKycToAccount),
    TOKEN_REVOKE_KYC_FROM_ACCOUNT(HederaFunctionality.TokenRevokeKycFromAccount),
    TOKEN_DELETE(HederaFunctionality.TokenDelete),
    TOKEN_UPDATE(HederaFunctionality.TokenUpdate),
    TOKEN_MINT(HederaFunctionality.TokenMint),
    TOKEN_BURN(HederaFunctionality.TokenBurn),
    TOKEN_ACCOUNT_WIPE(HederaFunctionality.TokenAccountWipe),
    TOKEN_ASSOCIATE_TO_ACCOUNT(HederaFunctionality.TokenAssociateToAccount),
    TOKEN_DISSOCIATE_FROM_ACCOUNT(HederaFunctionality.TokenDissociateFromAccount),
    SCHEDULE_CREATE(HederaFunctionality.ScheduleCreate),
    SCHEDULE_DELETE(HederaFunctionality.ScheduleDelete),
    SCHEDULE_SIGN(HederaFunctionality.ScheduleSign),
    SCHEDULE_GET_INFO(HederaFunctionality.ScheduleGetInfo),
    TOKEN_GET_ACCOUNT_NFT_INFOS(HederaFunctionality.TokenGetAccountNftInfos),
    TOKEN_GET_NFT_INFO(HederaFunctionality.TokenGetNftInfo),
    TOKEN_GET_NFT_INFOS(HederaFunctionality.TokenGetNftInfos),
    TOKEN_FEE_SCHEDULE_UPDATE(HederaFunctionality.TokenFeeScheduleUpdate),
    NETWORK_GET_EXECUTION_TIME(HederaFunctionality.NetworkGetExecutionTime),
    TOKEN_PAUSE(HederaFunctionality.TokenPause),
    TOKEN_UNPAUSE(HederaFunctionality.TokenUnpause),
    CRYPTO_APPROVE_ALLOWANCE(HederaFunctionality.CryptoApproveAllowance),
    CRYPTO_DELETE_ALLOWANCE(HederaFunctionality.CryptoDeleteAllowance),
    GET_ACCOUNT_DETAILS(HederaFunctionality.GetAccountDetails),
    ETHEREUM_TRANSACTION(HederaFunctionality.EthereumTransaction),
    NODE_STAKE_UPDATE(HederaFunctionality.NodeStakeUpdate),
    PRNG(HederaFunctionality.UtilPrng);

    final HederaFunctionality code;

    private RequestType(HederaFunctionality code) {
        this.code = code;
    }

    static RequestType valueOf(HederaFunctionality code) {
        return switch (code) {
            case HederaFunctionality.NONE -> NONE;
            case HederaFunctionality.CryptoTransfer -> CRYPTO_TRANSFER;
            case HederaFunctionality.CryptoUpdate -> CRYPTO_UPDATE;
            case HederaFunctionality.CryptoDelete -> CRYPTO_DELETE;
            case HederaFunctionality.CryptoAddLiveHash -> CRYPTO_ADD_LIVE_HASH;
            case HederaFunctionality.CryptoDeleteLiveHash -> CRYPTO_DELETE_LIVE_HASH;
            case HederaFunctionality.ContractCall -> CONTRACT_CALL;
            case HederaFunctionality.ContractCreate -> CONTRACT_CREATE;
            case HederaFunctionality.ContractUpdate -> CONTRACT_UPDATE;
            case HederaFunctionality.FileCreate -> FILE_CREATE;
            case HederaFunctionality.FileAppend -> FILE_APPEND;
            case HederaFunctionality.FileUpdate -> FILE_UPDATE;
            case HederaFunctionality.FileDelete -> FILE_DELETE;
            case HederaFunctionality.CryptoGetAccountBalance -> CRYPTO_GET_ACCOUNT_BALANCE;
            case HederaFunctionality.CryptoGetAccountRecords -> CRYPTO_GET_ACCOUNT_RECORDS;
            case HederaFunctionality.CryptoGetInfo -> CRYPTO_GET_INFO;
            case HederaFunctionality.ContractCallLocal -> CONTRACT_CALL_LOCAL;
            case HederaFunctionality.ContractGetInfo -> CONTRACT_GET_INFO;
            case HederaFunctionality.ContractGetBytecode -> CONTRACT_GET_BYTECODE;
            case HederaFunctionality.GetBySolidityID -> GET_BY_SOLIDITY_ID;
            case HederaFunctionality.GetByKey -> GET_BY_KEY;
            case HederaFunctionality.CryptoGetLiveHash -> CRYPTO_GET_LIVE_HASH;
            case HederaFunctionality.CryptoGetStakers -> CRYPTO_GET_STAKERS;
            case HederaFunctionality.FileGetContents -> FILE_GET_CONTENTS;
            case HederaFunctionality.FileGetInfo -> FILE_GET_INFO;
            case HederaFunctionality.TransactionGetRecord -> TRANSACTION_GET_RECORD;
            case HederaFunctionality.ContractGetRecords -> CONTRACT_GET_RECORDS;
            case HederaFunctionality.CryptoCreate -> CRYPTO_CREATE;
            case HederaFunctionality.SystemDelete -> SYSTEM_DELETE;
            case HederaFunctionality.SystemUndelete -> SYSTEM_UNDELETE;
            case HederaFunctionality.ContractDelete -> CONTRACT_DELETE;
            case HederaFunctionality.Freeze -> FREEZE;
            case HederaFunctionality.CreateTransactionRecord -> CREATE_TRANSACTION_RECORD;
            case HederaFunctionality.CryptoAccountAutoRenew -> CRYPTO_ACCOUNT_AUTO_RENEW;
            case HederaFunctionality.ContractAutoRenew -> CONTRACT_AUTO_RENEW;
            case HederaFunctionality.GetVersionInfo -> GET_VERSION_INFO;
            case HederaFunctionality.TransactionGetReceipt -> TRANSACTION_GET_RECEIPT;
            case HederaFunctionality.ConsensusCreateTopic -> CONSENSUS_CREATE_TOPIC;
            case HederaFunctionality.ConsensusUpdateTopic -> CONSENSUS_UPDATE_TOPIC;
            case HederaFunctionality.ConsensusDeleteTopic -> CONSENSUS_DELETE_TOPIC;
            case HederaFunctionality.ConsensusGetTopicInfo -> CONSENSUS_GET_TOPIC_INFO;
            case HederaFunctionality.ConsensusSubmitMessage -> CONSENSUS_SUBMIT_MESSAGE;
            case HederaFunctionality.UncheckedSubmit -> UNCHECKED_SUBMIT;
            case HederaFunctionality.TokenCreate -> TOKEN_CREATE;
            case HederaFunctionality.TokenGetInfo -> TOKEN_GET_INFO;
            case HederaFunctionality.TokenFreezeAccount -> TOKEN_FREEZE_ACCOUNT;
            case HederaFunctionality.TokenUnfreezeAccount -> TOKEN_UNFREEZE_ACCOUNT;
            case HederaFunctionality.TokenGrantKycToAccount -> TOKEN_GRANT_KYC_TO_ACCOUNT;
            case HederaFunctionality.TokenRevokeKycFromAccount -> TOKEN_REVOKE_KYC_FROM_ACCOUNT;
            case HederaFunctionality.TokenDelete -> TOKEN_DELETE;
            case HederaFunctionality.TokenUpdate -> TOKEN_UPDATE;
            case HederaFunctionality.TokenMint -> TOKEN_MINT;
            case HederaFunctionality.TokenBurn -> TOKEN_BURN;
            case HederaFunctionality.TokenAccountWipe -> TOKEN_ACCOUNT_WIPE;
            case HederaFunctionality.TokenAssociateToAccount -> TOKEN_ASSOCIATE_TO_ACCOUNT;
            case HederaFunctionality.TokenDissociateFromAccount -> TOKEN_DISSOCIATE_FROM_ACCOUNT;
            case HederaFunctionality.ScheduleCreate -> SCHEDULE_CREATE;
            case HederaFunctionality.ScheduleDelete -> SCHEDULE_DELETE;
            case HederaFunctionality.ScheduleSign -> SCHEDULE_SIGN;
            case HederaFunctionality.ScheduleGetInfo -> SCHEDULE_GET_INFO;
            case HederaFunctionality.TokenGetAccountNftInfos -> TOKEN_GET_ACCOUNT_NFT_INFOS;
            case HederaFunctionality.TokenGetNftInfo -> TOKEN_GET_NFT_INFO;
            case HederaFunctionality.TokenGetNftInfos -> TOKEN_GET_NFT_INFOS;
            case HederaFunctionality.TokenFeeScheduleUpdate -> TOKEN_FEE_SCHEDULE_UPDATE;
            case HederaFunctionality.NetworkGetExecutionTime -> NETWORK_GET_EXECUTION_TIME;
            case HederaFunctionality.TokenPause -> TOKEN_PAUSE;
            case HederaFunctionality.TokenUnpause -> TOKEN_UNPAUSE;
            case HederaFunctionality.CryptoApproveAllowance -> CRYPTO_APPROVE_ALLOWANCE;
            case HederaFunctionality.CryptoDeleteAllowance -> CRYPTO_DELETE_ALLOWANCE;
            case HederaFunctionality.GetAccountDetails -> GET_ACCOUNT_DETAILS;
            case HederaFunctionality.EthereumTransaction -> ETHEREUM_TRANSACTION;
            case HederaFunctionality.NodeStakeUpdate -> NODE_STAKE_UPDATE;
            case HederaFunctionality.UtilPrng -> PRNG;
            default -> throw new IllegalStateException("(BUG) unhandled HederaFunctionality");
        };
    }

    public String toString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case NONE -> "NONE";
            case CRYPTO_TRANSFER -> "CRYPTO_TRANSFER";
            case CRYPTO_UPDATE -> "CRYPTO_UPDATE";
            case CRYPTO_DELETE -> "CRYPTO_DELETE";
            case CRYPTO_ADD_LIVE_HASH -> "CRYPTO_ADD_LIVE_HASH";
            case CRYPTO_DELETE_LIVE_HASH -> "CRYPTO_DELETE_LIVE_HASH";
            case CONTRACT_CALL -> "CONTRACT_CALL";
            case CONTRACT_CREATE -> "CONTRACT_CREATE";
            case CONTRACT_UPDATE -> "CONTRACT_UPDATE";
            case FILE_CREATE -> "FILE_CREATE";
            case FILE_APPEND -> "FILE_APPEND";
            case FILE_UPDATE -> "FILE_UPDATE";
            case FILE_DELETE -> "FILE_DELETE";
            case CRYPTO_GET_ACCOUNT_BALANCE -> "CRYPTO_GET_ACCOUNT_BALANCE";
            case CRYPTO_GET_ACCOUNT_RECORDS -> "CRYPTO_GET_ACCOUNT_RECORDS";
            case CRYPTO_GET_INFO -> "CRYPTO_GET_INFO";
            case CONTRACT_CALL_LOCAL -> "CONTRACT_CALL_LOCAL";
            case CONTRACT_GET_INFO -> "CONTRACT_GET_INFO";
            case CONTRACT_GET_BYTECODE -> "CONTRACT_GET_BYTECODE";
            case GET_BY_SOLIDITY_ID -> "GET_BY_SOLIDITY_ID";
            case GET_BY_KEY -> "GET_BY_KEY";
            case CRYPTO_GET_LIVE_HASH -> "CRYPTO_GET_LIVE_HASH";
            case CRYPTO_GET_STAKERS -> "CRYPTO_GET_STAKERS";
            case FILE_GET_CONTENTS -> "FILE_GET_CONTENTS";
            case FILE_GET_INFO -> "FILE_GET_INFO";
            case TRANSACTION_GET_RECORD -> "TRANSACTION_GET_RECORD";
            case CONTRACT_GET_RECORDS -> "CONTRACT_GET_RECORDS";
            case CRYPTO_CREATE -> "CRYPTO_CREATE";
            case SYSTEM_DELETE -> "SYSTEM_DELETE";
            case SYSTEM_UNDELETE -> "SYSTEM_UNDELETE";
            case CONTRACT_DELETE -> "CONTRACT_DELETE";
            case FREEZE -> "FREEZE";
            case CREATE_TRANSACTION_RECORD -> "CREATE_TRANSACTION_RECORD";
            case CRYPTO_ACCOUNT_AUTO_RENEW -> "CRYPTO_ACCOUNT_AUTO_RENEW";
            case CONTRACT_AUTO_RENEW -> "CONTRACT_AUTO_RENEW";
            case GET_VERSION_INFO -> "GET_VERSION_INFO";
            case TRANSACTION_GET_RECEIPT -> "TRANSACTION_GET_RECEIPT";
            case CONSENSUS_CREATE_TOPIC -> "CONSENSUS_CREATE_TOPIC";
            case CONSENSUS_UPDATE_TOPIC -> "CONSENSUS_UPDATE_TOPIC";
            case CONSENSUS_DELETE_TOPIC -> "CONSENSUS_DELETE_TOPIC";
            case CONSENSUS_GET_TOPIC_INFO -> "CONSENSUS_GET_TOPIC_INFO";
            case CONSENSUS_SUBMIT_MESSAGE -> "CONSENSUS_SUBMIT_MESSAGE";
            case UNCHECKED_SUBMIT -> "UNCHECKED_SUBMIT";
            case TOKEN_CREATE -> "TOKEN_CREATE";
            case TOKEN_GET_INFO -> "TOKEN_GET_INFO";
            case TOKEN_FREEZE_ACCOUNT -> "TOKEN_FREEZE_ACCOUNT";
            case TOKEN_UNFREEZE_ACCOUNT -> "TOKEN_UNFREEZE_ACCOUNT";
            case TOKEN_GRANT_KYC_TO_ACCOUNT -> "TOKEN_GRANT_KYC_TO_ACCOUNT";
            case TOKEN_REVOKE_KYC_FROM_ACCOUNT -> "TOKEN_REVOKE_KYC_FROM_ACCOUNT";
            case TOKEN_DELETE -> "TOKEN_DELETE";
            case TOKEN_UPDATE -> "TOKEN_UPDATE";
            case TOKEN_MINT -> "TOKEN_MINT";
            case TOKEN_BURN -> "TOKEN_BURN";
            case TOKEN_ACCOUNT_WIPE -> "TOKEN_ACCOUNT_WIPE";
            case TOKEN_ASSOCIATE_TO_ACCOUNT -> "TOKEN_ASSOCIATE_TO_ACCOUNT";
            case TOKEN_DISSOCIATE_FROM_ACCOUNT -> "TOKEN_DISSOCIATE_FROM_ACCOUNT";
            case SCHEDULE_CREATE -> "SCHEDULE_CREATE";
            case SCHEDULE_DELETE -> "SCHEDULE_DELETE";
            case SCHEDULE_SIGN -> "SCHEDULE_SIGN";
            case SCHEDULE_GET_INFO -> "SCHEDULE_GET_INFO";
            case TOKEN_GET_ACCOUNT_NFT_INFOS -> "TOKEN_GET_ACCOUNT_NFT_INFOS";
            case TOKEN_GET_NFT_INFO -> "TOKEN_GET_NFT_INFO";
            case TOKEN_GET_NFT_INFOS -> "TOKEN_GET_NFT_INFOS";
            case TOKEN_FEE_SCHEDULE_UPDATE -> "TOKEN_FEE_SCHEDULE_UPDATE";
            case NETWORK_GET_EXECUTION_TIME -> "NETWORK_GET_EXECUTION_TIME";
            case TOKEN_PAUSE -> "TOKEN_PAUSE";
            case TOKEN_UNPAUSE -> "TOKEN_UNPAUSE";
            case CRYPTO_APPROVE_ALLOWANCE -> "CRYPTO_APPROVE_ALLOWANCE";
            case CRYPTO_DELETE_ALLOWANCE -> "CRYPTO_DELETE_ALLOWANCE";
            case GET_ACCOUNT_DETAILS -> "GET_ACCOUNT_DETAILS";
            case ETHEREUM_TRANSACTION -> "ETHEREUM_TRANSACTION";
            case NODE_STAKE_UPDATE -> "NODE_STAKE_UPDATE";
            case PRNG -> "PRNG";
        };
    }
}

