/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.BoolValue;
import com.google.protobuf.Int32Value;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.StringValue;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BadEntityIdException;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.CryptoServiceGrpc;
import com.hedera.hashgraph.sdk.proto.CryptoUpdateTransactionBody;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.MethodDescriptor;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class AccountUpdateTransaction
extends com.hedera.hashgraph.sdk.Transaction<AccountUpdateTransaction> {
    @Nullable
    private AccountId accountId = null;
    @Nullable
    private AccountId proxyAccountId = null;
    @Nullable
    private Key key = null;
    @Nullable
    private Instant expirationTime = null;
    @Nullable
    private Duration autoRenewPeriod = null;
    @Nullable
    private Boolean receiverSigRequired = null;
    @Nullable
    private String accountMemo = null;
    @Nullable
    private Integer maxAutomaticTokenAssociations = null;
    @Nullable
    private Key aliasKey;
    @Nullable
    private AccountId stakedAccountId = null;
    @Nullable
    private Long stakedNodeId = null;
    @Nullable
    private Boolean declineStakingReward = null;

    public AccountUpdateTransaction() {
    }

    AccountUpdateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    AccountUpdateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    public AccountId getAccountId() {
        return this.accountId;
    }

    public AccountUpdateTransaction setAccountId(AccountId accountId) {
        Objects.requireNonNull(accountId);
        this.requireNotFrozen();
        this.accountId = accountId;
        return this;
    }

    @Nullable
    public Key getKey() {
        return this.key;
    }

    public AccountUpdateTransaction setKey(Key key) {
        Objects.requireNonNull(key);
        this.requireNotFrozen();
        this.key = key;
        return this;
    }

    @Deprecated
    @Nullable
    public Key getAliasKey() {
        return this.aliasKey;
    }

    @Deprecated
    public AccountUpdateTransaction setAliasKey(Key aliasKey) {
        Objects.requireNonNull(aliasKey);
        this.requireNotFrozen();
        this.aliasKey = aliasKey;
        return this;
    }

    @Nullable
    public AccountId getProxyAccountId() {
        return this.proxyAccountId;
    }

    public AccountUpdateTransaction setProxyAccountId(AccountId proxyAccountId) {
        Objects.requireNonNull(proxyAccountId);
        this.requireNotFrozen();
        this.proxyAccountId = proxyAccountId;
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="An instant can't actually be mutated")
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="An Instant can't actually be mutated")
    public AccountUpdateTransaction setExpirationTime(Instant expirationTime) {
        Objects.requireNonNull(expirationTime);
        this.requireNotFrozen();
        this.expirationTime = expirationTime;
        return this;
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="A Duration can't actually be mutated")
    public Duration getAutoRenewPeriod() {
        return this.autoRenewPeriod;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="A Duration can't actually be mutated")
    public AccountUpdateTransaction setAutoRenewPeriod(Duration autoRenewPeriod) {
        Objects.requireNonNull(autoRenewPeriod);
        this.requireNotFrozen();
        this.autoRenewPeriod = autoRenewPeriod;
        return this;
    }

    @Nullable
    public Boolean getReceiverSignatureRequired() {
        return this.receiverSigRequired;
    }

    public AccountUpdateTransaction setReceiverSignatureRequired(boolean receiverSignatureRequired) {
        this.requireNotFrozen();
        this.receiverSigRequired = receiverSignatureRequired;
        return this;
    }

    @Nullable
    public Integer getMaxAutomaticTokenAssociations() {
        return this.maxAutomaticTokenAssociations;
    }

    public AccountUpdateTransaction setMaxAutomaticTokenAssociations(int amount) {
        this.requireNotFrozen();
        this.maxAutomaticTokenAssociations = amount;
        return this;
    }

    @Nullable
    public String getAccountMemo() {
        return this.accountMemo;
    }

    public AccountUpdateTransaction setAccountMemo(String memo) {
        this.requireNotFrozen();
        Objects.requireNonNull(memo);
        this.accountMemo = memo;
        return this;
    }

    public AccountUpdateTransaction clearMemo() {
        this.requireNotFrozen();
        this.accountMemo = "";
        return this;
    }

    @Nullable
    public AccountId getStakedAccountId() {
        return this.stakedAccountId;
    }

    public AccountUpdateTransaction setStakedAccountId(@Nullable AccountId stakedAccountId) {
        this.requireNotFrozen();
        this.stakedAccountId = stakedAccountId;
        this.stakedNodeId = null;
        return this;
    }

    public AccountUpdateTransaction clearStakedAccountId() {
        this.requireNotFrozen();
        this.stakedAccountId = new AccountId(0L);
        this.stakedNodeId = null;
        return this;
    }

    @Nullable
    public Long getStakedNodeId() {
        return this.stakedNodeId;
    }

    public AccountUpdateTransaction setStakedNodeId(@Nullable Long stakedNodeId) {
        this.requireNotFrozen();
        this.stakedNodeId = stakedNodeId;
        this.stakedAccountId = null;
        return this;
    }

    public AccountUpdateTransaction clearStakedNodeId() {
        this.requireNotFrozen();
        this.stakedNodeId = -1L;
        this.stakedAccountId = null;
        return this;
    }

    @Nullable
    public Boolean getDeclineStakingReward() {
        return this.declineStakingReward;
    }

    public AccountUpdateTransaction setDeclineStakingReward(boolean declineStakingReward) {
        this.requireNotFrozen();
        this.declineStakingReward = declineStakingReward;
        return this;
    }

    public AccountUpdateTransaction clearDeclineStakingReward() {
        this.requireNotFrozen();
        this.declineStakingReward = null;
        return this;
    }

    @Override
    void validateChecksums(Client client) throws BadEntityIdException {
        if (this.accountId != null) {
            this.accountId.validateChecksum(client);
        }
        if (this.proxyAccountId != null) {
            this.proxyAccountId.validateChecksum(client);
        }
        if (this.stakedAccountId != null) {
            this.stakedAccountId.validateChecksum(client);
        }
    }

    void initFromTransactionBody() {
        CryptoUpdateTransactionBody body = this.sourceTransactionBody.getCryptoUpdateAccount();
        if (body.hasAccountIDToUpdate()) {
            this.accountId = AccountId.fromProtobuf(body.getAccountIDToUpdate());
        }
        if (body.hasProxyAccountID()) {
            this.proxyAccountId = AccountId.fromProtobuf(body.getProxyAccountID());
        }
        if (body.hasKey()) {
            this.key = Key.fromProtobufKey(body.getKey());
        }
        if (body.hasExpirationTime()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpirationTime());
        }
        if (body.hasAutoRenewPeriod()) {
            this.autoRenewPeriod = DurationConverter.fromProtobuf(body.getAutoRenewPeriod());
        }
        if (body.hasReceiverSigRequiredWrapper()) {
            this.receiverSigRequired = body.getReceiverSigRequiredWrapper().getValue();
        }
        if (body.hasMemo()) {
            this.accountMemo = body.getMemo().getValue();
        }
        if (body.hasMaxAutomaticTokenAssociations()) {
            this.maxAutomaticTokenAssociations = body.getMaxAutomaticTokenAssociations().getValue();
        }
        if (body.hasDeclineReward()) {
            this.declineStakingReward = body.getDeclineReward().getValue();
        }
        if (body.hasStakedAccountId()) {
            this.stakedAccountId = AccountId.fromProtobuf(body.getStakedAccountId());
        }
        if (body.hasStakedNodeId()) {
            this.stakedNodeId = body.getStakedNodeId();
        }
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return CryptoServiceGrpc.getUpdateAccountMethod();
    }

    CryptoUpdateTransactionBody.Builder build() {
        CryptoUpdateTransactionBody.Builder builder = CryptoUpdateTransactionBody.newBuilder();
        if (this.accountId != null) {
            builder.setAccountIDToUpdate(this.accountId.toProtobuf());
        }
        if (this.proxyAccountId != null) {
            builder.setProxyAccountID(this.proxyAccountId.toProtobuf());
        }
        if (this.key != null) {
            builder.setKey(this.key.toProtobufKey());
        }
        if (this.expirationTime != null) {
            builder.setExpirationTime(InstantConverter.toProtobuf(this.expirationTime));
        }
        if (this.autoRenewPeriod != null) {
            builder.setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod));
        }
        if (this.receiverSigRequired != null) {
            builder.setReceiverSigRequiredWrapper(BoolValue.of((boolean)this.receiverSigRequired));
        }
        if (this.accountMemo != null) {
            builder.setMemo(StringValue.of((String)this.accountMemo));
        }
        if (this.maxAutomaticTokenAssociations != null) {
            builder.setMaxAutomaticTokenAssociations(Int32Value.of((int)this.maxAutomaticTokenAssociations));
        }
        if (this.stakedAccountId != null) {
            builder.setStakedAccountId(this.stakedAccountId.toProtobuf());
        } else if (this.stakedNodeId != null) {
            builder.setStakedNodeId(this.stakedNodeId);
        }
        if (this.declineStakingReward != null) {
            builder.setDeclineReward((BoolValue)BoolValue.newBuilder().setValue(this.declineStakingReward.booleanValue()).build());
        }
        return builder;
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setCryptoUpdateAccount(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setCryptoUpdateAccount(this.build());
    }
}

