/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.common.base.MoreObjects;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.ContractId;
import com.hedera.hashgraph.sdk.DurationConverter;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.LedgerId;
import com.hedera.hashgraph.sdk.StakingInfo;
import com.hedera.hashgraph.sdk.TokenId;
import com.hedera.hashgraph.sdk.TokenRelationship;
import com.hedera.hashgraph.sdk.proto.ContractGetInfoResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class ContractInfo {
    public final ContractId contractId;
    public final AccountId accountId;
    public final String contractAccountId;
    @Nullable
    public final Key adminKey;
    public final Instant expirationTime;
    public final Duration autoRenewPeriod;
    @Nullable
    public final AccountId autoRenewAccountId;
    public final long storage;
    public final String contractMemo;
    public final Hbar balance;
    public final boolean isDeleted;
    @Deprecated
    public final Map<TokenId, TokenRelationship> tokenRelationships;
    public final LedgerId ledgerId;
    @Nullable
    public final StakingInfo stakingInfo;

    private ContractInfo(ContractId contractId, AccountId accountId, String contractAccountId, @Nullable Key adminKey, Instant expirationTime, Duration autoRenewPeriod, @Nullable AccountId autoRenewAccountId, long storage, String contractMemo, Hbar balance, boolean isDeleted, Map<TokenId, TokenRelationship> tokenRelationships, LedgerId ledgerId, @Nullable StakingInfo stakingInfo) {
        this.contractId = contractId;
        this.accountId = accountId;
        this.contractAccountId = contractAccountId;
        this.adminKey = adminKey;
        this.expirationTime = expirationTime;
        this.autoRenewPeriod = autoRenewPeriod;
        this.autoRenewAccountId = autoRenewAccountId;
        this.storage = storage;
        this.contractMemo = contractMemo;
        this.balance = balance;
        this.isDeleted = isDeleted;
        this.tokenRelationships = tokenRelationships;
        this.ledgerId = ledgerId;
        this.stakingInfo = stakingInfo;
    }

    static ContractInfo fromProtobuf(ContractGetInfoResponse.ContractInfo contractInfo) {
        Key adminKey = contractInfo.hasAdminKey() ? Key.fromProtobufKey(contractInfo.getAdminKey()) : null;
        HashMap<TokenId, TokenRelationship> tokenRelationships = new HashMap<TokenId, TokenRelationship>(contractInfo.getTokenRelationshipsCount());
        for (com.hedera.hashgraph.sdk.proto.TokenRelationship relationship : contractInfo.getTokenRelationshipsList()) {
            tokenRelationships.put(TokenId.fromProtobuf(relationship.getTokenId()), TokenRelationship.fromProtobuf(relationship));
        }
        return new ContractInfo(ContractId.fromProtobuf(contractInfo.getContractID()), AccountId.fromProtobuf(contractInfo.getAccountID()), contractInfo.getContractAccountID(), adminKey, InstantConverter.fromProtobuf(contractInfo.getExpirationTime()), DurationConverter.fromProtobuf(contractInfo.getAutoRenewPeriod()), contractInfo.hasAutoRenewAccountId() ? AccountId.fromProtobuf(contractInfo.getAutoRenewAccountId()) : null, contractInfo.getStorage(), contractInfo.getMemo(), Hbar.fromTinybars(contractInfo.getBalance()), contractInfo.getDeleted(), tokenRelationships, LedgerId.fromByteString(contractInfo.getLedgerId()), contractInfo.hasStakingInfo() ? StakingInfo.fromProtobuf(contractInfo.getStakingInfo()) : null);
    }

    public static ContractInfo fromBytes(byte[] bytes) throws InvalidProtocolBufferException {
        return ContractInfo.fromProtobuf((ContractGetInfoResponse.ContractInfo)((ContractGetInfoResponse.ContractInfo.Builder)ContractGetInfoResponse.ContractInfo.parseFrom(bytes).toBuilder()).build());
    }

    ContractGetInfoResponse.ContractInfo toProtobuf() {
        ContractGetInfoResponse.ContractInfo.Builder contractInfoBuilder = ContractGetInfoResponse.ContractInfo.newBuilder().setContractID(this.contractId.toProtobuf()).setAccountID(this.accountId.toProtobuf()).setContractAccountID(this.contractAccountId).setExpirationTime(InstantConverter.toProtobuf(this.expirationTime)).setAutoRenewPeriod(DurationConverter.toProtobuf(this.autoRenewPeriod)).setStorage(this.storage).setMemo(this.contractMemo).setBalance(this.balance.toTinybars()).setLedgerId(this.ledgerId.toByteString());
        if (this.adminKey != null) {
            contractInfoBuilder.setAdminKey(this.adminKey.toProtobufKey());
        }
        if (this.stakingInfo != null) {
            contractInfoBuilder.setStakingInfo(this.stakingInfo.toProtobuf());
        }
        if (this.autoRenewAccountId != null) {
            contractInfoBuilder.setAutoRenewAccountId(this.autoRenewAccountId.toProtobuf());
        }
        return (ContractGetInfoResponse.ContractInfo)contractInfoBuilder.build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("contractId", (Object)this.contractId).add("accountId", (Object)this.accountId).add("contractAccountId", (Object)this.contractAccountId).add("adminKey", (Object)this.adminKey).add("expirationTime", (Object)this.expirationTime).add("autoRenewPeriod", (Object)this.autoRenewPeriod).add("autoRenewAccountId", (Object)this.autoRenewAccountId).add("storage", this.storage).add("contractMemo", (Object)this.contractMemo).add("balance", (Object)this.balance).add("isDeleted", this.isDeleted).add("tokenRelationships", this.tokenRelationships).add("ledgerId", (Object)this.ledgerId).add("stakingInfo", (Object)this.stakingInfo).toString();
    }

    public byte[] toBytes() {
        return this.toProtobuf().toByteArray();
    }
}

