/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.ThreadLocalSecureRandom;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;

final class Crypto {
    static final int IV_LEN = 16;
    static final int ITERATIONS = 262144;
    static final int SALT_LEN = 32;
    static final int DK_LEN = 32;
    static final int CBC_DK_LEN = 16;
    static final X9ECParameters ECDSA_SECP256K1_CURVE = SECNamedCurves.getByName((String)"secp256k1");
    static final ECDomainParameters ECDSA_SECP256K1_DOMAIN = new ECDomainParameters(ECDSA_SECP256K1_CURVE.getCurve(), ECDSA_SECP256K1_CURVE.getG(), ECDSA_SECP256K1_CURVE.getN(), ECDSA_SECP256K1_CURVE.getH());

    private Crypto() {
    }

    static KeyParameter deriveKeySha256(String passphrase, byte[] salt, int iterations, int dkLenBytes) {
        PKCS5S2ParametersGenerator gen = new PKCS5S2ParametersGenerator((Digest)new SHA256Digest());
        gen.init(passphrase.getBytes(StandardCharsets.UTF_8), salt, iterations);
        return (KeyParameter)gen.generateDerivedParameters(dkLenBytes * 8);
    }

    static Cipher initAesCtr128(KeyParameter cipherKey, byte[] iv, boolean forDecrypt) {
        Cipher aesCipher;
        try {
            aesCipher = Cipher.getInstance("AES/CTR/NOPADDING");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new Error("platform does not support AES-CTR ciphers", e);
        }
        return Crypto.initAesCipher(aesCipher, cipherKey, iv, forDecrypt);
    }

    static Cipher initAesCbc128Encrypt(KeyParameter cipherKey, byte[] iv) {
        Cipher aesCipher;
        try {
            aesCipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new Error("platform does not support AES-CBC ciphers", e);
        }
        return Crypto.initAesCipher(aesCipher, cipherKey, iv, false);
    }

    static Cipher initAesCbc128Decrypt(KeyParameter cipherKey, AlgorithmParameters parameters) {
        Cipher aesCipher;
        try {
            aesCipher = Cipher.getInstance("AES/CBC/NoPadding");
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new Error("platform does not support AES-CBC ciphers", e);
        }
        try {
            aesCipher.init(2, (Key)new SecretKeySpec(cipherKey.getKey(), 0, 16, "AES"), parameters);
        }
        catch (InvalidKeyException e) {
            throw new Error("platform does not support AES-128 ciphers", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Error(e);
        }
        return aesCipher;
    }

    private static Cipher initAesCipher(Cipher aesCipher, KeyParameter cipherKey, byte[] iv, boolean forDecrypt) {
        int mode = forDecrypt ? 2 : 1;
        try {
            aesCipher.init(mode, (Key)new SecretKeySpec(cipherKey.getKey(), 0, 16, "AES"), new IvParameterSpec(iv));
        }
        catch (InvalidKeyException e) {
            throw new Error("platform does not support AES-128 ciphers", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new Error(e);
        }
        return aesCipher;
    }

    static byte[] encryptAesCtr128(KeyParameter cipherKey, byte[] iv, byte[] input) {
        Cipher aesCipher = Crypto.initAesCtr128(cipherKey, iv, false);
        return Crypto.runCipher(aesCipher, input);
    }

    static byte[] decryptAesCtr128(KeyParameter cipherKey, byte[] iv, byte[] input) {
        Cipher aesCipher = Crypto.initAesCtr128(cipherKey, iv, true);
        return Crypto.runCipher(aesCipher, input);
    }

    static byte[] runCipher(Cipher cipher, byte[] input) {
        byte[] output = new byte[cipher.getOutputSize(input.length)];
        try {
            cipher.doFinal(input, 0, input.length, output);
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw new Error(e);
        }
        return output;
    }

    static byte[] calcHmacSha384(KeyParameter cipherKey, @Nullable byte[] iv, byte[] input) {
        HMac hmacSha384 = new HMac((Digest)new SHA384Digest());
        byte[] output = new byte[hmacSha384.getMacSize()];
        hmacSha384.init((CipherParameters)new KeyParameter(cipherKey.getKey(), 16, 16));
        if (iv != null) {
            hmacSha384.update(iv, 0, iv.length);
        }
        hmacSha384.update(input, 0, input.length);
        hmacSha384.doFinal(output, 0);
        return output;
    }

    static byte[] calcKeccak256(byte[] message) {
        Keccak.Digest256 digest = new Keccak.Digest256();
        digest.update(message);
        return digest.digest();
    }

    static byte[] randomBytes(int len) {
        byte[] out = new byte[len];
        ThreadLocalSecureRandom.current().nextBytes(out);
        return out;
    }

    static byte[] recoverPublicKeyECDSAFromSignature(int recId, BigInteger r, BigInteger s, byte[] messageHash) {
        if (recId != 0 && recId != 1) {
            throw new IllegalArgumentException("Recovery Id must be 0 or 1 for secp256k1.");
        }
        if (r.signum() < 0 || s.signum() < 0) {
            throw new IllegalArgumentException("'r' and 's' shouldn't be negative.");
        }
        ECPoint R = Crypto.decompressKey(r, (recId & 1) == 1);
        if (R == null || !R.multiply(ECDSA_SECP256K1_DOMAIN.getN()).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, messageHash);
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(ECDSA_SECP256K1_DOMAIN.getN());
        BigInteger rInv = r.modInverse(ECDSA_SECP256K1_DOMAIN.getN());
        BigInteger srInv = rInv.multiply(s).mod(ECDSA_SECP256K1_DOMAIN.getN());
        BigInteger eInvrInv = rInv.multiply(eInv).mod(ECDSA_SECP256K1_DOMAIN.getN());
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)ECDSA_SECP256K1_DOMAIN.getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv);
        if (q.isInfinity()) {
            return null;
        }
        return q.getEncoded(true);
    }

    private static ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter X_9_INTEGER_CONVERTER = new X9IntegerConverter();
        byte[] compEnc = X_9_INTEGER_CONVERTER.integerToBytes(xBN, 1 + X_9_INTEGER_CONVERTER.getByteLength(ECDSA_SECP256K1_DOMAIN.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        try {
            return ECDSA_SECP256K1_DOMAIN.getCurve().decodePoint(compEnc);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

