/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.esaulpaugh.headlong.rlp.RLPDecoder;
import com.esaulpaugh.headlong.rlp.RLPEncoder;
import com.esaulpaugh.headlong.rlp.RLPItem;
import com.esaulpaugh.headlong.util.Integers;
import com.google.common.base.MoreObjects;
import com.hedera.hashgraph.sdk.EthereumTransactionData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.util.encoders.Hex;

public class EthereumTransactionDataEip1559
extends EthereumTransactionData {
    public byte[] chainId;
    public byte[] nonce;
    public byte[] maxPriorityGas;
    public byte[] maxGas;
    public byte[] gasLimit;
    public byte[] to;
    public byte[] value;
    public byte[] accessList;
    public byte[] recoveryId;
    public byte[] r;
    public byte[] s;

    EthereumTransactionDataEip1559(byte[] chainId, byte[] nonce, byte[] maxPriorityGas, byte[] maxGas, byte[] gasLimit, byte[] to, byte[] value, byte[] callData, byte[] accessList, byte[] recoveryId, byte[] r, byte[] s) {
        super(callData);
        this.chainId = chainId;
        this.nonce = nonce;
        this.maxPriorityGas = maxPriorityGas;
        this.maxGas = maxGas;
        this.gasLimit = gasLimit;
        this.to = to;
        this.value = value;
        this.accessList = accessList;
        this.recoveryId = recoveryId;
        this.r = r;
        this.s = s;
    }

    public static EthereumTransactionDataEip1559 fromBytes(byte[] bytes) {
        Iterator decoder = RLPDecoder.RLP_STRICT.sequenceIterator(bytes);
        RLPItem rlpItem = (RLPItem)decoder.next();
        byte typeByte = rlpItem.asByte();
        if (typeByte != 2) {
            throw new IllegalArgumentException("rlp type byte " + typeByte + "is not supported");
        }
        rlpItem = (RLPItem)decoder.next();
        if (!rlpItem.isList()) {
            throw new IllegalArgumentException("expected RLP element list");
        }
        List rlpList = rlpItem.asRLPList().elements();
        if (rlpList.size() != 12) {
            throw new IllegalArgumentException("expected 12 RLP encoded elements, found " + rlpList.size());
        }
        return new EthereumTransactionDataEip1559(((RLPItem)rlpList.get(0)).data(), ((RLPItem)rlpList.get(1)).data(), ((RLPItem)rlpList.get(2)).data(), ((RLPItem)rlpList.get(3)).data(), ((RLPItem)rlpList.get(4)).data(), ((RLPItem)rlpList.get(5)).data(), ((RLPItem)rlpList.get(6)).data(), ((RLPItem)rlpList.get(7)).data(), ((RLPItem)rlpList.get(8)).data(), ((RLPItem)rlpList.get(9)).data(), ((RLPItem)rlpList.get(10)).data(), ((RLPItem)rlpList.get(11)).data());
    }

    @Override
    public byte[] toBytes() {
        return RLPEncoder.sequence((Object[])new Object[]{Integers.toBytes((int)2), List.of(this.chainId, this.nonce, this.maxPriorityGas, this.maxGas, this.gasLimit, this.to, this.value, this.callData, new ArrayList(), this.recoveryId, this.r, this.s)});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("chainId", (Object)Hex.toHexString((byte[])this.chainId)).add("nonce", (Object)Hex.toHexString((byte[])this.nonce)).add("maxPriorityGas", (Object)Hex.toHexString((byte[])this.maxPriorityGas)).add("maxGas", (Object)Hex.toHexString((byte[])this.maxGas)).add("gasLimit", (Object)Hex.toHexString((byte[])this.gasLimit)).add("to", (Object)Hex.toHexString((byte[])this.to)).add("value", (Object)Hex.toHexString((byte[])this.value)).add("accessList", (Object)Hex.toHexString((byte[])this.accessList)).add("recoveryId", (Object)Hex.toHexString((byte[])this.recoveryId)).add("r", (Object)Hex.toHexString((byte[])this.r)).add("s", (Object)Hex.toHexString((byte[])this.s)).toString();
    }
}

