/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.proto.SubType;

public enum FeeDataType {
    DEFAULT(SubType.DEFAULT),
    TOKEN_FUNGIBLE_COMMON(SubType.TOKEN_FUNGIBLE_COMMON),
    TOKEN_NON_FUNGIBLE_UNIQUE(SubType.TOKEN_NON_FUNGIBLE_UNIQUE),
    TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES(SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES),
    TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES(SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES),
    SCHEDULE_CREATE_CONTRACT_CALL(SubType.SCHEDULE_CREATE_CONTRACT_CALL);

    final SubType code;

    private FeeDataType(SubType code) {
        this.code = code;
    }

    static FeeDataType valueOf(SubType code) {
        return switch (code) {
            case SubType.DEFAULT -> DEFAULT;
            case SubType.TOKEN_FUNGIBLE_COMMON -> TOKEN_FUNGIBLE_COMMON;
            case SubType.TOKEN_NON_FUNGIBLE_UNIQUE -> TOKEN_NON_FUNGIBLE_UNIQUE;
            case SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES -> TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES;
            case SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES -> TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES;
            case SubType.SCHEDULE_CREATE_CONTRACT_CALL -> SCHEDULE_CREATE_CONTRACT_CALL;
            default -> throw new IllegalStateException("(BUG) unhandled SubType (FeeDataType)");
        };
    }

    public String toString() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case DEFAULT -> "DEFAULT";
            case TOKEN_FUNGIBLE_COMMON -> "TOKEN_FUNGIBLE_COMMON";
            case TOKEN_NON_FUNGIBLE_UNIQUE -> "TOKEN_NON_FUNGIBLE_UNIQUE";
            case TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES -> "TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES";
            case TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES -> "TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES";
            case SCHEDULE_CREATE_CONTRACT_CALL -> "SCHEDULE_CREATE_CONTRACT_CALL";
        };
    }
}

