/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.Client;
import com.hedera.hashgraph.sdk.Hbar;
import com.hedera.hashgraph.sdk.InstantConverter;
import com.hedera.hashgraph.sdk.Key;
import com.hedera.hashgraph.sdk.KeyList;
import com.hedera.hashgraph.sdk.TransactionId;
import com.hedera.hashgraph.sdk.proto.FileCreateTransactionBody;
import com.hedera.hashgraph.sdk.proto.FileServiceGrpc;
import com.hedera.hashgraph.sdk.proto.SchedulableTransactionBody;
import com.hedera.hashgraph.sdk.proto.Transaction;
import com.hedera.hashgraph.sdk.proto.TransactionBody;
import com.hedera.hashgraph.sdk.proto.TransactionResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.grpc.MethodDescriptor;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Objects;
import javax.annotation.Nullable;

public final class FileCreateTransaction
extends com.hedera.hashgraph.sdk.Transaction<FileCreateTransaction> {
    @Nullable
    private Instant expirationTime = null;
    @Nullable
    private KeyList keys = null;
    private byte[] contents = new byte[0];
    private String fileMemo = "";

    public FileCreateTransaction() {
        this.setExpirationTime(Instant.now().plus(DEFAULT_AUTO_RENEW_PERIOD));
        this.defaultMaxTransactionFee = new Hbar(5L);
    }

    FileCreateTransaction(LinkedHashMap<TransactionId, LinkedHashMap<AccountId, Transaction>> txs) throws InvalidProtocolBufferException {
        super(txs);
        this.initFromTransactionBody();
    }

    FileCreateTransaction(TransactionBody txBody) {
        super(txBody);
        this.initFromTransactionBody();
    }

    @Nullable
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="An Instant can't actually be mutated")
    public Instant getExpirationTime() {
        return this.expirationTime;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"}, justification="An Instant can't actually be mutated")
    public FileCreateTransaction setExpirationTime(Instant expirationTime) {
        this.requireNotFrozen();
        Objects.requireNonNull(expirationTime);
        this.expirationTime = expirationTime;
        return this;
    }

    @Nullable
    public Collection<Key> getKeys() {
        return this.keys != null ? Collections.unmodifiableCollection(this.keys) : null;
    }

    public FileCreateTransaction setKeys(Key ... keys) {
        this.requireNotFrozen();
        this.keys = KeyList.of(keys);
        return this;
    }

    public ByteString getContents() {
        return ByteString.copyFrom((byte[])this.contents);
    }

    public FileCreateTransaction setContents(byte[] bytes) {
        this.requireNotFrozen();
        Objects.requireNonNull(bytes);
        this.contents = Arrays.copyOf(bytes, bytes.length);
        return this;
    }

    public FileCreateTransaction setContents(String text) {
        this.requireNotFrozen();
        Objects.requireNonNull(text);
        this.contents = text.getBytes(StandardCharsets.UTF_8);
        return this;
    }

    public String getFileMemo() {
        return this.fileMemo;
    }

    public FileCreateTransaction setFileMemo(String memo) {
        this.requireNotFrozen();
        Objects.requireNonNull(memo);
        this.fileMemo = memo;
        return this;
    }

    @Override
    MethodDescriptor<Transaction, TransactionResponse> getMethodDescriptor() {
        return FileServiceGrpc.getCreateFileMethod();
    }

    @Override
    void validateChecksums(Client client) {
    }

    void initFromTransactionBody() {
        FileCreateTransactionBody body = this.sourceTransactionBody.getFileCreate();
        if (body.hasExpirationTime()) {
            this.expirationTime = InstantConverter.fromProtobuf(body.getExpirationTime());
        }
        if (body.hasKeys()) {
            this.keys = KeyList.fromProtobuf(body.getKeys(), null);
        }
        this.contents = body.getContents().toByteArray();
        this.fileMemo = body.getMemo();
    }

    FileCreateTransactionBody.Builder build() {
        FileCreateTransactionBody.Builder builder = FileCreateTransactionBody.newBuilder();
        if (this.expirationTime != null) {
            builder.setExpirationTime(InstantConverter.toProtobuf(this.expirationTime));
        }
        if (this.keys != null) {
            builder.setKeys(this.keys.toProtobuf());
        }
        builder.setContents(ByteString.copyFrom((byte[])this.contents));
        builder.setMemo(this.fileMemo);
        return builder;
    }

    @Override
    void onFreeze(TransactionBody.Builder bodyBuilder) {
        bodyBuilder.setFileCreate(this.build());
    }

    @Override
    void onScheduled(SchedulableTransactionBody.Builder scheduled) {
        scheduled.setFileCreate(this.build());
    }
}

