/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hashgraph.sdk;

import com.hedera.hashgraph.sdk.AccountId;
import com.hedera.hashgraph.sdk.BaseNode;
import com.hedera.hashgraph.sdk.BaseNodeAddress;
import com.hedera.hashgraph.sdk.HederaTrustManager;
import com.hedera.hashgraph.sdk.NodeAddress;
import io.grpc.ChannelCredentials;
import io.grpc.TlsChannelCredentials;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManager;

class Node
extends BaseNode<Node, AccountId> {
    private final AccountId accountId;
    @Nullable
    private NodeAddress addressBookEntry;
    private boolean verifyCertificates;

    Node(AccountId accountId, BaseNodeAddress address, ExecutorService executor) {
        super(address, executor);
        this.accountId = accountId;
    }

    Node(AccountId accountId, String address, ExecutorService executor) {
        this(accountId, BaseNodeAddress.fromString(address), executor);
    }

    Node(Node node, BaseNodeAddress address) {
        super(node, address);
        this.accountId = node.accountId;
        this.verifyCertificates = node.verifyCertificates;
        this.addressBookEntry = node.addressBookEntry;
    }

    Node toInsecure() {
        return new Node(this, this.address.toInsecure());
    }

    Node toSecure() {
        return new Node(this, this.address.toSecure());
    }

    @Override
    AccountId getKey() {
        return this.accountId;
    }

    AccountId getAccountId() {
        return this.accountId;
    }

    NodeAddress getAddressBookEntry() {
        return this.addressBookEntry;
    }

    Node setAddressBookEntry(@Nullable NodeAddress addressBookEntry) {
        this.addressBookEntry = addressBookEntry;
        return this;
    }

    boolean isVerifyCertificates() {
        return this.verifyCertificates;
    }

    Node setVerifyCertificates(boolean verifyCertificates) {
        this.verifyCertificates = verifyCertificates;
        return this;
    }

    @Override
    ChannelCredentials getChannelCredentials() {
        return TlsChannelCredentials.newBuilder().trustManager(new TrustManager[]{new HederaTrustManager(this.addressBookEntry == null ? null : this.addressBookEntry.certHash, this.verifyCertificates)}).build();
    }

    public String toString() {
        return this.address.toString() + "->" + this.accountId.toString();
    }
}

